use hahn;

$source_table = "//home/videoquality/vh_analytics/mma-3568-tele2/new_algo_test/2020-04-01_2020-04-30/reduced1";

$processReduced = ($row) -> {
    $base = RemoveMember($row, "s2_p13");
    $base = RemoveMember($base, "s2_p14");
    $base = RemoveMember($base, "s2_p15");
    return AsList(
        ExpandStruct(
            $base, "s2_p13" as s2_level, $row.s2_p13 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p14" as s2_level, $row.s2_p14 as s2_value
        ),
        ExpandStruct(
            $base, "s2_p15" as s2_level, $row.s2_p15 as s2_value
        ),
    )
};

$processed = (process $source_table using $processReduced(TableRow()));

$with_geounits_pre = (
    select s.*, geounits as geounit
    from $source_table as s
    inner join `//home/videolog/cell_id_to_geounit_schematized` as g using (s2_p13)
);

$with_geounits = (
    select
        *
    from $with_geounits_pre
    flatten list by geounit
);

$with_filials = (
    select s.*, filial, aggregation_type
    from $with_geounits as s
    inner join `//home/videolog/geounits_types` as g using (geounit)
);

$fielddateFormat = DateTime::Format("%Y-%m-%d");
$getFielddate = ($ts) -> {
    $ts = CAST($ts as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

$video_by_s2 = (
    select
        fielddate, -- упс
        s2_level,
        s2_value,
        operator,
        NetworkType,
        --- video metrics
        CountDistinctEstimate(DeviceIDVideo) as video_devices,
        COUNT_IF(throughput is not null) as video_chunks,
        SUM(start) as video_sessions,
        SUM(transferSize) / Math::Pow(1024, 3) as traffic_gb,
        SUM(refuse) / CAST(SUM(start) as Double) as refuse_share,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / CAST(SUM(start) as Double) as bufferizations_duration_per_view,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / SUM(view_time) * 60.0 as bufferizations_duration_per_min,
        (COUNT_IF(buffer_duration is not null) + 1) / CAST(SUM(start) as Double) as bufferizations_per_view,
        (COUNT_IF(buffer_duration is not null) + 1) / SUM(view_time) * 60.0 as bufferizations_per_min,
        PERCENTILE(first_buffer_duration, 0.05) as first_buffer_duration_p05,
        PERCENTILE(first_buffer_duration, 0.1) as first_buffer_duration_p10,
        PERCENTILE(first_buffer_duration, 0.2) as first_buffer_duration_p20,
        PERCENTILE(first_buffer_duration, 0.3) as first_buffer_duration_p30,
        PERCENTILE(first_buffer_duration, 0.4) as first_buffer_duration_p40,
        PERCENTILE(first_buffer_duration, 0.5) as first_buffer_duration_p50,
        PERCENTILE(first_buffer_duration, 0.6) as first_buffer_duration_p60,
        PERCENTILE(first_buffer_duration, 0.7) as first_buffer_duration_p70,
        PERCENTILE(first_buffer_duration, 0.8) as first_buffer_duration_p80,
        PERCENTILE(first_buffer_duration, 0.9) as first_buffer_duration_p90,
        PERCENTILE(first_buffer_duration, 0.95) as first_buffer_duration_p95,
        PERCENTILE(first_buffer_throughput, 0.05) as first_buffer_throughput_p05,
        PERCENTILE(first_buffer_throughput, 0.1) as first_buffer_throughput_p10,
        PERCENTILE(first_buffer_throughput, 0.2) as first_buffer_throughput_p20,
        PERCENTILE(first_buffer_throughput, 0.3) as first_buffer_throughput_p30,
        PERCENTILE(first_buffer_throughput, 0.4) as first_buffer_throughput_p40,
        PERCENTILE(first_buffer_throughput, 0.5) as first_buffer_throughput_p50,
        PERCENTILE(first_buffer_throughput, 0.6) as first_buffer_throughput_p60,
        PERCENTILE(first_buffer_throughput, 0.7) as first_buffer_throughput_p70,
        PERCENTILE(first_buffer_throughput, 0.8) as first_buffer_throughput_p80,
        PERCENTILE(first_buffer_throughput, 0.9) as first_buffer_throughput_p90,
        PERCENTILE(first_buffer_throughput, 0.95) as first_buffer_throughput_p95,
        PERCENTILE(quality, 0.05) as quality_p05,
        PERCENTILE(quality, 0.1) as quality_p10,
        PERCENTILE(quality, 0.2) as quality_p20,
        PERCENTILE(quality, 0.3) as quality_p30,
        PERCENTILE(quality, 0.4) as quality_p40,
        PERCENTILE(quality, 0.5) as quality_p50,
        PERCENTILE(quality, 0.6) as quality_p60,
        PERCENTILE(quality, 0.7) as quality_p70,
        PERCENTILE(quality, 0.8) as quality_p80,
        PERCENTILE(quality, 0.9) as quality_p90,
        PERCENTILE(quality, 0.95) as quality_p95,
        PERCENTILE(throughput, 0.05) as throughput_p05,
        PERCENTILE(throughput, 0.1) as throughput_p10,
        PERCENTILE(throughput, 0.2) as throughput_p20,
        PERCENTILE(throughput, 0.3) as throughput_p30,
        PERCENTILE(throughput, 0.4) as throughput_p40,
        PERCENTILE(throughput, 0.5) as throughput_p50,
        PERCENTILE(throughput, 0.6) as throughput_p60,
        PERCENTILE(throughput, 0.7) as throughput_p70,
        PERCENTILE(throughput, 0.8) as throughput_p80,
        PERCENTILE(throughput, 0.9) as throughput_p90,
        PERCENTILE(throughput, 0.95) as throughput_p95
        --- end video metrics
    from $processed
    where s2_value is not null --and SignalStrength not in (-51, -113, -141, 2147483647)
    and NetworkType != "DEFAULT"
    group by s2_level, s2_value, operator, NetworkType, $getFielddate(`timestamp`) as fielddate
    having CountDistinctEstimate(DeviceIDVideo) >= 10
);

$video_by_cell_lac = (
    select
        fielddate, Lac, CellID, NetworkType,
        --- video metrics
        CountDistinctEstimate(DeviceIDVideo) as video_devices,
        COUNT_IF(throughput is not null) as video_chunks,
        SUM(start) as video_sessions,
        SUM(transferSize) / Math::Pow(1024, 3) as traffic_gb,
        SUM(refuse) / CAST(SUM(start) as Double) as refuse_share,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / CAST(SUM(start) as Double) as bufferizations_duration_per_view,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / SUM(view_time) * 60.0 as bufferizations_duration_per_min,
        (COUNT_IF(buffer_duration is not null) + 1) / CAST(SUM(start) as Double) as bufferizations_per_view,
        (COUNT_IF(buffer_duration is not null) + 1) / SUM(view_time) * 60.0 as bufferizations_per_min,
        PERCENTILE(first_buffer_duration, 0.05) as first_buffer_duration_p05,
        PERCENTILE(first_buffer_duration, 0.1) as first_buffer_duration_p10,
        PERCENTILE(first_buffer_duration, 0.2) as first_buffer_duration_p20,
        PERCENTILE(first_buffer_duration, 0.3) as first_buffer_duration_p30,
        PERCENTILE(first_buffer_duration, 0.4) as first_buffer_duration_p40,
        PERCENTILE(first_buffer_duration, 0.5) as first_buffer_duration_p50,
        PERCENTILE(first_buffer_duration, 0.6) as first_buffer_duration_p60,
        PERCENTILE(first_buffer_duration, 0.7) as first_buffer_duration_p70,
        PERCENTILE(first_buffer_duration, 0.8) as first_buffer_duration_p80,
        PERCENTILE(first_buffer_duration, 0.9) as first_buffer_duration_p90,
        PERCENTILE(first_buffer_duration, 0.95) as first_buffer_duration_p95,
        PERCENTILE(first_buffer_throughput, 0.05) as first_buffer_throughput_p05,
        PERCENTILE(first_buffer_throughput, 0.1) as first_buffer_throughput_p10,
        PERCENTILE(first_buffer_throughput, 0.2) as first_buffer_throughput_p20,
        PERCENTILE(first_buffer_throughput, 0.3) as first_buffer_throughput_p30,
        PERCENTILE(first_buffer_throughput, 0.4) as first_buffer_throughput_p40,
        PERCENTILE(first_buffer_throughput, 0.5) as first_buffer_throughput_p50,
        PERCENTILE(first_buffer_throughput, 0.6) as first_buffer_throughput_p60,
        PERCENTILE(first_buffer_throughput, 0.7) as first_buffer_throughput_p70,
        PERCENTILE(first_buffer_throughput, 0.8) as first_buffer_throughput_p80,
        PERCENTILE(first_buffer_throughput, 0.9) as first_buffer_throughput_p90,
        PERCENTILE(first_buffer_throughput, 0.95) as first_buffer_throughput_p95,
        PERCENTILE(quality, 0.05) as quality_p05,
        PERCENTILE(quality, 0.1) as quality_p10,
        PERCENTILE(quality, 0.2) as quality_p20,
        PERCENTILE(quality, 0.3) as quality_p30,
        PERCENTILE(quality, 0.4) as quality_p40,
        PERCENTILE(quality, 0.5) as quality_p50,
        PERCENTILE(quality, 0.6) as quality_p60,
        PERCENTILE(quality, 0.7) as quality_p70,
        PERCENTILE(quality, 0.8) as quality_p80,
        PERCENTILE(quality, 0.9) as quality_p90,
        PERCENTILE(quality, 0.95) as quality_p95,
        PERCENTILE(throughput, 0.05) as throughput_p05,
        PERCENTILE(throughput, 0.1) as throughput_p10,
        PERCENTILE(throughput, 0.2) as throughput_p20,
        PERCENTILE(throughput, 0.3) as throughput_p30,
        PERCENTILE(throughput, 0.4) as throughput_p40,
        PERCENTILE(throughput, 0.5) as throughput_p50,
        PERCENTILE(throughput, 0.6) as throughput_p60,
        PERCENTILE(throughput, 0.7) as throughput_p70,
        PERCENTILE(throughput, 0.8) as throughput_p80,
        PERCENTILE(throughput, 0.9) as throughput_p90,
        PERCENTILE(throughput, 0.95) as throughput_p95
        --- end video metrics
    from $source_table
    where operator == "beeline"
    and NetworkType != "DEFAULT"
    group by Lac, CellID, NetworkType, $getFielddate(`timestamp`) as fielddate
    having CountDistinctEstimate(DeviceIDVideo) >= 10
);

$video_by_geounit = (
    select
        fielddate,
        geounit,
        operator,
        NetworkType,
        --- video metrics
        CountDistinctEstimate(DeviceIDVideo) as video_devices,
        COUNT_IF(throughput is not null) as video_chunks,
        SUM(start) as video_sessions,
        SUM(transferSize) / Math::Pow(1024, 3) as traffic_gb,
        SUM(refuse) / CAST(SUM(start) as Double) as refuse_share,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / CAST(SUM(start) as Double) as bufferizations_duration_per_view,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / SUM(view_time) * 60.0 as bufferizations_duration_per_min,
        (COUNT_IF(buffer_duration is not null) + 1) / CAST(SUM(start) as Double) as bufferizations_per_view,
        (COUNT_IF(buffer_duration is not null) + 1) / SUM(view_time) * 60.0 as bufferizations_per_min,
        PERCENTILE(first_buffer_duration, 0.05) as first_buffer_duration_p05,
        PERCENTILE(first_buffer_duration, 0.1) as first_buffer_duration_p10,
        PERCENTILE(first_buffer_duration, 0.2) as first_buffer_duration_p20,
        PERCENTILE(first_buffer_duration, 0.3) as first_buffer_duration_p30,
        PERCENTILE(first_buffer_duration, 0.4) as first_buffer_duration_p40,
        PERCENTILE(first_buffer_duration, 0.5) as first_buffer_duration_p50,
        PERCENTILE(first_buffer_duration, 0.6) as first_buffer_duration_p60,
        PERCENTILE(first_buffer_duration, 0.7) as first_buffer_duration_p70,
        PERCENTILE(first_buffer_duration, 0.8) as first_buffer_duration_p80,
        PERCENTILE(first_buffer_duration, 0.9) as first_buffer_duration_p90,
        PERCENTILE(first_buffer_duration, 0.95) as first_buffer_duration_p95,
        PERCENTILE(first_buffer_throughput, 0.05) as first_buffer_throughput_p05,
        PERCENTILE(first_buffer_throughput, 0.1) as first_buffer_throughput_p10,
        PERCENTILE(first_buffer_throughput, 0.2) as first_buffer_throughput_p20,
        PERCENTILE(first_buffer_throughput, 0.3) as first_buffer_throughput_p30,
        PERCENTILE(first_buffer_throughput, 0.4) as first_buffer_throughput_p40,
        PERCENTILE(first_buffer_throughput, 0.5) as first_buffer_throughput_p50,
        PERCENTILE(first_buffer_throughput, 0.6) as first_buffer_throughput_p60,
        PERCENTILE(first_buffer_throughput, 0.7) as first_buffer_throughput_p70,
        PERCENTILE(first_buffer_throughput, 0.8) as first_buffer_throughput_p80,
        PERCENTILE(first_buffer_throughput, 0.9) as first_buffer_throughput_p90,
        PERCENTILE(first_buffer_throughput, 0.95) as first_buffer_throughput_p95,
        PERCENTILE(quality, 0.05) as quality_p05,
        PERCENTILE(quality, 0.1) as quality_p10,
        PERCENTILE(quality, 0.2) as quality_p20,
        PERCENTILE(quality, 0.3) as quality_p30,
        PERCENTILE(quality, 0.4) as quality_p40,
        PERCENTILE(quality, 0.5) as quality_p50,
        PERCENTILE(quality, 0.6) as quality_p60,
        PERCENTILE(quality, 0.7) as quality_p70,
        PERCENTILE(quality, 0.8) as quality_p80,
        PERCENTILE(quality, 0.9) as quality_p90,
        PERCENTILE(quality, 0.95) as quality_p95,
        PERCENTILE(throughput, 0.05) as throughput_p05,
        PERCENTILE(throughput, 0.1) as throughput_p10,
        PERCENTILE(throughput, 0.2) as throughput_p20,
        PERCENTILE(throughput, 0.3) as throughput_p30,
        PERCENTILE(throughput, 0.4) as throughput_p40,
        PERCENTILE(throughput, 0.5) as throughput_p50,
        PERCENTILE(throughput, 0.6) as throughput_p60,
        PERCENTILE(throughput, 0.7) as throughput_p70,
        PERCENTILE(throughput, 0.8) as throughput_p80,
        PERCENTILE(throughput, 0.9) as throughput_p90,
        PERCENTILE(throughput, 0.95) as throughput_p95
        --- end video metrics
    from $with_geounits 
    where NetworkType != "DEFAULT"
    group by $getFielddate(`timestamp`) as fielddate, geounit, operator, NetworkType
    having CountDistinctEstimate(DeviceIDVideo) >= 10
);

$video_by_filial = (
    select
        fielddate,
        filial,
        aggregation_type,
        operator,
        NetworkType,
        --- video metrics
        CountDistinctEstimate(DeviceIDVideo) as video_devices,
        COUNT_IF(throughput is not null) as video_chunks,
        SUM(start) as video_sessions,
        SUM(transferSize) / Math::Pow(1024, 3) as traffic_gb,
        SUM(refuse) / CAST(SUM(start) as Double) as refuse_share,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / CAST(SUM(start) as Double) as bufferizations_duration_per_view,
        (SUM(first_buffer_duration) + SUM(buffer_duration)) / SUM(view_time) * 60.0 as bufferizations_duration_per_min,
        (COUNT_IF(buffer_duration is not null) + 1) / CAST(SUM(start) as Double) as bufferizations_per_view,
        (COUNT_IF(buffer_duration is not null) + 1) / SUM(view_time) * 60.0 as bufferizations_per_min,
        PERCENTILE(first_buffer_duration, 0.05) as first_buffer_duration_p05,
        PERCENTILE(first_buffer_duration, 0.1) as first_buffer_duration_p10,
        PERCENTILE(first_buffer_duration, 0.2) as first_buffer_duration_p20,
        PERCENTILE(first_buffer_duration, 0.3) as first_buffer_duration_p30,
        PERCENTILE(first_buffer_duration, 0.4) as first_buffer_duration_p40,
        PERCENTILE(first_buffer_duration, 0.5) as first_buffer_duration_p50,
        PERCENTILE(first_buffer_duration, 0.6) as first_buffer_duration_p60,
        PERCENTILE(first_buffer_duration, 0.7) as first_buffer_duration_p70,
        PERCENTILE(first_buffer_duration, 0.8) as first_buffer_duration_p80,
        PERCENTILE(first_buffer_duration, 0.9) as first_buffer_duration_p90,
        PERCENTILE(first_buffer_duration, 0.95) as first_buffer_duration_p95,
        PERCENTILE(first_buffer_throughput, 0.05) as first_buffer_throughput_p05,
        PERCENTILE(first_buffer_throughput, 0.1) as first_buffer_throughput_p10,
        PERCENTILE(first_buffer_throughput, 0.2) as first_buffer_throughput_p20,
        PERCENTILE(first_buffer_throughput, 0.3) as first_buffer_throughput_p30,
        PERCENTILE(first_buffer_throughput, 0.4) as first_buffer_throughput_p40,
        PERCENTILE(first_buffer_throughput, 0.5) as first_buffer_throughput_p50,
        PERCENTILE(first_buffer_throughput, 0.6) as first_buffer_throughput_p60,
        PERCENTILE(first_buffer_throughput, 0.7) as first_buffer_throughput_p70,
        PERCENTILE(first_buffer_throughput, 0.8) as first_buffer_throughput_p80,
        PERCENTILE(first_buffer_throughput, 0.9) as first_buffer_throughput_p90,
        PERCENTILE(first_buffer_throughput, 0.95) as first_buffer_throughput_p95,
        PERCENTILE(quality, 0.05) as quality_p05,
        PERCENTILE(quality, 0.1) as quality_p10,
        PERCENTILE(quality, 0.2) as quality_p20,
        PERCENTILE(quality, 0.3) as quality_p30,
        PERCENTILE(quality, 0.4) as quality_p40,
        PERCENTILE(quality, 0.5) as quality_p50,
        PERCENTILE(quality, 0.6) as quality_p60,
        PERCENTILE(quality, 0.7) as quality_p70,
        PERCENTILE(quality, 0.8) as quality_p80,
        PERCENTILE(quality, 0.9) as quality_p90,
        PERCENTILE(quality, 0.95) as quality_p95,
        PERCENTILE(throughput, 0.05) as throughput_p05,
        PERCENTILE(throughput, 0.1) as throughput_p10,
        PERCENTILE(throughput, 0.2) as throughput_p20,
        PERCENTILE(throughput, 0.3) as throughput_p30,
        PERCENTILE(throughput, 0.4) as throughput_p40,
        PERCENTILE(throughput, 0.5) as throughput_p50,
        PERCENTILE(throughput, 0.6) as throughput_p60,
        PERCENTILE(throughput, 0.7) as throughput_p70,
        PERCENTILE(throughput, 0.8) as throughput_p80,
        PERCENTILE(throughput, 0.9) as throughput_p90,
        PERCENTILE(throughput, 0.95) as throughput_p95
        --- end video metrics
    from $with_filials
    where NetworkType != "DEFAULT"
    group by $getFielddate(`timestamp`) as fielddate, filial, aggregation_type, operator, NetworkType
    having CountDistinctEstimate(DeviceIDVideo) >= 10
);

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/video_by_s2` WITH TRUNCATE 
select * from $video_by_s2;

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/video_by_cell_lac` WITH TRUNCATE 
select * from $video_by_cell_lac;

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/video_by_geounit` WITH TRUNCATE 
select * from $video_by_geounit;

insert into `//home/videoquality/vh_analytics/mma-3568-tele2/beeline_exports/april/video_by_filial` WITH TRUNCATE 
select * from $video_by_filial;