use @[cluster];
pragma yt.Pool = "@[pool]";
pragma yt.ParallelOperationsLimit = "@[parallel_operations_limit]";
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma library("helpers.sql");
import helpers symbols $getRR;

$source_table = "@[source_table]";
$output_table = "@[output_table]";



$s2_p13 = (
select
    -- "s2_p13" as s2_level,
    CellID as CellID,
    Lac as Lac,
    -- s2_p13 as s2_value,
    region,
    $wrapOperator(operator) as operator,
    NetworkType,
    CountDistinctEstimate(DeviceID) as radio_devices,
    CountDistinctEstimate(DeviceIDVideo) as video_devices,
    COUNT_IF(throughput is not null) as video_measurements,
    PERCENTILE(throughput, 0.1) as throughput_p10,
    PERCENTILE(throughput, 0.2) as throughput_p20,
    PERCENTILE(throughput, 0.3) as throughput_p30,
    PERCENTILE(throughput, 0.4) as throughput_p40,
    PERCENTILE(throughput, 0.5) as throughput_p50,
    PERCENTILE(throughput, 0.6) as throughput_p60,
    PERCENTILE(throughput, 0.7) as throughput_p70,
    PERCENTILE(throughput, 0.8) as throughput_p80,
    PERCENTILE(throughput, 0.9) as throughput_p90,
from $source_table
where s2_p13 is not null and $getRR(s2_p13) is not null
group by CellID, Lac, $getRR(s2_p13) as region, operator, NetworkType
);

insert into $output_table WITH TRUNCATE 
select * from $s2_p13;