use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.ParallelOperationsLimit = "4";
pragma library("helpers.sql");
import helpers symbols $get_mm_data_new;
PRAGMA yt.PublishedCompressionCodec = 'zstd_8';
PRAGMA yt.MinPublishedAvgChunkSize = '8G';
PRAGMA yt.PublishedErasureCodec = 'lrc_12_2_2';
pragma DqEngine = "disable";


$date_from = $date;
$date_to = $date;
$output_table = "//home/videoquality/vh_analytics/mma-3568-tele2/reduced_radio/" || $date;

$operator_dict = {
    "1": "mts",
    "11": "yota",
    "99": "beeline",
    "2": "megafon",
    "14": "megafon",
    "20": "tele2",
};

$fielddateFormat = DateTime::Format("%Y-%m-%d");
$getFielddate = ($ts) -> {
    $ts = CAST($ts as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

define subquery $get_radio_source() as
define subquery $source() as
select * from range(
    "//logs/appmetrica-location-log/1d", $date_from, $date_to
) with columns Struct<
    CollectTimestamp:String?,
    EventTimestamp:String?,
    NetworkType:String?,
    ConnectionType:String?,
    ClientIP:String?,
    OperatorID:String?
>;
end define;
select * from $get_mm_data_new($source);
end define;

$radio_source = (
    select
        m.*,
        unwrap($operator_dict[OperatorID]) as operator
    from $get_radio_source() as m
    where DictContains($operator_dict, OperatorID)
    and $getFielddate(`timestamp`) >= $date_from
    and $getFielddate(`timestamp`) <= $date_to
);

insert into $output_table WITH TRUNCATE
select s.* without Latitude, Longitude from $radio_source as s
where s2_p11 is not null
or s2_p12 is not null
or s2_p13 is not null;
