#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
from yql.api.v1.client import YqlClient
from videolog_common import date_range, YqlRunner


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = vars(parser.parse_args())

    with open("mobmet_15132_daily_radio_reduce.sql", encoding="utf8") as f:
        stub = f.read()

    yc = YqlClient(db="hahn")
    yr = YqlRunner(yc, title="MOBMET-15132 Daily Radio Reduce | YQL")
    for date in sorted(date_range(args["from"], args["to"])):
        print(f"processing {date}...")
        query = f"$date = '{date}';\n" + stub
        yr.run(query, attachments=["helpers.sql", "sphere_v2.py"])


if __name__ == "__main__":
    main()

