operator_dict = {
    b"1": b"mts",
    b"11": b"yota",
    b"99": b"beeline",
    b"2": b"megafon",
    b"14": b"megafon",
    b"20": b"tele2",
}

THRESHOLD = 60 * 10


def reducer(key, recs):
    last_network_rec = None
    last_cellinfo_rec = None
    last_location_rec = None
    fb_ts = 0
    fb_dur = 0
    first_buffer_measurement = False
    for rec in recs:
        if rec.NetworkType:
            last_network_rec = rec
        if rec.CellType and rec.CellID and rec.Lac:
            last_cellinfo_rec = rec
        if rec.s2_p13 and rec.s2_p14 and rec.s2_p15:
            last_location_rec = rec
        if (
            rec.SignalStrength
            and rec.DeviceID
            and last_location_rec
            and last_cellinfo_rec
            and (rec.timestamp - last_location_rec.timestamp) <= THRESHOLD
            and (rec.timestamp - last_cellinfo_rec.timestamp) <= THRESHOLD
            # and rec.OperatorID in operator_dict
        ):
            continue  # 2020-06-29: перехожу на режим забора данных по радио напрямую из мобметрики
            # yield {
            #     "yandexuid": key,
            #     "SignalStrength": rec.SignalStrength,
            #     "ip": rec.ip,
            #     "DeviceID": last_location_rec.DeviceID,
            #     "s2_p11": last_location_rec.s2_p11,
            #     "s2_p12": last_location_rec.s2_p12,
            #     "s2_p13": last_location_rec.s2_p13,
            #     "s2_p14": last_location_rec.s2_p14,
            #     "s2_p15": last_location_rec.s2_p15,
            #     "s2_p16": last_location_rec.s2_p16,
            #     "s2_p17": last_location_rec.s2_p17,
            #     "LocationSource": last_location_rec.LocationSource,
            #     "CellID": last_cellinfo_rec.CellID,
            #     "Lac": last_cellinfo_rec.Lac,
            #     "CellType": last_cellinfo_rec.CellType,
            #     "OperatorID": rec.OperatorID,
            #     "operator": operator_dict.get(rec.OperatorID),
            #     "timestamp": rec.timestamp
            # }
        if not (
            last_network_rec
            and last_location_rec
            and last_cellinfo_rec
            # and operator_dict[last_network_rec.OperatorID] == rec.operator
            and (rec.timestamp - last_network_rec.timestamp) <= THRESHOLD
            and (rec.timestamp - last_location_rec.timestamp) <= THRESHOLD
            and (rec.timestamp - last_cellinfo_rec.timestamp) <= THRESHOLD
        ):
            continue
        result = {
            "yandexuid": key,
            "s2_p11": last_location_rec.s2_p11,
            "s2_p12": last_location_rec.s2_p12,
            "s2_p13": last_location_rec.s2_p13,
            "s2_p14": last_location_rec.s2_p14,
            "s2_p15": last_location_rec.s2_p15,
            "s2_p16": last_location_rec.s2_p16,
            "s2_p17": last_location_rec.s2_p17,
            "LocationSource": last_location_rec.LocationSource,
            "CellID": last_cellinfo_rec.CellID,
            "OperatorID": last_cellinfo_rec.OperatorID,
            "Lac": last_cellinfo_rec.Lac,
            "CellType": last_cellinfo_rec.CellType,
            "NetworkType": last_network_rec.NetworkType,
            "operator": (
                rec.operator
                if operator_dict.get(
                    last_cellinfo_rec.OperatorID
                ) == rec.operator
                else None
            ),
            "ip": rec.ip,
            "DeviceIDVideo": last_network_rec.DeviceID,
            "timestamp": rec.timestamp
        }
        if rec.throughput and rec.throughput > 0:
            result.update({
                "throughput": rec.throughput,
                "quality": rec.quality,
                "transferSize": rec.transferSize,
            })
            if first_buffer_measurement:
                fb_dur += rec.duration
                fb_ts += rec.transferSize
        elif rec.event == b"start":
            result["start"] = 1
            first_buffer_measurement = True
        elif rec.event == b"refuse":
            result["refuse"] = 1
        elif rec.event == b"heartbeat":
            result["view_time"] = rec.duration
        elif rec.event == b"first_buffer":
            result["first_buffer_duration"] = rec.buffer_duration
            if fb_dur:
                result["first_buffer_throughput"] = (fb_ts / fb_dur) * 8.0
            first_buffer_measurement = False
            fb_ts = 0
            fb_dur = 0
        elif rec.event == b"buffer":
            result["buffer_duration"] = rec.buffer_duration
        else:
            continue
        yield result
