use @[cluster];
pragma yt.Pool = "@[pool]";
pragma yt.ParallelOperationsLimit = "@[parallel_operations_limit]";
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma library("helpers.sql");
pragma yt.MaxJobCount = "99999";
import helpers symbols $parseCellsTypes, $parseIntList,
    $re_yandexuid, $parseIntList, $getOperator, $getQuality,
    $isRussia, $geoOk, $parseCellsTypes, $radioOk,
    $getWifiSsid, $get_true_first_buffer_durations,
    $sessionsExtractStalledInfo, $getHeartbeatsTimestamps,
    $sessionsProcessor, $getRadioData, $get_mm_data;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";
$mm_root = "@[mm_root]";

$yandexuids = (
    select
        fielddate, yandexuid, vsid, $getOperator(some(provider)) as operator
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where os_family in ('iOS', 'Android') and country == 'RU'
    and $getOperator(provider) is not null
    and length(vsid) in (62, 64)
    and $re_yandexuid(yandexuid)
    group by yandexuid, vsid, fielddate
);

$sessions_map = (
    select
        fielddate,
        yandexuid,
        vsid,
        ip,
        `timestamp`,
        $getOperator(provider) as operator,
        $sessionsExtractStalledInfo(errors).all_stalleds as all_stalleds,
        $sessionsExtractStalledInfo(errors).first_buffer_duration as first_buffer_duration_sessions,
        $sessionsExtractStalledInfo(errors).first_buffer_rel_time + `timestamp` as first_buffer_timestamp_sessions,
        $getHeartbeatsTimestamps(heartbeats, `timestamp`) as heartbeats_timestamps,
        FIND(sources_aggr, "start") is not null and FIND(sources_aggr, "heartbeat") is null as refuse,
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where os_family in ('iOS', 'Android') and country == 'RU'
    and $getOperator(provider) is not null
    and length(vsid) in (62, 64)
    and $re_yandexuid(yandexuid)
);

$sessions_map_joined = (
    select
        s.*,
        g.stalledInitDuration as first_buffer_duration_gogol,
        g.`timestamp` as first_buffer_timestamp_gogol
    from $sessions_map as s
    left join any $get_true_first_buffer_durations($date_from, $date_to) as g
    using (fielddate, vsid)
);

$perf_map = (
    select
        TableName() as fielddate,
        "perf" as source_log,
        _logfeller_timestamp as `timestamp`,
        remote_ip as ip,
        CAST(responseEnd as Double) - cast(requestStart as Double) as duration,
        cast(transferSize as Double) as transferSize,
        Url::GetCGIParam(request, "vsid") as vsid,
        $getQuality(request) as quality,
        (
            CAST(transferSize as Double) / (
                CAST(responseEnd as Double) - cast(requestStart as Double)
            )
        ) * 8.0 as throughput
    from range(
        `logs/strm-perf-log/1d`, $date_from, $date_to
    )
    where length(Url::GetCGIParam(request, "vsid")) in (62, 64)
);

$perf_joined = (
    select
        p.*,
        yandexuid,
        operator
    from $perf_map as p
    inner join $yandexuids as y using (vsid)
);

$yandexuid_whitelist = select distinct yandexuid from $yandexuids;
$yandexuid_to_device_id = (
    select * from `//home/crypta/production/state/graph/v2/matching/by_id/yandexuid/direct/mm_device_id` as crypta
    left semi join $yandexuid_whitelist as wh on (crypta.id == wh.yandexuid)
);

-- define subquery $mm_source() as
-- select * from range(
--     $mm_root, $date_from, $date_to
-- ) with columns Struct<
--     EventTimestamp:String?,
--     CollectTimestamp:String?,
--     LocationTimestamp:String?,
-- >;
-- end define;

--TODO: переделать совместимо со старой версией!!
define subquery $mm_source() as
select * from range(
    `logs/appmetrica-location-log/1d`, $date_from, $date_to
) with columns Struct<
    EventTimestamp:String?,
    CollectTimestamp:String?,
    LocationTimestamp:String?,
>
union all
select EventTimestamp, NetworkType, OperatorID, OperatorName, ConnectionType
from range(
    `logs/appmetrica-yandex-events/1d`, $date_from, $date_to
);
end define;

$mm_joined = (
    select
        m.*,
        y.id as yandexuid
    from $get_mm_data($mm_source) as m
    inner join $yandexuid_to_device_id as y on (y.target_id == m.DeviceID)
);

$processed = process $sessions_map_joined using $sessionsProcessor(TableRow());

-- insert into $output_table with truncate
$mapped = (
    select * from $perf_joined
    union all
    select * from $mm_joined
    union all
    select * from $processed
);
-- order by yandexuid, `timestamp`

$input_type = Struct<
    'CellID':Int64?,
    'CellType':String?,
    'ConnectionType':String?,
    'DeviceID':String?,
    'Lac':Int64?,
    'Latitude':Double?,
    'LocationPrecision':Uint64?,
    'LocationSource':String?,
    'Longitude':Double?,
    'NetworkType':String?,
    'OperatorID':String?,
    'OperatorName':String?,
    'SignalStrength':Int64?,
    'WifiSsid':String?,
    'Wifi_Ssids':List<String>?,
    'duration':Double?,
    'fielddate':String?,
    'location_timestamp':Uint64?,
    'operator':String?,
    'ip':String?,
    's2_p11':Uint64?,
    's2_p12':Uint64?,
    's2_p13':Uint64?,
    's2_p14':Uint64?,
    's2_p15':Uint64?,
    's2_p16':Uint64?,
    's2_p17':Uint64?,
    'quality':Uint64?,
    'source_log':String,
    'throughput':Double?,
    'timestamp':Int64?,
    'transferSize':Double?,
    'vsid':String?,
    'yandexuid':String?,
    'buffer_duration':Double?,
    'event':String?,
>;

$output_type = Struct<
    's2_p11':Uint64?,
    's2_p12':Uint64?,
    's2_p13':Uint64?,
    's2_p14':Uint64?,
    's2_p15':Uint64?,
    's2_p16':Uint64?,
    's2_p17':Uint64?,
    'LocationSource':String?,
    'throughput':Double?,
    'operator':String?,
    'NetworkType':String?,
    'CellID':Int64?,
    'CellType':String?,
    'Lac':Int64?,
    'SignalStrength':Int64?,
    'ip':String?,
    'yandexuid':String?,
    'quality':Uint64?,
    'transferSize':Double?,
    'DeviceID':String?,
    'DeviceIDVideo':String?,
    'start':Int64?,
    'refuse':Int64?,
    'first_buffer_throughput':Double?,
    'first_buffer_duration':Double?,
    'buffer_duration':Double?,
    'view_time':Double?,
    'timestamp':Int64?
>;

$reducer = Python::reducer(
    Callable<(String?, Stream<$input_type>)->Stream<$output_type>>,
    FileContent("new_algo_reducer.py")
);



$source = (
    select
        if(s2_p11 is null, null, unwrap(s2_p11)) as s2_p11,
        if(s2_p12 is null, null, unwrap(s2_p12)) as s2_p12,
        if(s2_p13 is null, null, unwrap(s2_p13)) as s2_p13,
        if(s2_p14 is null, null, unwrap(s2_p14)) as s2_p14,
        if(s2_p15 is null, null, unwrap(s2_p15)) as s2_p15,
        if(s2_p16 is null, null, unwrap(s2_p16)) as s2_p16,
        if(s2_p17 is null, null, unwrap(s2_p17)) as s2_p17,
        t.* without t.s2_p11, t.s2_p12, t.s2_p13, t.s2_p14, t.s2_p15, t.s2_p16, t.s2_p17
    from $mapped as t
    where yandexuid is not null
);

$reduced = (
    reduce $source
    presort `timestamp`
    on yandexuid
    using $reducer(TableRow())
);

insert into $output_table with truncate
select * from $reduced;
