#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import datetime
import vh
try:
    basestring
except NameError:
    basestring = str

"""
To run: REQUESTS_CA_BUNDLE=/etc/ssl/certs/ python3 valhalla_ugc_push.py --from {date_from} --to {date_to}
"""


def date_range(from_, to_):
    if isinstance(from_, basestring):
        from_ = datetime.datetime.strptime(from_, '%Y-%m-%d').date()
    if isinstance(to_, basestring):
        to_ = datetime.datetime.strptime(to_, '%Y-%m-%d').date()
    mvr = min([from_, to_])
    result = []
    while mvr <= max([from_, to_]):
        result.append(mvr)
        mvr += datetime.timedelta(days=1)
    if to_ < from_:
        result = result[::-1]
    return result


# ECHO_OP_ID = "a0603967-154d-4201-a5f2-fb835ac19a5d"
# SVN_EXPORT_OP_ID = "7306fbe8-3ae7-4eb0-b846-e132649b9033"
OP_ID = "f4d5648e-d573-4696-aa1d-dba0503037fa"


def process_date(bunch, args):
    date_from = str(min(bunch))
    date_to = str(max(bunch))
    with vh.Graph() as graph:
        vh.op(id=OP_ID)(
            _options={
                "yt_token": "pecheny_yt_token",
                "yql_token": "pecheny_yql_token",
                "arcanum_token": "pecheny_arcanum_token",
                "ttl": 1440,
                "params_string": f"runner_v2.py --pool robot-mma-nirvana --from {date_from} --to {date_to}",
                "list_of_paths": [
                    "arcadia/analytics/videolog/videolog_common.py",
                    "arcadia/analytics/videolog/strm-stats/operators_data/v2/prepare_data/runner_v2.py",
                    "arcadia/analytics/videolog/strm-stats/operators_data/v2/prepare_data/prepare_data_new.sql",
                    "arcadia/analytics/videolog/strm-stats/operators_data/v2/prepare_data/helpers.sql",
                    "arcadia/analytics/videolog/strm-stats/operators_data/v2/prepare_data/new_algo_reducer.py",
                    "arcadia/analytics/videolog/strm-stats/operators_data/v2/prepare_data/sphere_v2.py",
                ]
            }
        )

        vh.run(
            graph,
            oauth_token=os.environ["NIRVANA_TOKEN"],
            workflow_guid="34dfcab2-0c93-4345-aad2-f728e86ab28e",
            wait=True,
            description=f"{date_from}_{date_to}",
            quota="mm-metrics",
            keep_going=True,
            api_retry_delay=60,
            api_retries=-1
        )


def split_to_bunches(dates, bunch_size=7):
    result = []
    while dates:
        bunch, dates = dates[:bunch_size], dates[bunch_size:]
        result.append(bunch)
    return result


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = parser.parse_args()

    from_ = getattr(args, "from")
    to_ = getattr(args, "to")
    bunches = split_to_bunches(date_range(from_, to_))
    for bunch in bunches:
        print("processing {}".format(bunch))
        process_date(bunch, args)


if __name__ == "__main__":
    main()
