#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    get_cluster,
    get_driver,
    get_dates_from_stat,
    get_date,
    YqlRunner,
    StatPusher,
    get_stat_headers,
)

ROOT = "//home/videolog/station_resolutions"
query_stub = """use hahn;
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

$date_from = "{date_from}";
$date_to = "{date_to}";
$output_table = "{output_table}";

insert into $output_table WITH TRUNCATE
SELECT
    fielddate,
    resolution ?? "_total_" as resolution,
    count(*) as `count`
from (
    SELECT
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        resolution
    from range(
        `cubes/video-strm`, $date_from, $date_to, `preprocessed`
    )
    where FIND(user_agent, "Station") is not null
    and event == "chunk"
    and source == "strm"
    and resolution is not null
    and resolution != '-'
)
group by fielddate, CUBE(resolution)
having count(*) >= 500"""


def process_dates(args, cl, yr):
    print("processing {}-{}".format(args["from"], args["to"]))
    output_table = "{}/{}_{}/report".format(ROOT, args["from"], args["to"])
    query = query_stub.format(
        date_from=args["from"], date_to=args["to"], output_table=output_table
    )
    yr.run(query, wait=True)
    sp = StatPusher(cl, report=args["report"])
    sp.push(output_table)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "--report", default="Video/Others/Strm/StationResolutions"
    )
    parser.add_argument("--from", "-f")
    parser.add_argument("--to", "-t")
    args = parser.parse_args()

    args = vars(args)

    yc = YqlClient(token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(yc, title="Station Quality | YQL")
    cl = get_cluster(clusters, args)
    yt = get_driver(cl).client

    if not args.get("from") or not args.get("to"):
        last_date = get_dates_from_stat(get_stat_headers(), args["report"])[-1]
        print("last date is {}".format(last_date))
        available_dates = sorted(
            get_date(x)
            for x in yt.search(
                root="//cubes/video-strm",
                node_type="table",
                path_filter=lambda x: x.endswith("/preprocessed"),
            )
            if get_date(x) > last_date
        )
        print("available_dates: {}".format(", ".join(map(str, available_dates[-5:]))))
        if available_dates:
            args["from"] = str(available_dates[0])
            args["to"] = str(available_dates[-1])
    if args.get("from") and args.get("to"):
        process_dates(args, cl, yr)
    else:
        print("nothing to process, exiting")


if __name__ == "__main__":
    main()
