use hahn;
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$out = "@[output_table]";

$getAvgBitrate = ($add_info) -> {
    $p0144 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/144")) ?? 0;
    $p0240 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/240")) ?? 0;
    $p0480 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/480")) ?? 0;
    $p0360 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/360")) ?? 0;
    $p0720 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/720")) ?? 0;
    $p0576 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/576")) ?? 0;
    $p1080 = Yson::ConvertToInt64(Yson::YPath($add_info, "/resolutions/1080")) ?? 0;
    RETURN (
        $p0144 * 144.0
        + $p0240 * 240.0
        + $p0480 * 480.0
        + $p0720 * 720.0
        + $p0576 * 576.0
        + $p0360 * 360.0
        + $p1080 * 1080.0
    ) / cast(
        $p0144 + $p0240
        + $p0360 + $p0480
        + $p0576 + $p0720
        + $p1080
    as Double
    )
};

$getStalleds = ($errors) -> {
    $errors = Yson::ConvertToList($errors);
    $errors = ListFlatMap($errors, ($x) -> {RETURN 
        IF(
            Yson::LookupString($x, "id_raw") == "Stalled",
            Yson::ConvertToInt64(Yson::YPath($x, "/details/stalledDuration")),
            NULL
        )
    });
    RETURN AsStruct(
        ListLength($errors) ?? 0 as stalleds,
        ListSum($errors) ?? 0.0 as stalleds_duration,
    )
};

$get_moscow_ts = ($ts) -> {
    $st = CAST(DateTime::FromSeconds(cast($ts + 10800 as Uint32)) as String);
    $st = String::ReplaceAll($st, "T", " ");
    $st = String::ReplaceAll($st, "Z", "");
    RETURN $st
};

$tmp = (
    select
        $get_moscow_ts(`timestamp` - (`timestamp` % 3600)) as fielddate,
        Geo::GetAsset(ip) ?? "empty" as a_system,
        view_type,
        os_family,
        Geo::RoundRegionByIp(ip, "region").name as region,
        $getAvgBitrate(add_info) as avg_bitrate,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/144")) ?? 0 as p0144,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/240")) ?? 0 as p0240,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/480")) ?? 0 as p0480,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/360")) ?? 0 as p0360,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/720")) ?? 0 as p0720,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/576")) ?? 0 as p0576,
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/1080")) ?? 0 as p1080,
        ref_from,
        yandexuid,
        IF(
            view_time >= 10 and Yson::LookupString(add_info, "sources_aggr") not like '%heartbeat%',
            0,
            view_time
        ) as view_time,
        $getStalleds(errors).stalleds as stalleds,
        $getStalleds(errors).stalleds_duration as stalleds_duration,
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where ((
        Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/144")) ?? 0 
        + Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/240")) ?? 0 
        + Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/480")) ?? 0 
        + Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/360")) ?? 0 
        + Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/720")) ?? 0 
        + Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/576")) ?? 0 
        + Yson::ConvertToInt64(Yson::YPath(add_info, "/resolutions/1080")) ?? 0
    ) > 0 or ref_from like '%quasar%') and (Yson::LookupString(add_info, "sources_aggr") like '%start%' or Yson::LookupString(add_info, "sources_aggr") like '%heartbeat%')
);

$zerowrap = ($x) -> {
    RETURN IF($x > 0, $x, NULL)
};

$grouped_by_yu = (
    select
        fielddate,
        yandexuid,
        ref_from,
        a_system,
        view_type,
        os_family,
        region,
        sum(view_time) as view_time,
        sum(stalleds) as stalleds,
        sum(stalleds_duration) ?? 0.0 as stalleds_duration,
        sum(p0144) as p0144,
        sum(p0240) as p0240,
        sum(p0360) as p0360,
        sum(p0480) as p0480,
        sum(p0576) as p0576,
        sum(p0720) as p0720,
        sum(p1080) as p1080,
        (sum(stalleds_duration) ?? 0.0) / cast(sum(view_time) / 60.0 as double) as stalleds_per_min,
        $zerowrap((
            sum(p0144) * 144.0
            + sum(p0240) * 240.0
            + sum(p0480) * 480.0
            + sum(p0720) * 720.0
            + sum(p0576) * 576.0
            + sum(p0360) * 360.0
            + sum(p1080) * 1080.0
        ) / cast(
            sum(p0144) + sum(p0240)
            + sum(p0360) + sum(p0480)
            + sum(p0576) + sum(p0720)
            + sum(p1080)
        as Double
        ))as avg_bitrate
    from $tmp
    group by fielddate,
        yandexuid,
        ref_from,
        a_system,
        view_type,
        os_family,
        region
    having sum(view_time) is not null and sum(view_time) >= 0
);

$input = (
    select
        fielddate,
        yandexuid,
        a_system ?? "unknown" as a_system,
        ref_from ?? "unknown" as ref_from,
        region ?? "unknown" as region,
        view_type ?? "unknown" as view_type,
        os_family ?? "unknown" as device_type,
        stalleds_per_min ?? 0.0 as stalleds_per_min,
        stalleds_duration ?? 0 as stalled_duration,
        stalleds_duration / (view_time / 60.0) as stalled_duration_per_min,
        view_time ?? 0.0 as view_time,
        view_time == 0 as refuse,
        avg_bitrate,
        p0144,
        p0240,
        p0360,
        p0480,
        p0576,
        p0720,
        p1080,
        stalleds,
    from $grouped_by_yu
);

$totalizer = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll(
        $result,
        ListMap($result, ($x) -> {RETURN AddMember(RemoveMember($x, "a_system"), "a_system", "_total_")})
    );
    $result = ListUnionAll(
        $result,
        ListMap($result, ($x) -> {RETURN AddMember(RemoveMember($x, "view_type"), "view_type", "_total_")})
    );
    $result = ListUnionAll(
        $result,
        ListMap($result, ($x) -> {RETURN AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")})
    );
    $result = ListUnionAll(
        $result,
        ListMap($result, ($x) -> {RETURN AddMember(RemoveMember($x, "region"), "region", "_total_")})
    );
    $result = ListUnionAll(
        $result,
        ListMap($result, ($x) -> {RETURN AddMember(RemoveMember($x, "device_type"), "device_type", "_total_")})
    );
    return $result
};

$totalized = (process $input using $totalizer(TableRow()));

$wrap = ($x) -> {
    RETURN(
        IF(CAST($x as String) in ("nan", "inf", "-nan", "-inf"), null, $x)
    )
};

$part2 = (
select
    fielddate,
    a_system,
    ref_from,
    region,
    view_type,
    device_type,
    count(distinct yandexuid) as yandexuids,
    count_if(refuse) / cast(count(*) as double) as refuse_share,
    count(*) as `count`,
    $wrap(avg(avg_bitrate)) as abr,
    sum(p0144) as p0144,
    sum(p0240) as p0240,
    sum(p0360) as p0360,
    sum(p0480) as p0480,
    sum(p0576) as p0576,
    sum(p0720) as p0720,
    sum(p1080) as p1080,
    IF(
        sum(stalleds) > 0,
        $wrap(sum(view_time) / cast(sum(stalleds) as Double)),
        NULL
    ) as mtbr,
    $wrap(sum(view_time)) as tvt,
    $wrap(percentile(stalleds_per_min, 0.01)) as stalleds_per_min_p01,
    $wrap(percentile(stalleds_per_min, 0.1)) as stalleds_per_min_p10,
    $wrap(percentile(stalleds_per_min, 0.5)) as stalleds_per_min_p50,
    $wrap(percentile(stalleds_per_min, 0.9)) as stalleds_per_min_p90,
    $wrap(percentile(stalleds_per_min, 0.99)) as stalleds_per_min_p99,
    sum(stalled_duration) as stalled_duration_total,
    $wrap(count_if(stalleds > 1) / cast(count(*) as double)) as stalleds_more_than_1_share,
    $wrap(count_if(stalleds > 2) / cast(count(*) as double)) as stalleds_more_than_2_share,
    $wrap(count_if(stalleds > 3) / cast(count(*) as double)) as stalleds_more_than_3_share,
    $wrap(count_if(stalleds > 4) / cast(count(*) as double)) as stalleds_more_than_4_share,
    $wrap(count_if(stalled_duration_per_min > 5.0) / cast(count(*) as double)) as stalled_dur_per_min_more_than_05_share,
    $wrap(count_if(stalled_duration_per_min > 10.0) / cast(count(*) as double)) as stalled_dur_per_min_more_than_10_share,
    $wrap(count_if(stalled_duration_per_min > 20.0) / cast(count(*) as double)) as stalled_dur_per_min_more_than_20_share,
    $wrap(count_if(stalled_duration_per_min > 30.0) / cast(count(*) as double)) as stalled_dur_per_min_more_than_30_share,
from $totalized
group by
    fielddate,
    a_system,
    ref_from,
    region,
    view_type,
    device_type
having count(*) >= 50
);

$enrich = ($row) -> {
    $sum = $row.p0144
        + $row.p0240
        + $row.p0360
        + $row.p0480
        + $row.p0576
        + $row.p0720
        + $row.p1080;
    $higher_than_144 = ($sum - $row.p0144) / cast($sum as Double);
    $higher_than_240 = ($sum - $row.p0144 - $row.p0240) / cast($sum as Double);
    $higher_than_360 = ($sum - $row.p0144 - $row.p0240 - $row.p0360) / cast($sum as Double);
    $higher_than_480 = ($row.p0576 + $row.p0720 + $row.p1080) / cast($sum as Double);
    $higher_than_576 = ($row.p0720 + $row.p1080) / cast($sum as Double);
    $higher_than_720 = ($row.p1080) / cast($sum as Double);
    RETURN ExpandStruct(
        $row,
        $wrap($higher_than_144) as higher_than_144_share,
        $wrap($higher_than_240) as higher_than_240_share,
        $wrap($higher_than_360) as higher_than_360_share,
        $wrap($higher_than_480) as higher_than_480_share,
        $wrap($higher_than_576) as higher_than_576_share,
        $wrap($higher_than_720) as higher_than_720_share,
    )
};

$part3 = (
    process $part2 using $enrich(TableRow())
);

insert into $out with truncate
select * from $part3