#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import argparse
import datetime
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    apply_replacements,
    date_range,
    get_cluster,
    get_driver,
    get_stat_headers,
    get_dates_from_stat,
    get_date,
    YqlRunner,
)

TITLE = "[CMS-1559] Zen Video Cost | YQL"

ATTACHMENTS = [
    {"path": "analytics/videolog/strm-stats/strm_cube_2/stability/stability_common.sql"}
]


def get_last_date(yt):
    return max(
        get_date(table)
        for table in yt.search(
            root="//home/videoquality/vh_analytics/zen_video_cost", node_type="table"
        )
    )


def process_dates(date_from, date_to, cluster, args):
    proxy = os.environ["YT_PROXY"]
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    with open("cms_1559_zen_video_cost_stub.sql", "rb") as f:
        query = f.read().decode("utf8")
    query = apply_replacements(
        query,
        {
            "@[pool]": args["pool"],
            "@[date_from]": str(date_from),
            "@[date_to]": str(date_to),
        },
    )
    yr.run(query, wait=True, attachments=ATTACHMENTS)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--pool", default="robot-mma-nirvana")
    parser.add_argument("--title", default=TITLE)
    parser.add_argument("--from")
    parser.add_argument("--to")
    parser.add_argument("--redo", action="store_true")
    args = vars(parser.parse_args())

    cluster = get_cluster(clusters, args)
    yt = get_driver(cluster).client

    if args["from"] and args["to"]:
        date_from = get_date(args["from"])
        date_to = get_date(args["to"])
    else:
        last_date = get_last_date(yt)
        last_available_date = max(
            get_date(x)
            for x in yt.search(
                root="//cubes/video-strm", path_filter=lambda x: x.endswith("/sessions")
            )
        )
        print("last date: {}".format(last_date))
        print("last available date: {}".format(last_available_date))
        if last_date >= last_available_date:
            print("no dates to process")
            sys.exit(0)
        date_from = last_date + datetime.timedelta(days=1)
        date_to = last_available_date

    if date_from and date_to:
        process_dates(date_from, date_to, cluster, args)
    else:
        print("no dates to process")


if __name__ == "__main__":
    main()
