use hahn;
pragma yt.ParallelOperationsLimit = "4";
pragma yt.Pool = "@[pool]";
pragma library("stability_common.sql");
import stability_common symbols $remappedWrapRefFrom, $dateRange;

$date_from = "@[date_from]";
$date_to = "@[date_to]";

$map = (
    select
        fielddate,
        `UUID`,
        page_id,
        price
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where ($remappedWrapRefFrom(ref_from) == "ZEN" or channel = "zen" or channel_old like "%zen%") and `UUID` is not null
);

$gr_ = (
    select
        fielddate, `UUID`, page_id, sum(price) / 1000000.0 as price_rub
    from $map
    group by fielddate, `UUID`, page_id
);

$gr = (
    select
        g.*, ugc_owner_id as puid
    from $gr_ as g
    left join any `//home/videolog/strm_meta/iron_branch/concat` as i on (g.`UUID` = i.`UUID`)
);

define action $process_date($date) as
$output_table = "//home/videoquality/vh_analytics/zen_video_cost/" || $date;
insert into $output_table with truncate
select * from $gr
where fielddate = $date;
end define;

evaluate for $date in $dateRange($date_from, $date_to)
    do $process_date($date);
