use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";
$tmp_table = "@[tmp_table]";
$bad_query_table = "@[bad_query_table]";

$badSymbols = Re2::Replace("[^a-zа-яё 0-9]");
$multiSpaces = Re2::Replace(" +");

$normalizeQuery = ($query)->{
    $query = CAST($query as Utf8);
    $query = Unicode::Fold($query, "Russian" as Language, false as DoRenyxa);
    $query = CAST($query as String);
    $query = $badSymbols($query, " ");
    $query = $multiSpaces($query, " ");
    $query = String::Strip($query);
    RETURN $query
};

$isCorona = ($q)->(
    $q like '%коронавирус%'
    or $q like '%корона вирус%'
    or $q like '%короно вирус%'
    or $q like '%короновирус%'
    or $q like '%covid%'
    or $q like '%кароновирус%'
    or $q like '%кароно вирус%'
    or $q like '%каронавирус%'
    or $q like '%карона вирус%'
);

$hasBig = ($Results) -> {
    $Results = Yson::ConvertToList($Results);
    RETURN IF(
        Yson::LookupString($Results[0], "Name") == "special" or Yson::LookupString($Results[1], "Name") == "special",
        1,
        0
    )
};

$hasMaps = ($Results) -> {
    $Results = Yson::ConvertToList($Results);
    RETURN IF(
        Yson::LookupString($Results[0], "Url") like "%//yandexrumapscovid19%" or Yson::LookupString($Results[1], "Url") like "%//yandexrumapscovid19%",
        1,
        0
    )
};

$hasSmall = ($Results) -> {
    $Results = Yson::ConvertToList($Results);
    RETURN IF(
        Yson::LookupString($Results[0], "Name") like "%pseudo_fast%" or Yson::LookupString($Results[1], "Name") LIKE "%pseudo_fast%",
        1,
        0
    )
};

$getBigClicks = ($Clicks) -> {
    $Clicks = Yson::ConvertToList($Clicks);
    $Clicks = ListMap($Clicks, ($x)->(IF(Yson::LookupString($x, "ConvertedPath") like "%wiz/special%", 1, 0)));
    RETURN ListSum($Clicks) ?? 0
};

$getSmallClicks = ($Clicks) -> {
    $Clicks = Yson::ConvertToList($Clicks);
    $Clicks = ListMap(
        $Clicks,
        ($x)->(IF(
            Yson::LookupString($x, "ConvertedPath") like "%wiz//link%"
            and Yson::LookupString($x, "Url") like "%yandex.ru/covid19%",
            1, 0)
        )
    );
    RETURN ListSum($Clicks) ?? 0
};

$getMapsClicks = ($Clicks) -> {
    $Clicks = Yson::ConvertToList($Clicks);
    $Clicks = ListMap(
        $Clicks,
        ($x)->(IF(
            Yson::LookupString($x, "ConvertedPath") like "%snippet/pseudo%"
            and (
                Yson::LookupString($x, "Url") like "%yandex.ru/web-maps/covid19%"
                OR Yson::LookupString($x, "Url") like "%//yandexrumapscovid19%"
            ),
            1, 0)
        )
    );
    RETURN ListSum($Clicks) ?? 0
};


$tmp = (
    select
        $normalizeQuery(Query) as query,
        `UI` as platform,
        `UID` as uid,
        unwrap(ListReverse(String::SplitToList(TablePath(), "/"))[1]) as fielddate,
        Query,
        Results,
        Clicks,
        $hasBig(Results) as big,
        $hasMaps(Results) as maps,
        $hasSmall(Results) as small,
        MAX_OF(
            $hasBig(Results),
            $hasMaps(Results),
            $hasSmall(Results)
        ) as any_wiz,
        $getBigClicks(Clicks) as big_cl,
        $getMapsClicks(Clicks) as maps_cl,
        $getSmallClicks(Clicks) as small_cl,
        $getBigClicks(Clicks) + $getSmallClicks(Clicks) + $getMapsClicks(Clicks) as any_wiz_cl,
        $isCorona($normalizeQuery(Query)) as corona_normalized,
        $isCorona(Query) as corona_raw,
    from range(
        `//home/dict/ontodb/squeezer`, $date_from, $date_to, `web`
    )
    where $isCorona($normalizeQuery(Query)) or $isCorona(Query)
);

insert into $tmp_table WITH TRUNCATE 
select platform, query, count(*) as `count`, sum(any_wiz) as any_wiz
from $tmp
where not (query like '%стопкоронавирус%' or query like '%стоп коронавирус%' or query like '%стоп короновирус%' or query like '%стопкороновирус%')
group by platform, query
order by `count` desc;

insert into $bad_query_table with TRUNCATE
select
    platform, query, count(*) as `count`, sum(any_wiz) as any_wiz
from $tmp
where not (query like '%стопкоронавирус%' or query like '%стоп коронавирус%' or query like '%стоп короновирус%' or query like '%стопкороновирус%')
group by platform, query
having sum(any_wiz) == 0
order by `count` desc;

$totalize = ($row)->(
    AsList($row, AddMember(RemoveMember($row, "platform"), "platform", "_total_"))
);

$totalized = (process $tmp using $totalize(TableRow()));

$grouped = (
    select
        fielddate,
        platform,
        COUNT(*) as queries,
        CountDistinctEstimate(query) as uniq_queries,
        CountDistinctEstimate(uid) as users_with_q,
        SUM(big) as special_shows,
        CountDistinctEstimate(IF(big == 1, query, NULL)) ?? 0 as special_queries,
        CountDistinctEstimate(IF(big == 1, uid, NULL)) ?? 0 as special_users,
        SUM(big_cl) as special_clicks,
        SUM(small) as small_shows,
        CountDistinctEstimate(IF(small == 1, query, NULL)) ?? 0 as small_queries,
        CountDistinctEstimate(IF(small == 1, uid, NULL)) ?? 0 as small_users,
        SUM(small_cl) as small_clicks,
        SUM(maps) as maps_shows,
        CountDistinctEstimate(IF(maps == 1, query, NULL)) ?? 0 as maps_queries,
        CountDistinctEstimate(IF(maps == 1, uid, NULL)) ?? 0 as maps_users,
        SUM(maps_cl) as maps_clicks,
        SUM(any_wiz) as any_shows,
        CountDistinctEstimate(IF(any_wiz == 1, query, NULL)) ?? 0 as any_queries,
        CountDistinctEstimate(IF(any_wiz == 1, uid, NULL)) ?? 0 as any_users,
        SUM(any_wiz_cl) as any_clicks,
    from $totalized
    group by fielddate, platform
);

insert into $output_table WITH TRUNCATE
select * from $grouped;
