use hahn;
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$re_kal = Re2::Capture("/(kal|stream)/([0-9A-Za-z-_]+?)/");
$re_vod = Re2::Capture("/([0-9A-Za-z-_]+?)-vod/");
$re_converted = Re2::Capture("/vh-([0-9A-Za-z-_]+?)-converted/");
$re_yandexuid = Re2::Match("[0-9]+1[23456][0-9]{8}");
$re_playerVersion = Re2::Capture("/(1.0-[0-9]+)/");
$re_audio_chunk = Re2::Grep("-a[0-9].+(ts|m4s)");
$re_video_chunk = Re2::Grep("-v[0-9].+(ts|m4s)");
$re_codec = Re2::Capture("(?P<chunk_type>(audio|video))_(?P<param1>[a-zA-Z0-9\-]+)_(?P<codec>[a-zA-Z0-9]+)_");
$re_ad_codec = Re2::Capture("/(?P<extension>[a-zA-Z0-9\-]+)/(?P<codec>[a-zA-Z0-9\-]+)_(?P<param1>[a-zA-Z0-9\-]+)_(?P<width>[0-9]+)_(?P<height>[0-9]+)");
$re_UUID = Re2::Capture("[^0-9a-f](4[0-9a-f]{31})[^0-9a-f]");
$re_request_ts = Re2::Capture("-([0-9]+?)[-\.]");
$re_x_y_p = Re2::Capture("(?P<width>[0-9]+)x(?P<height>[0-9]+)p");
$re_music_av = Re2::Capture("/(?P<chunk_type>(audio|video))/(?P<codec>[a-zA-Z0-9\-]+)/");


$wrapBrowser = ($user_agent, $parsedUA, $yastation) -> {
    RETURN
    CASE
    WHEN $yastation THEN "YandexStation"
    WHEN $parsedUA.BrowserName == "Tizen" and $parsedUA.BrowserVersion IS NOT NULL THEN "Tizen " || SUBSTRING($parsedUA.BrowserVersion, 0, 3)
    ELSE $parsedUA.BrowserName
    END
};

$getDeviceType = ($parsedUA) -> {
    RETURN CASE
    WHEN $parsedUA.isTV THEN "tv"
    WHEN NOT $parsedUA.isMobile THEN "desktop"
    WHEN $parsedUA.isTablet THEN "tablet"
    ELSE "phone"
    END
};

$getHash = ($x) -> { RETURN IF($x IS NOT NULL, Digest::Md5Hex($x || "e0440ebc0786e3d2cff6ef51319bc226"), NULL)};

$getYu = ($cookies) -> (Dsv::Parse($cookies, "; ")["yandexuid"]);

$undefWrapper = ($x) -> {
    RETURN IF(
        $x is null or $x in ("-", "undefined", "null", "", "0"),
        null,
        $x
    )
};
$undefWrapperInt = ($x) -> (IF($x not in (0, 1), $x));

$JsTracerPlayerEvents = AsDict(
    AsTuple("4SecWatched", "heartbeat"),
    AsTuple("10SecWatched", "heartbeat"),
    AsTuple("20SecWatched", "heartbeat"),
    AsTuple("30SecHeartbeat", "heartbeat"),
    AsTuple("AdEnd", "player_event"),
    AsTuple("AdPodEnd", "player_event"),
    AsTuple("AdPodStart", "player_event"),
    AsTuple("AdStart", "player_event"),
    AsTuple("BroadcastAdInit", "player_event"),
    AsTuple("BroadcastAdReceived", "player_event"),
    AsTuple("CreatePlayer", "create_player"),
    AsTuple("DestroyPlayer", "player_event"),
    AsTuple("PlayerAlive", "player_event"),
    AsTuple("End", "player_event"),
    AsTuple("HiddenAutoplayPrevented", "player_event"),
    AsTuple("NotReplacedBroadcastAdEnd", "player_event"),
    AsTuple("NotReplacedBroadcastAdStart", "player_event"),
    AsTuple("OriginalBroadcastAdEnd", "player_event"),
    AsTuple("OriginalBroadcastAdStart", "player_event"),
    AsTuple("PauseVideoOnVisibilityChange", "player_event"),
    AsTuple("PlayVideoOnVisibilityChange", "player_event"),
    AsTuple("PlayerFrameUnload", "player_event"),
    AsTuple("ReplacedBroadcastAdEnd", "player_event"),
    AsTuple("ReplacedBroadcastAdPodEnd", "player_event"),
    AsTuple("ReplacedBroadcastAdPodStart", "player_event"),
    AsTuple("ReplacedBroadcastAdStart", "player_event"),
    AsTuple("SetSource", "player_event"),
    AsTuple("Start", "start"),
    AsTuple("1002", "error"),
    AsTuple("1003", "error"),
    AsTuple("111", "error"),
    AsTuple("2152398850: Request failed", "error"),
    AsTuple("3015", "error"),
    AsTuple("3016", "error"),
    AsTuple("4012", "error"),
    AsTuple("4032", "error"),
    AsTuple("6001", "error"),
    AsTuple("6002", "error"),
    AsTuple("6006", "error"),
    AsTuple("6007", "error"),
    AsTuple("6008", "error"),
    AsTuple("6012", "error"),
    AsTuple("7001", "error"),
    AsTuple("DEMUXER_ERROR_COULD_NOT_OPEN: FFmpegDemuxer: open context failed", "error"),
    AsTuple("DRM_PROXY_ERROR", "error"),
    AsTuple("DRM_ERROR", "error"),
    AsTuple("NO_CHUNK_ERROR", "error"),
    AsTuple("DRM_PROXY_ERROR_SIGNATURE_EXPIRED", "error"),
    AsTuple("FAIRPLAY_CERT_LOAD_ERROR", "error"),
    AsTuple("FAIRPLAY_CREATE_MEDIA_KEYS_ERROR", "error"),
    AsTuple("FAIRPLAY_SPC_LOAD_ERROR", "error"),
    AsTuple("Failed to init decoder", "error"),
    AsTuple("FatalError", "error"),
    AsTuple("HLS_MEDIA_ERROR", "error"),
    AsTuple("HlsJsLoadSourceCalledTwice", "error"),
    AsTuple("INVALID_STREAM_URL", "error"),
    AsTuple("InvalidConfigElementInCreatePlayer", "error"),
    AsTuple("InvalidConfigInCreatePlayer", "error"),
    AsTuple("InvalidFragDuration", "error"),
    AsTuple("LoaderInitError", "error"),
    AsTuple("MEDIA_ELEMENT_ERROR: Format error", "error"),
    AsTuple("MEDIA_ERR_DECODE", "error"),
    AsTuple("MEDIA_ERR_SRC_NOT_SUPPORTED", "error"),
    AsTuple("MEDIA_NOT_PLAYING", "error"),
    AsTuple("MPD_NOT_SUPPORTED_ERROR", "error"),
    AsTuple("MPD_SHAKA_INIT_ERROR", "error"),
    AsTuple("MediaSequenceDrop", "error"),
    AsTuple("NATIVE_ENCODER_NON_FATAL_ERROR", "error"),
    AsTuple("NATIVE_HLS_NOT_SUPPORTED_ERROR", "error"),
    AsTuple("NO_PLAYABLE_STREAMS", "error"),
    AsTuple("NoFragLoad", "error"),
    AsTuple("ON_TICK_ERROR", "error"),
    AsTuple("PIPELINE_ERROR_DECODE", "error"),
    AsTuple("PIPELINE_ERROR_INITIALIZATION_FAILED", "error"),
    AsTuple("PLAY_AD_VIEWERS_ERROR", "error"),
    AsTuple("POST_MESSAGE_GET_CONFIG_TIMEOUT", "error"),
    AsTuple("PUBLIC_API_CALL_ERROR", "error"),
    AsTuple("RAA_TAKING_10SEC", "error"),
    AsTuple("RAA_TAKING_2SEC", "error"),
    AsTuple("REACT_COMPONENT_DID_CATCH_ERROR_INFO", "error"),
    AsTuple("REGIONAL_LIMITATION_LEVEL", "error"),
    AsTuple("REGIONAL_LIMITATION_MANIFEST", "error"),
    AsTuple("RecoverStreamError", "error"),
    AsTuple("SAGA_ERROR", "error"),
    AsTuple("SCRIPT_INIT_ERROR", "error"),
    AsTuple("STRM_ABD_INVALID_RESPONSE", "error"),
    AsTuple("Stalled", "error"),
    AsTuple("StalledEnd", "error"),
    AsTuple("UNABLE_TO_LOAD_PLAYER_IFRAME", "error"),
    AsTuple("UNHANDLED_GLOBAL_ERROR", "error"),
    AsTuple("UNHANDLED_PROMISE_REJECTION", "error"),
    AsTuple("UNSUPPORTED_MEDIA_TYPE", "error"),
    AsTuple("audioTrackLoadError", "error"),
    AsTuple("audioTrackLoadTimeOut", "error"),
    AsTuple("bufferAddCodecError", "error"),
    AsTuple("bufferAppendError", "error"),
    AsTuple("bufferAppendingError", "error"),
    AsTuple("bufferFullError", "error"),
    AsTuple("bufferNudgeOnStall", "error"),
    AsTuple("bufferSeekOverHole", "error"),
    AsTuple("fragLoadError", "error"),
    AsTuple("fragLoadTimeOut", "error"),
    AsTuple("fragParsingError", "error"),
    AsTuple("internalException", "error"),
    AsTuple("keyLoadError", "error"),
    AsTuple("keyLoadTimeOut", "error"),
    AsTuple("levelLoadError", "error"),
    AsTuple("levelLoadTimeOut", "error"),
    AsTuple("manifestLoadError", "error"),
    AsTuple("manifestLoadTimeOut", "error"),
    AsTuple("manifestParsingError", "error"),
    AsTuple("remuxAllocError", "error"),
    AsTuple("shaka.BAD_HTTP_STATUS_1001", "error"),
    AsTuple("shaka.BAD_HTTP_STATUS_1001_LICENSE", "error"),
    AsTuple("shaka.BAD_HTTP_STATUS_1001_MANIFEST", "error"),
    AsTuple("shaka.BAD_HTTP_STATUS_1001_SEGMENT", "error"),
    AsTuple("shaka.CONTENT_UNSUPPORTED_BY_BROWSER_4032", "error"),
    AsTuple("shaka.ERROR_11", "error"),
    AsTuple("shaka.ERROR_undefined", "error"),
    AsTuple("shaka.Error_0", "error"),
    AsTuple("shaka.Error_11", "error"),
    AsTuple("shaka.Error_4032", "error"),
    AsTuple("shaka.FAILED_TO_ATTACH_TO_VIDEO_6003", "error"),
    AsTuple("shaka.FAILED_TO_CREATE_CDM_6002", "error"),
    AsTuple("shaka.FAILED_TO_CREATE_SESSION_6005", "error"),
    AsTuple("shaka.FAILED_TO_GENERATE_LICENSE_REQUEST_6006", "error"),
    AsTuple("shaka.HTTP_ERROR_1002", "error"),
    AsTuple("shaka.HTTP_ERROR_1002_LICENSE", "error"),
    AsTuple("shaka.HTTP_ERROR_1002_MANIFEST", "error"),
    AsTuple("shaka.HTTP_ERROR_1002_SEGMENT", "error"),
    AsTuple("shaka.INVALID_SERVER_CERTIFICATE_6004", "error"),
    AsTuple("shaka.LICENSE_REQUEST_FAILED_6007", "error"),
    AsTuple("shaka.LICENSE_REQUEST_FAILED_DRM_PROXY_ERROR", "error"),
    AsTuple("shaka.LICENSE_REQUEST_FAILED_DRM_PROXY_ERROR_SIGNATURE_EXPIRED", "error"),
    AsTuple("shaka.LICENSE_RESPONSE_REJECTED_6008", "error"),
    AsTuple("shaka.MEDIA_SOURCE_OPERATION_THREW_3015", "error"),
    AsTuple("shaka.NO_LICENSE_SERVER_GIVEN_6012", "error"),
    AsTuple("shaka.QUOTA_EXCEEDED_ERROR_3017", "error"),
    AsTuple("shaka.REQUESTED_KEY_SYSTEM_CONFIG_UNAVAILABLE_6001", "error"),
    AsTuple("shaka.RESPONSE_FILTER_ERROR_1007", "error"),
    AsTuple("shaka.RESTRICTIONS_CANNOT_BE_MET_4012", "error"),
    AsTuple("shaka.TIMEOUT_1003", "error"),
    AsTuple("shaka.TIMEOUT_1003_LICENSE", "error"),
    AsTuple("shaka.TIMEOUT_1003_MANIFEST", "error"),
    AsTuple("shaka.UNSUPPORTED_SCHEME_1000", "error"),
    AsTuple("shaka.VIDEO_ERROR_3016", "error"),
    AsTuple("DrmDiagnostic", "error"),
    AsTuple("DrmNotSupported", "error"),
    AsTuple("DrmProxyConnection", "error"),
    AsTuple("DrmSession", "error"),
    AsTuple("InstantiatingDecoder", "error"),
    AsTuple("InternetConnection", "error"),
    AsTuple("ManifestParser", "error"),
    AsTuple("NoInternetConnection", "error"),
    AsTuple("Preparing", "error"),
    AsTuple("SubtitleNoDecoder", "error"),
    AsTuple("Unknown", "error"),
    AsTuple("UnsupportedAudio", "error"),
    AsTuple("UnsupportedVideo", "error"),
    AsTuple("VastTracking_onCreativeInit", "player_event"),
    AsTuple("VastTracking_start", "player_event"),
    AsTuple("VastTracking_thirdQuartile", "player_event"),
    AsTuple("VastTracking_skip", "player_event"),
    AsTuple("VastTracking_complete", "player_event"),
    AsTuple("VastTracking_impression", "player_event"),
    AsTuple("VastTracking_midpoint", "player_event"),
    AsTuple("VastTracking_mute", "player_event"),
    AsTuple("VastTracking_unmute", "player_event"),
    AsTuple("VastTracking_firstQuartile", "player_event"),
    AsTuple("Seek", "player_event"),
    AsTuple("PreloadQueued", "player_event"),
    AsTuple("PreloadFinished", "player_event"),
    AsTuple("PreloadCanceled", "player_event"),
    AsTuple("TracksDownloadTimeout", "player_event"),
    AsTuple("TracksDownload", "player_event"),
    AsTuple("ManifestDownload", "player_event"),
    AsTuple("SetVideoTrack", "player_event"),
);

$parseHeaders = ($s) -> {
    $split = String::SplitToList($s, "~");
    $FurtherSplit = ListMap(
        $split, ($x) -> {
            $sp = String::SplitToList($x, ": ", 1 as Limit);
            RETURN AsTuple(unwrap($sp[0]), $sp[1])
        }
    );
    RETURN ToDict($FurtherSplit)
};

$parseNewsHeaders = ($yson) -> {
    $headers = Yson::ConvertToList($yson);
    RETURN ToDict(
        ListMap($headers, ($x) -> {
            RETURN AsTuple(
                unwrap(Yson::LookupString($x, "name")),
                unwrap(Yson::LookupString($x, "value")),
            )
        })
    )
};

$zwrap = ($b)->{
    $b = cast($b as Int64);
    return if(
        $b >= 0 and $b <= 100,
        cast($b as String),
        null
    )
};

$getBucket = ($y) -> (Digest::CityHash($y || "some-salt") % 100);

$fixBucket = ($test_bucket, $y) -> {
    $test_bucket = String::SplitToList($test_bucket, ",");
    $testid = $test_bucket[0];
    $bucket = $zwrap($test_bucket[2]) ?? cast($getBucket($y) as String);
    return IF($testid is not null and $bucket is not null, unwrap($testid || ",0," || $bucket))
};

DEFINE SUBQUERY $aggregate_test_buckets($raw_test_buckets) AS
$step1 = (
select
    user_id,
    String::SplitToList(test_buckets, ";") as test_bucket
from $raw_test_buckets()
);

$step1a = (
    select
        user_id,
        unwrap($fixBucket(test_bucket, user_id)) as test_bucket
    from (select * from $step1 flatten list by test_bucket)
    where $fixBucket(test_bucket, user_id) is not null
);

$step2 = (
    select
        user_id,
        testid,
        some(test_bucket) as test_bucket
    from $step1a
    group by user_id, String::SplitToList(test_bucket, ",")[0] as testid
);

$step3 = (
    select
        user_id,
        String::JoinFromList(ListSort(aggregate_list(test_bucket)), ";") as test_buckets
    from $step2
    where testid != ""
    group by user_id
);

select * from $step3;
END DEFINE;

$getZenBucket = ($yandexuid, $testid)->(Digest::CityHash($yandexuid || $testid || "adyghe-salt") % 100);

$processZenGroupIds = ($yandexuid, $group_ids)->{
    $group_ids = ListMap(Yson::ConvertToList($group_ids), ($x)->(Yson::ConvertToInt64($x)));
    $lst = ListMap(
        $group_ids, ($x)->(
            CAST($x as String) || ",0," || cast($getZenBucket($yandexuid, CAST($x as String)) as String)
        )
    );
    $lst = ListNotNull($lst);
    return ListMap($lst, ($x)->(unwrap($x)))
};

$processZenExperiments = ($yandexuid, $experiments) -> {
    $exps = String::SplitToList($experiments, ",");
    $lst = ListMap(
        $exps,
        ($x)->($x || ",0," || cast($getZenBucket($yandexuid, $x) as String))
    );
    $lst = ListNotNull($lst);
    return ListMap($lst, ($x)->(unwrap($x)))
};

$get_zen_test_buckets = ($yandexuid, $group_ids, $experiments) -> {
    $yandexuid = CAST($yandexuid as String);
    $group_ids_buckets = $processZenGroupIds($yandexuid, $group_ids);
    $experiments_buckets = $processZenExperiments($yandexuid, $experiments);
    $final_list = ListExtend($group_ids_buckets ?? ListCreate(String), $experiments_buckets ?? ListCreate(String));
    RETURN String::JoinFromList($final_list, ";")
};

DEFINE SUBQUERY $get_raw_icookie_buckets(
    $access_log_table,
    $news_access_log_table,
    $morda_access_log_table,
    $zen_events_table,
    $hit_log_table,
    $apphost_table,
    $gogol_table
) AS
select
    unwrap(_logfeller_icookie) as user_id,
    unwrap($parseHeaders(headers)["X-Yandex-ExpBoxes"]) as test_buckets
from $access_log_table
where $parseHeaders(headers)["X-Yandex-ExpBoxes"] is not null and $undefWrapper(_logfeller_icookie) is not null
union all
select
    unwrap(iCookie) as user_id,
    unwrap($parseNewsHeaders(httpHeaders)["x-yandex-expboxes"]) as test_buckets
from $news_access_log_table
where $parseNewsHeaders(httpHeaders)["x-yandex-expboxes"] is not null and yandexUid is not null and $undefWrapper(iCookie) is not null and vhost == "yandex.ru"
union all
select
    unwrap(icookie) as user_id,
    unwrap(`test-bucket`) as test_buckets
from $morda_access_log_table with columns Struct<icookie:String?>
where `test-bucket` is not null and $undefWrapper(icookie) is not null
-- union all
-- select
--     unwrap(cast(icookie as String)) as user_id,
--     $get_zen_test_buckets(cast(icookie as String), group_ids, experiments) as test_buckets
-- from $zen_events_table
-- where $undefWrapper(cast(icookie as String)) is not null
-- and $undefWrapper($get_zen_test_buckets(cast(icookie as String), group_ids, experiments)) is not null
union all
select
    unwrap(icookie) as user_id,
    yandexexpboxes as test_buckets
from $hit_log_table
where $undefWrapper(icookie) is not null and $undefWrapper(yandexexpboxes) is not null
union all
select
    unwrap(Yson::LookupString(headers, "x-yandex-icookie")) as user_id,
    Yson::LookupString(headers, "x-yandex-expboxes") as test_buckets
from $apphost_table
where $undefWrapper(Yson::LookupString(headers, "x-yandex-icookie")) is not null and $undefWrapper(Yson::LookupString(headers, "x-yandex-expboxes")) is not null
;
END DEFINE;

DEFINE SUBQUERY $get_efir_history($efir_history_table, $fielddate) AS
$getDatesFromInfo = ($info) -> {
    $info = Yson::ConvertToDict($info);
    RETURN ListMap(
        DictKeys($info),
        ($x) -> {RETURN CAST($x as Date)}
    )
};

$getLastMonthActiveDays = ($info_list, $fielddate) -> {
    $fielddate = CAST($fielddate as Date);
    $active_dates = ListUniq(ListFlatMap(
        $info_list, $getDatesFromInfo
    ));
    RETURN ListLength(ListFilter(
        $active_dates, ($x) -> {
            RETURN $x <= $fielddate AND Datetime::ToDays($fielddate - $x) <= 30
        }
    ))
};

$getFirstVisit = ($info_list) -> {
    RETURN CAST(ListMin(ListUniq(ListFlatMap(
        $info_list, $getDatesFromInfo
    ))) AS String)
};

SELECT
    yu_hash,
    $getLastMonthActiveDays(AGGREGATE_LIST(info), $fielddate) as efir_last_month_active_days,
    $getFirstVisit(AGGREGATE_LIST(info)) as efir_first_visit
from $efir_history_table with columns Struct<yandexuid:String?,info:Yson?>
where yandexuid is not null
group by yandexuid as yu_hash;
END DEFINE;

DEFINE SUBQUERY $get_user_licenses($user_licenses_table, $fielddate) AS

$getLastLicense = ($licenses_dates) -> {
    $last_license = unwrap(ListReverse(ListSort(
        $licenses_dates, ($x) -> {
            RETURN ListMax($x.dates)
        }
    ))[0]);
    RETURN $last_license.user_subscription
};

SELECT
    yandexuid,
    $getLastLicense(licenses_dates) as user_license
from $user_licenses_table
WHERE DateTime::ToDays(
    CAST($fielddate as Date) - CAST(max_date as Date)
) <= 7;
END DEFINE;

$wrapYandexuid = ($candidate) -> {
    RETURN IF($re_yandexuid($candidate), $candidate, NULL)
};

$parseUA = ($user_agent) -> {
    $parsed = UserAgent::Parse($user_agent);
    $yastation = FIND($user_agent, "YandexStation") IS NOT NULL OR FIND($user_agent, "Yandex Station") IS NOT NULL;
    $browser_name = $wrapBrowser($user_agent, $parsed, $yastation);
    $browser_version = IF($yastation, "YandexStation", $parsed.BrowserVersion ?? "Unknown");
    $os_family = IF($yastation, "Android", $parsed.OSFamily ?? "Unknown");
    $device_type = $getDeviceType($parsed);
    RETURN AsStruct(
        $browser_name as browser_name,
        $browser_version as browser_version,
        $os_family as os_family,
        $device_type as device_type
    )
};

$strmNotBadRequest = ($request) -> {
    RETURN
        not String::Contains($request, "for-regional-cache=1")
        and not String::Contains($request, "monitoring=1")
        and not String::Contains($request, "hide_stub=1")
        and not String::Contains($request, "/get-video-an")
        and not String::Contains($request, "/timetail")
        and not String::Contains($request, "dvrpy=1")
        and not String::Contains($request, "/vh-bsvideo-converted/")
        and not String::Contains($request, "/vh-canvas-converted/")
        and not String::Contains($request, "/vh-adfox-converted/")
        and not String::Contains($request, "is_subrequest=1")
};

$ch1 = Pire::Grep("(ts|m4s|ism/.+Fragments.+)$");
$ch2 = Pire::Grep("(mp4|webm|ogv)$");
$pl = Pire::Grep("(m3u8|ismc|mpd)$");

$getStrmRequestType = ($uri) -> (
    case
    when $ch1($uri) or $ch2($uri) then "chunk"
    when $pl($uri) then "playlist"
    else null
    end
);

$parseSignedUrl = ($url) -> {
    $url = SUBSTRING($url, 0, FIND($url, "?"));
    $sp = ListFilter(String::SplitToList($url, "/"), ($x) -> {RETURN FIND($x, "=") IS NOT NULL});
    $sp = ListFlatMap($sp, ($x)->(String::SplitToList($x, ",")));
    RETURN ToDict(ListMap($sp, ($x)->(AsTuple(
        String::SplitToList($x, "=", 1 as Limit)[0],
        String::SplitToList($x, "=", 1 as Limit)[1],
    ))));
};

$getParamWrapper = ($request, $referer, $param) -> {
    $parsedSignedUrl = $parseSignedUrl($request);
    $param_from_signed = $parsedSignedUrl[$param];
    $param_from_request = Url::GetCGIParam($request, $param);
    $param_from_referer = Url::GetCGIParam($referer, $param);
    $stream_url = Url::Decode(Url::GetCGIParam($referer, "stream_url"));
    $param_from_stream_url = Url::GetCGIParam($stream_url, $param);
    $mq_url = Url::Decode(Url::GetCGIParam($referer, "mq_url"));
    $param_from_mq_url = Url::GetCGIParam($mq_url, $param);
    $param_from_additional_params = Yson::LookupString(
        Yson::ParseJson(
            Url::Decode(Url::GetCGIParam($referer, "additional_params"))
        ), $param
    );
    $candidate = $param_from_signed
    ?? $param_from_request
    ?? $param_from_referer
    ?? $param_from_stream_url
    ?? $param_from_additional_params
    ?? $param_from_mq_url;
    RETURN $undefWrapper($candidate)
};

$strmGetVsid = ($request, $referer) -> {
    $vsid = $getParamWrapper($request, $referer, "vsid");
    RETURN IF(Length($vsid) == 64, $vsid, NULL)
};

$getYuHash = ($request, $referer) -> {
    $hash = $getParamWrapper($request, $referer, "hash");
    $yandexuid = $wrapYandexuid($getParamWrapper($request, $referer, "yandexuid"));
    RETURN CASE
    WHEN $hash is not null then $hash
    WHEN $yandexuid is not null then $getHash($yandexuid)
    ELSE NULL
    END
};

$processLabel = ($x) -> {
    $len = unwrap(Length($x) - 1);
    $frag = substring($x, 0, cast($len as Uint32));
    return IF(cast($frag as Uint32) is not null, $frag)
};

$get_channel_old = ($request) -> {
    RETURN CASE
    WHEN String::Contains($request, "cdn1tvru") THEN "1tv"
    WHEN $re_converted($request)._1 is not null THEN $re_converted($request)._1
    WHEN $re_vod($request)._1 is not null THEN $re_vod($request)._1
    WHEN $re_kal($request)._2 is not null THEN $re_kal($request)._2
    ELSE NULL
    END
};

$remap_codec = ($codec) -> (case
when $codec = "hevc" then "H265"
when $codec = "avc" then "H264"
else $codec
end);

$getCodec = ($request) -> {
    $parsed = $parseSignedUrl($request);
    return case
    when $re_codec($request)._0 is not null then <|chunk_type: $re_codec($request).chunk_type, codec: $remap_codec($re_codec($request).codec)|>
    when $parsed["vcodec"] is not null then <|chunk_type: "video", codec: unwrap($parsed["vcodec"])|>
    when $parsed["acodec"] is not null then <|chunk_type: "audio", codec: unwrap($parsed["acodec"])|>
    when $re_kal($request)._0 is not null then <|chunk_type: "video", codec: "kal"|>
    when $request like "/probe%" then <|chunk_type: "probe", codec: "-"|>
    when $request like "/music%" then <|chunk_type: "audio", codec: "-"|>
    when $request like "%.ism%" and $request like "%Fragments(video%" then <|chunk_type: "video", codec: "mss"|>
    when $request like "%.ism%" and $request like "%Fragments(audio%" then <|chunk_type: "audio", codec: "mss"|>
    when $get_channel_old($request) in ("bsvideo", "canvas", "adfox") then <|chunk_type: "video", codec: "ads"|>
    when $re_ad_codec($request)._0 is not null then <|chunk_type: "video", codec: $re_ad_codec($request).codec|>
    when $request like "/fm%" then <|chunk_type: "audio", codec: "fm"|>
    when $request like "%-video%" and String::Contains($request, ".ts") then <|chunk_type: "video", codec: "TS"|>
    when $request like "%-audio%" and String::Contains($request, ".ts") then <|chunk_type: "audio", codec: "TS"|>
    when $re_music_av($request)._0 is not null then <|chunk_type: $re_music_av($request).chunk_type, codec: $re_music_av($request).codec|>
    else null
    end
};

$takeUntilLast = ($string) -> {
    $len = unwrap(length($string));
    return substring($string, 0, unwrap(cast($len - 1 as Uint32)))
};

$getQuality = ($request) -> {
    $parsedSigned = $parseSignedUrl($request);
    RETURN CASE
    WHEN $parsedSigned["res"] is not null then unwrap($parsedSigned["res"])
    WHEN $parsedSigned["label"] is not null and unwrap($parsedSigned["label"]) like "%p" then $takeUntilLast(unwrap($parsedSigned["label"]))
    WHEN $getCodec($request).chunk_type = "audio" then "audio"
    WHEN String::Contains($request, "_720p") THEN "720"
    WHEN String::Contains($request, "_1080p") THEN "1080"
    WHEN String::Contains($request, "_1440p") THEN "1440"
    WHEN String::Contains($request, "_2160p") THEN "2160"
    WHEN String::Contains($request, "_2880p") THEN "2880"
    WHEN String::Contains($request, "_4320p") THEN "4320"
    WHEN String::Contains($request, "_360p") THEN "360"
    WHEN String::Contains($request, "_540p") THEN "540"
    WHEN String::Contains($request, "_480p") THEN "480"
    WHEN String::Contains($request, "_240p") THEN "240"
    WHEN String::Contains($request, "_576p") THEN "576"
    WHEN String::Contains($request, "_432p") THEN "432"
    WHEN String::Contains($request, "_408p") THEN "408"
    WHEN String::Contains($request, "_504p") THEN "504"
    WHEN String::Contains($request, "_270p") THEN "270"
    WHEN String::Contains($request, "_600p") THEN "600"
    WHEN String::Contains($request, "_144p") THEN "144"
    WHEN $re_audio_chunk($request) AND NOT $re_video_chunk($request) THEN "audio"
    WHEN String::Contains($request, "audio") THEN "audio"
    WHEN String::Contains($request, ".ism") THEN "-"
    WHEN $re_ad_codec($request)._0 is not null then cast(ListMin(ListNotNull(
        ListMap([$re_ad_codec($request).width, $re_ad_codec($request).height], ($x)->(cast($x as Uint32)))
    )) as String) ?? "-"
    WHEN $re_x_y_p($request)._0 is not null then cast(ListMin(ListNotNull(
        ListMap([$re_x_y_p($request).width, $re_x_y_p($request).height], ($x)->(cast($x as Uint32)))
    )) as String) ?? "-"
    when $request like "/probe%" then "-"
    ELSE NULL
    END
};

$getCategory = ($request, $referer) -> {
    $from_req = Url::GetCGIParam($request, "video_category_id");
    $from_ref = Url::GetCGIParam($referer, "category");
    RETURN $from_req ?? $from_ref
};

$get_view_type = ($request) -> {
    RETURN CASE
    WHEN String::Contains($request, "cdn1tvru/live") THEN "live"
    WHEN String::Contains($request, "/kal/") THEN "live"
    WHEN String::Contains($request, "/stream/") THEN "live"
    WHEN String::Contains($request, "/live/") THEN "live"
    ELSE "vod"
    END
};

$get_request_ts = ($request) -> {
    $captured = $re_request_ts($request)._1;
    RETURN CASE
    WHEN $captured IS NULL THEN NULL
    WHEN Length($captured) == 13 THEN CAST(CAST($captured AS UInt64) / 1000 AS Int64)
    WHEN Length($captured) == 9 THEN CAST($captured AS Int64) * 5
    ELSE NULL
    END
};

$getExtension = ($request) -> {
    $request = $request ?? "";
    $before_question_mark = unwrap(String::SplitToList($request, "?")[0]);
    $after_dot = unwrap(ListReverse(String::SplitToList($before_question_mark, "."))[0]);
    RETURN $undefWrapper($after_dot)
};

$isKal = ($request) -> (
    case
    when $request like "/kal/%" or $request like "/stream/%" then "kal"
    when $request like "/live/%" then "live"
    else null
    end
);

$isDhd = ($request) -> (
    $request like "%deephd%"
    or $request like "%dhd%"
    or $request like "%supres%"
);

EXPORT $getHash, $undefWrapper, $JsTracerPlayerEvents, $re_UUID, $get_raw_icookie_buckets,
$aggregate_test_buckets, $re_yandexuid, $wrapYandexuid, $get_efir_history, $get_user_licenses, $parseUA,
$re_playerVersion, $strmNotBadRequest, $getStrmRequestType, $parseSignedUrl,
$getParamWrapper, $strmGetVsid, $getYuHash, $getQuality, $getCodec, $get_request_ts, $getExtension,
$get_view_type, $getCategory, $get_channel_old, $isKal, $isDhd, $processZenGroupIds,
$re_audio_chunk, $re_video_chunk, $re_codec;
