#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import get_cluster, YqlRunner, apply_replacements

TITLE = "Cube v2 Demo | YQL"


def process_date(date):
    yc = YqlClient(token=os.environ["YQL_TOKEN"])
    yc.config.db = None
    yr = YqlRunner(yc, title=TITLE)
    pre_queries = []
    for query_file in [
        "strm_map.sql",
        "jstracer_map.sql",
        "redir_map.sql",
        "money_map.sql",
    ]:
        with open(query_file, "r") as f:
            query = f.read()
        query = query.replace("@[date]", date)
        pre_queries.append(
            yr.run(query, wait=False, attachments=["common.sql"])
        )
    for query in pre_queries:
        query.wait_progress()
    with open("sessions_reduce.sql", "r") as f:
        query = f.read()
    query = query.replace("@[date]", date)
    yr.run(
        query,
        wait=True,
        attachments=["common.sql", "microsessions_reducer.py"],
    )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--date")
    args = parser.parse_args()

    process_date(args.date)


if __name__ == "__main__":
    main()
