use hahn;
pragma library("common.sql");
pragma yt.Pool = "@[pool]";
pragma yt.DefaultOperationWeight = "10";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
IMPORT common SYMBOLS $JsTracerPlayerEvents, $re_UUID, $getHash, $wrapYandexuid, $parseUA;

$source_table = "//logs/strm-gogol-log/1d/@[date]";
$output_table = "@[root]/@[date]/jstracer_map";

$getTimestamp = ($data) -> {
    RETURN Yson::ConvertToInt64(Yson::YPath($data, "/jstracer_info/server_time")) ?? Yson::ConvertToInt64(Yson::YPath($data, "/timestamp")) / 1000
};

$getYsondata = Python::get_yson_data(
    Callable<(String?, String, UInt64, String?)->Struct<'add_info':Yson?,'source_data':Yson>>, @@
import json
from yt import yson

def make_source_data(data):
    return yson.dumps({"Data": data})
    
def get_yson_data(eventName, event, ts_client, data):
    try:
        data = json.loads(data)
    except ValueError:
        return {"source_data": None, "add_info": None}
    if event in (b"player_event", b"error"):
        add_info = {"timestamp_client": ts_client}
        add_info["error_details"] = {}
        add_info["error_id_raw"] = eventName.decode("utf8")
        try:
            add_info["error_details"]["connection"] = data["data"]["connectionQuality"]
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            reason = data["labels"]["reason"]
            add_info["error_details"]["reason"] = reason
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            add_info["error_details"][
                "stalledDuration"
            ] = int(data["labels"]["stalledDuration"])
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
    else:
        add_info = None
    if add_info:
        add_info = yson.dumps(add_info)
    return {"source_data": make_source_data(data), "add_info": add_info}
@@
);

$re_yandexuid = Re2::Capture("yandexuid=([0-9]+)");
$re_hash = Re2::Capture("hash=([0-9a-f]{32})[^0-9a-f]");

$getRefFrom = ($data) -> {
    RETURN
        Yson::ConvertToString(Yson::YPath($data, "/labels/from"))
        ?? Yson::ConvertToString(Yson::YPath($data, "/data/additionalParams/from"))
        ?? Yson::ConvertToString(Yson::YPath($data, "/data/source/additionalParams/from"))
        ?? Url::GetCGIParam(
            Yson::ConvertToString(Yson::YPath($data, "/data/currentStream/url")), "from"
        )
        ?? Url::GetCGIParam(Yson::ConvertToString(Yson::YPath($data, "/location")), "from")
};

$getRefFromBlock = ($data) -> {
    RETURN Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($data, "/data/currentStream/url")), "from_block"
    ) ?? Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($data, "/referrer")), "from_block"
    ) ?? Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($data, "/topReferrer")), "from_block"
    )
};

$getUserId = ($YuHash, $vsid) -> {
    RETURN CASE
    WHEN $YuHash IS NOT NULL THEN $YuHash
    WHEN $vsid IS NOT NULL THEN "vsid_" || $vsid
    ELSE NULL
    END
};

$checkUUID = ($UUID) -> {
    RETURN IF(
        LENGTH($UUID) == 32 AND SUBSTRING($UUID, 0, 1) == "4",
        $UUID,
        NULL
    )
};

$extractKpVcid = ($url) -> {
    $split = String::SplitToList($url, "/");
    $section = $split[5];
    RETURN String::SplitToList($section, "-")[1]
};

$getVideoContentId = ($data) -> {
    $stream_url = (
        Yson::ConvertToString(Yson::YPath($data, "/data/playerState/controller/stream/url"))
        ?? Yson::ConvertToString(Yson::YPath($data, "/data/currentStream/url"))
        ?? Yson::ConvertToString((Yson::YPath($data, "/data/source/streams/0/url"))
        )
    );
    $adConfig = (
        Yson::YPath($data, "/data/playerState/ad/adConfig")
        ?? Yson::YPath($data, "/data/params/adConfig")
        ?? Yson::YPath($data, "/data/source/adConfig")
        ?? Yson::YPath($data, "/data/playerState/controller/sourceParams/adConfig")
    );
    RETURN
        Yson::LookupString($adConfig, "videoContentId")
        ?? Url::GetCGIParam($stream_url, "video_content_id")
        ?? $checkUUID(Url::GetCGIParam($stream_url, "uuid"))
        ?? $checkUUID($extractKpVcid($stream_url))
};

$getStalledReason = ($data) -> {
    $reason = Yson::ConvertToString(
        Yson::YPath($data, "/labels/reason")
    );
    RETURN AsStruct(
        IF(
            $reason IS NULL, "Stalled", "Stalled_" || $reason
        ) as error_id,
        false as fatal
    )
};

$getFatalInfo = ($eventName, $data) -> {
    $Fatal = Yson::ConvertToBool(Yson::YPath($data, "/data/isFatal"));
    RETURN AsStruct(
        IF(
            $Fatal == true, $eventName || "_fatal", $eventName
        ) as error_id,
        $Fatal as fatal
    )
};

$getErrorInfo = ($eventName, $data) -> {
    RETURN CASE
    WHEN $eventName == "Stalled" THEN $getStalledReason($data)
    ELSE $getFatalInfo($eventName, $data)
    END
};

$getVsid = ($vsid, $data, $Service) -> {
    RETURN CASE
    WHEN $Service != "ott-smart" OR $vsid IS NOT NULL THEN $vsid
    WHEN $vsid IS NULL THEN Url::GetCGIParam(Yson::ConvertToString(Yson::YPath(Yson::ParseJson($data), "/data/currentStream/url")), "vsid")
    ELSE NULL
    END
};

INSERT INTO $output_table WITH TRUNCATE 
SELECT
    "js_tracer" as source,
    unwrap(DictLookup($JsTracerPlayerEvents, eventName)) as event,
    IF(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)) in ("error", "player_event"),
        eventName,
        NULL
    ) as error_id_raw,
    IF(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)) in ("error", "player_event", "heartbeat"),
        $getErrorInfo(eventName, Yson::ParseJson(data)).error_id,
        NULL
    ) as error_id,
    IF(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)) in ("error", "player_event"),
        $getErrorInfo(eventName, Yson::ParseJson(data)).fatal,
        NULL
    ) as fatal,
    xRealIp as ip,
    $getVsid(vsid, data, service) as vsid,
    clientTimestamp as timestamp_client,
    Geo::RegionByIp(xRealIp).id as region,
    Geo::RoundRegionByIp(xRealIp, "country").short_en_name as country,
    Geo::GetAsset(xRealIp) as a_station,
    Geo::GetIspNameByIp(xRealIp) as provider,
    userAgent as user_agent,
    $parseUA(userAgent).browser_name as browser_name,
    $parseUA(userAgent).os_family as os_family,
    $parseUA(userAgent).browser_version as browser_version,
    $parseUA(userAgent).device_type as device_type,
    $getTimestamp(Yson::ParseJson(data)) as `timestamp`,
    IF(
        $getRefFrom(Yson::ParseJson(data)) == "ru.yandex.quasar.app",
        Yson::ConvertToString(Yson::YPath(Yson::ParseJson(data), "/device/id")),
        NULL
    ) as device_id,
    Yson::ConvertToBool(
        Yson::YPath(Yson::ParseJson(data), "/data/playerState/controller/muted")
    ) == false as non_muted,
    $getYsondata(
        eventName,
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)),
        unwrap(clientTimestamp),
        data
    ).add_info as add_info,
    $getYsondata(
        eventName,
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)),
        unwrap(clientTimestamp),
        data
    ).source_data as source_data,
    $wrapYandexuid(yandexuid ?? $re_yandexuid(data)._1) as yandexuid,
    $re_hash(data)._1 ?? $getHash(yandexuid) as yu_hash,
    $getRefFrom(Yson::ParseJson(data)) as ref_from,
    $getRefFromBlock(Yson::ParseJson(data)) as ref_from_block,
    $getUserId($re_hash(data)._1 ?? $getHash(yandexuid), vsid) as user_id,
    $getVideoContentId(Yson::ParseJson(data)) as video_content_id,
    version as player_version,
FROM $source_table
WITH COLUMNS Struct<'yandexuid':String?>
WHERE service in ("StreamPlayer", "ott-smart", "AndroidPlayer")
AND DictContains($JsTracerPlayerEvents, eventName)
AND vsid IS NOT NULL
AND clientTimestamp IS NOT NULL
AND $getTimestamp(Yson::ParseJson(data)) IS NOT NULL