use hahn;
pragma library("common.sql");
pragma yt.Pool = "@[pool]";
pragma yt.DefaultOperationWeight = "@[weight]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma DqEngine = "disable";
IMPORT common SYMBOLS $JsTracerPlayerEvents, $re_UUID, $getHash, $wrapYandexuid, $parseUA, $getExtension, $isKal, $isDhd, $undefWrapper;
pragma library("quality_report_avglog_common.sql");
import quality_report_avglog_common symbols $parsePlayerState, $getPlayerStateFromData;

$js_tracer_table = "//logs/jstracer-log/1d/@[date]";
$gogol_table = "//logs/strm-gogol-log/1d/@[date]";
$output_table = "@[root]/@[date]/jstracer_map";
$androidvsids_table = "@[root]/@[date]/androidvsids";

$getTimestamp = ($Data) -> {
    RETURN Yson::ConvertToInt64(Yson::YPath($Data, "/jstracer_info/server_time")) ?? Yson::ConvertToInt64(Yson::YPath($Data, "/timestamp")) / 1000
};

$getGogolTestBuckets = ($data, $testIds) -> {
    $data = Yson::ParseJson($data);
    $slots = Yson::YPathString($data, "/slots") ?? Yson::YPathString($data, "/additionalParameters/test_buckets");
    $testIds = $testIds ?? Yson::YPathString($data, "/testIds");
    return case
    when $slots is not null then $slots
    when $testIds is not null and $testIds not like ";" then String::ReplaceAll($testIds, ",", ";")
    else $testIds
    end
};

$getYsonData = Python::get_yson_data(
    Callable<(String?, UInt64, String?)->Struct<'add_info':Yson?>>, @@
import json
from yt import yson

def get_yson_data(event, ts_client, data):
    try:
        data = json.loads(data)
    except ValueError:
        return {"add_info": None}
    if event in (b"player_event", b"error"):
        add_info = {"timestamp_client": ts_client}
        add_info["error_details"] = {}
        try:
            error_category = data["data"]["category"]
        except:
            error_category = "DEFAULT"
        add_info["error_details"]["error_category"] = error_category
        try:
            add_info["error_details"]["connection"] = data["data"]["connectionQuality"]
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            reason = data["labels"]["reason"]
            add_info["error_details"]["reason"] = reason
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            add_info["error_details"]["stalledId"] = data["data"]["stalledId"]
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            add_info["error_details"]["isMuted"] = data["data"]["isMuted"]
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            add_info["error_details"][
                "stalledDuration"
            ] = float(data["data"]["stalledDuration"])
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            add_info["error_details"]["reason"] = data["data"]["reason"]
            add_info["error_details"]["step"] = data["data"]["step"]
            add_info["error_details"]["videoPosition"] = data["data"]["videoPosition"]
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        if data.get("eventName") == "SetVideoTrack":
            try:
                add_info["error_details"]["video_track"] = data["data"]
            except (KeyError, ValueError, TypeError, AttributeError):
                pass
    else:
        add_info = None
    if add_info:
        add_info = yson.dumps(add_info)
    return {"add_info": add_info}
@@
);

$re_yandexuid = Re2::Capture("yandexuid=([0-9]+)");
$re_hash = Re2::Capture("hash=([0-9a-f]{32})[^0-9a-f]");

$wrapBadValue = ($x) -> (IF(
    $x in ("_$invalid_label_value$_", ""),
    NULL,
    $x
));

$getRefFrom = ($labels_from, $Data) -> {
    $stream_url = (
        Yson::ConvertToString(Yson::YPath($Data, "/data/streamUrl"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/playerState/controller/stream/url"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/source/streams/0/url"))
    );
    $ref_from = (
        $wrapBadValue($labels_from)
        ?? $wrapBadValue(Yson::ConvertToString(Yson::YPath($Data, "/labels/from")))
        ?? $wrapBadValue(Yson::ConvertToString(Yson::YPath($Data, "/data/additionalParams/from")))
        ?? $wrapBadValue(Yson::ConvertToString(Yson::YPath($Data, "/data/source/additionalParams/from")))
        ?? Url::GetCGIParam(
            $stream_url, "from"
        )
        ?? Url::GetCGIParam(Yson::ConvertToString(Yson::YPath($Data, "/location")), "from")
    );
    $ref_from = IF(
        $ref_from LIKE "%",
        Url::Decode($ref_from),
        $ref_from
    );
    return $ref_from
};

$getRefFromBlock = ($Data) -> {
    $stream_url = (
            Yson::ConvertToString(Yson::YPath($Data, "/data/streamUrl"))
            ?? Yson::ConvertToString(Yson::YPath($Data, "/data/playerState/controller/stream/url"))
            ?? Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"))
            ?? Yson::ConvertToString(Yson::YPath($Data, "/data/source/streams/0/url"))
    );
    RETURN Yson::ConvertToString(
        Yson::YPath($Data, "/additionalParameters/from_block")
    ) ?? Url::GetCGIParam(
        $stream_url, "from_block"
    ) ?? Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($Data, "/referrer")), "from_block"
    ) ?? Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($Data, "/topReferrer")), "from_block"
    )
};

$getUserId = ($YuHash, $VSID) -> {
    RETURN CASE
    WHEN $YuHash IS NOT NULL THEN $YuHash
    WHEN $VSID IS NOT NULL THEN "vsid_" || $VSID
    ELSE NULL
    END
};

$checkUUID = ($UUID) -> {
    RETURN IF(
        LENGTH($UUID) == 32 AND SUBSTRING($UUID, 0, 1) == "4",
        $UUID,
        NULL
    )
};

$extractKpVcid = ($url) -> {
    $split = String::SplitToList($url, "/");
    $section = $split[5];
    RETURN String::SplitToList($section, "-")[1]
};

$getVideoContentId = ($Data) -> {
    $stream_url = (
        Yson::ConvertToString(Yson::YPath($Data, "/data/streamUrl"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/playerState/controller/stream/url"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"))
        ?? Yson::ConvertToString((Yson::YPath($Data, "/data/source/streams/0/url"))
        )
    );
    $adConfig = (
        Yson::YPath($Data, "/data/playerState/ad/adConfig")
        ?? Yson::YPath($Data, "/data/params/adConfig")
        ?? Yson::YPath($Data, "/data/source/adConfig")
        ?? Yson::YPath($Data, "/data/playerState/controller/sourceParams/adConfig")
    );
    $videoInfo = Yson::YPath($Data, "/data/source/videoInfo");
    RETURN
        Yson::LookupString($Data, "videoContentId")
        ?? Yson::LookupString($adConfig, "videoContentId")
        ?? Url::GetCGIParam($stream_url, "video_content_id")
        ?? Url::GetCGIParam($stream_url, "video-content-id")
        ?? Yson::LookupString($videoInfo, "videoContentId")
        ?? Yson::LookupString($videoInfo, "video_content_id")
        ?? Yson::LookupString($videoInfo, "video-content-id")
        ?? $checkUUID(Url::GetCGIParam($stream_url, "uuid"))
        ?? $checkUUID($extractKpVcid($stream_url))
};

$getStalledReason = ($Data) -> {
    $reason = Yson::ConvertToString(
        Yson::YPath($Data, "/labels/reason")
    );
    RETURN AsStruct(
        IF(
            $reason IS NULL, "Stalled", "Stalled_" || $reason
        ) as error_id,
        false as fatal
    )
};

$getFatalInfo = ($EventName, $EventType, $Data) -> {
    $Fatal = $EventType == "fatal" or Yson::ConvertToBool(Yson::YPath($Data, "/data/isFatal"));
    RETURN AsStruct(
        IF(
            $Fatal == true, $EventName || "_fatal", $EventName
        ) as error_id,
        $Fatal as fatal
    )
};

$getErrorInfo = ($EventName, $EventType, $Data) -> {
    RETURN CASE
    WHEN $EventName == "Stalled" THEN $getStalledReason($Data)
    ELSE $getFatalInfo($EventName, $EventType, $Data)
    END
};

$getVsid = ($VSID, $Data, $Service) -> {
    $Data = Yson::ParseJson($Data);
    $stream_url = (
        Yson::ConvertToString(Yson::YPath($Data, "/data/streamUrl"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/playerState/controller/stream/url"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/source/streams/0/url"))
    );
    $vsid = CASE
    WHEN $Service != "ott-smart" OR $VSID IS NOT NULL THEN $VSID
    WHEN $VSID IS NULL THEN Url::GetCGIParam($stream_url, "vsid")
    ELSE NULL
    END;
    RETURN IF($vsid == "", NULL, $vsid)
};

$getMute = ($Data) -> {
    RETURN Yson::ConvertToBool(Yson::YPath(Yson::ParseJson($Data), "/data/isMuted"))
};

$extractViewType = ($Data) -> {
    RETURN String::AsciiToLower(
        Yson::ConvertToString(Yson::YPath($Data, "/data/videoType"))
    )
};

$badRefFrom = ($x) -> ($x is null or $x in (
    "zen_zen_lib_yabro_morda",
    "ottwidget_yavideo",
    "ottwidget_tv",
    "ottwidget_morda",
    "ott-smart-samsung",
    "ott-smart-webos",
    "ott-smart-tizen",
    "ottwidget_ya-video",
    "zen_desktop_browser_with_morda_yandex",
    "zen_desktop_browser_rezen_yandex"
));

$parseVersion = ($version) -> {
    $lastnumber = ListReverse(String::SplitToList($version, "-"))[0];
    RETURN IF(
        $lastnumber is not null,
        cast($lastnumber as Int64),
        null
    )
};

$isBad = ($service, $version) -> (
    $service == "StreamPlayer"
    and $parseVersion($version) is not null
    and $parseVersion($version) < 2258
);

$isFatal = ($eventName, $eventType, $data) -> (
    $eventType == "fatal" or $getErrorInfo($eventName, $eventType, Yson::ParseJson($data)).fatal
);

$get_utm_qs = Python::get_utm_qs(
    Callable<(String?)->Yson?>, @@
from yt import yson

def get_utm_qs(params):
    try:
        params = yson.loads(params)
    except:
        return
    result = {}
    for q in (
        "utm_term",
        "utm_content",
        "yclid",
        "gclid",
    ):
        if q in params:
            result[q] = params[q]
    if result:
        return yson.dumps(result)
@@
);

$getEvent = ($eventName, $eventType, $data) -> {
    $fatal = $isFatal($eventName, $eventType, $data);
    return case
    when $fatal then "error"
    else $JsTracerPlayerEvents[$eventName]
    end
};

$getString = ($data, $path) -> (
    Yson::ConvertToString(Yson::YPath(
        Yson::ParseJson($data), $path
    ))
);

$getZenParam = ($data, $param) -> {
    $parsed = Yson::ParseJson($data);
    $additionalParameters = Yson::YPath($parsed, "/additionalParameters/" || $param);
    $additionalParams = Yson::YPath($parsed, "/data/source/additionalParams/" || $param);
    return Yson::ConvertToString($additionalParameters ?? $additionalParams)
};

define subquery $gogol_map($source) as
SELECT
    "js_tracer" as source,
    $getEvent(eventName, eventType, data) as event,
    IF(
        $getEvent(eventName, eventType, data) in ("error", "player_event"),
        eventName,
        NULL
    ) as error_id_raw,
    IF(
        eventName in ("CreatePlayer", "Start"),
        $isKal(streamUrl)
    ) as is_kal,
    IF(
        eventName in ("CreatePlayer", "Start"),
        $getExtension(streamUrl)
    ) as extension,
    IF(
        eventName in ("CreatePlayer", "Start"),
        $isDhd(streamUrl)
    ) as is_dhd,
    IF(
        $getEvent(eventName, eventType, data) in ("error", "player_event", "heartbeat"),
        $getErrorInfo(eventName, eventType, Yson::ParseJson(`data`)).error_id,
        NULL
    ) as error_id,
    $isFatal(eventName, eventType, data) as fatal,
    IF(
        eventName == "PlayerAlive",
        Yson::YPathDouble(Yson::ParseJson(data), "/currentTime")
    ) as time_on_seekbar,
    xRealIp as ip,
    $getVsid(vsid, `data`, service) as vsid,
    clientTimestamp as timestamp_client,
    Geo::RegionByIp(xRealIp).id as region,
    Geo::RoundRegionByIp(xRealIp, "country").short_en_name as country,
    Geo::GetAsset(xRealIp) as a_station,
    Geo::GetIspNameByIp(xRealIp) as provider,
    userAgent as user_agent,
    IF(
        eventName in ("4SecWatched", "10SecWatched", "20SecWatched", "30SecHeartbeat") and $getMute(`data`) is not null,
        not $getMute(`data`),
        NULL
    ) as non_muted,
    IF(
        eventName == "PlayerAlive",
        $parsePlayerState($getPlayerStateFromData(data)),
        NULL
    ) as parsed_player_state,
    $extractViewType(Yson::ParseJson(`data`)) as video_type,
    $parseUA(userAgent).browser_name as browser_name,
    IF(service == "AdSDKJS", null, service) as gogol_service,
    $parseUA(userAgent).os_family as os_family,
    $parseUA(userAgent).browser_version as browser_version,
    $parseUA(userAgent).device_type as device_type,
    length(`data`) as bytes_sent,
    cast(serverTimestamp / 1000.0 as Int64) as `timestamp`,
    (
        Yson::ConvertToString(Yson::YPath(Yson::ParseJson(`data`), "/device/id"))
        ?? Yson::YPathString(Yson::ParseJson(data), "/data/source/additionalParams/device_id")
    ) as device_id,
    Yson::YPathString(Yson::ParseJson(data), "/device/uuid") as device_uuid,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(`data`), "/puid")) as puid,
    $getYsonData(
        $getEvent(eventName, eventType, data),
        unwrap(clientTimestamp),
        `data`
    ).add_info as add_info,
    IF(
        $getRefFrom(labels_from, Yson::ParseJson(`data`)) in ("tvandroid", "module2"),
        Yson::SerializeJson(Yson::YPath(Yson::ParseJson(data), "/additionalParameters/tvandroid")),
        null
    ) as tvandroid_data,
    $wrapYandexuid(yandexuid ?? $re_yandexuid(`data`)._1) as yandexuid,
    $re_hash(`data`)._1 ?? IF(yandexuid IS NULL or yandexuid == "", NULL, $getHash(yandexuid)) as yu_hash,
    $getRefFrom(labels_from, Yson::ParseJson(`data`)) as ref_from,
    $getRefFromBlock(Yson::ParseJson(`data`)) as ref_from_block,
    $getZenParam(data, "stream_block") as stream_block,
    $getZenParam(data, "strongest_id") ?? $getZenParam(data, "strongestId") as strongest_id,
    $getZenParam(data, "rid") as rid,
    $getZenParam(data, "ppi") as ppi,
    cast($getZenParam(data, "item_id") as Int64) ?? cast($getZenParam(data, "itemId") as Int64) as item_id,
    $getUserId($re_hash(`data`)._1 ?? $getHash(yandexuid), vsid) as user_id,
    $getVideoContentId(Yson::ParseJson(`data`)) as video_content_id,
    `version` as player_version,
    $get_utm_qs(
        ToBytes(Yson::Serialize(Yson::YPath(Yson::ParseJson(data), IF(
            eventName == "CreatePlayer",
            "/data/source/additionalParams",
            "/data/additionalParams"
        ))))
    ) as utm_data,
    IF(
        $undefWrapper(yandexuid) is not null,
        xYandexICookie
    ) as xYandexICookie,
    $getString(
        data, "/data/source/context/monetizationModel"
    ) ?? $getString(
        data, "/data/videoData/drmConfig/requestParams/monetizationModel"
    ) as redir_licence,
    $getGogolTestBuckets(data, testIds) as testIds
FROM $source()
WHERE service in ("StreamPlayer", "ott-smart", "AndroidPlayer", "YandexMusic", "ApplePlayer", "iosZenAppPlayer", "AdSDKJS", "Filmoscope")
AND (DictContains($JsTracerPlayerEvents, eventName) or eventType == "fatal")
AND $getVsid(vsid, `data`, service) IS NOT NULL
AND clientTimestamp IS NOT NULL
AND serverTimestamp IS NOT NULL;
end define;


define subquery $gogol_preselect() as
select
    IF(
        eventName == "Error" and errorId is not null,
        errorId,
        eventName
    ) as eventName,
    t.* without t.eventName
from $gogol_table with columns Struct<yandexuid:String?,vsid:String?,errorId:String?> as t
where not $isBad(service, `version`);
end define;

define subquery $jstracer_preselect() as
select
EventName as eventName,
EventType as eventType,
Data as data,
VSID as vsid,
Service as service,
ClientIP as xRealIp,
UserAgent as userAgent,
ClientTimestamp as clientTimestamp,
ServerTimestamp as serverTimestamp,
Yandexuid as yandexuid,
Version as version,
NULL as topLocation,
NULL as xYandexICookie,
NULL as cookie,
NULL as labels_from,
NULL as streamUrl,
NULL as testIds
from $js_tracer_table
where $isBad(Service, Version);
end define;

define subquery $jstracer_preselect_adsdk() as
$source = (
    select * from $js_tracer_table
    where Service == "AdSDKJS"
    and EventName LIKE "VastTracking%"
    and SID is not null
);
$sid_to_vsid = (
    select SID, MAX(VSID) as VSID
    from $source
    where VSID is not null and SID is not null
    group by SID
);

select
s.EventName as eventName,
s.EventType as eventType,
s.Data as data,
stv.VSID as vsid,
s.Service as service,
s.ClientIP as xRealIp,
s.UserAgent as userAgent,
s.ClientTimestamp as clientTimestamp,
s.ServerTimestamp as serverTimestamp,
s.Yandexuid as yandexuid,
s.Version as version,
NULL as cookie,
NULL as topLocation,
NULL as xYandexICookie,
NULL as labels_from,
NULL as streamUrl,
NULL as testIds
from $source as s
inner join $sid_to_vsid as stv using (SID)
end define;

insert into $androidvsids_table with truncate
select androidVsid, max(vsid) as vsid
from (
    select vsid, Yson::ConvertToString(Yson::YPath(Yson::ParseJson(data), "/data/androidVsid")) as androidVsid
    from $gogol_table
    where eventName == "YandexAndroidVsidChanged"
)
where vsid is not null and androidVsid is not null
group by androidVsid;

$androidVsidRefFromCheck = ($rf) -> {
    $rf = $rf ?? "";
    return $rf not like "com.yandex.browser%" and $rf != "ru.yandex.searchplugin"
};

insert into $output_table with truncate
select * from $gogol_map($gogol_preselect) where $androidVsidRefFromCheck(ref_from)
union all
select * from $gogol_map($jstracer_preselect)
union all
select * from $gogol_map($jstracer_preselect_adsdk);
