use hahn;
pragma library("common.sql");
pragma yt.Pool = "@[pool]";
pragma yt.DefaultOperationWeight = "10";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
IMPORT common SYMBOLS $JsTracerPlayerEvents, $re_UUID, $getHash, $wrapYandexuid, $parseUA;

$js_tracer_table = "//logs/jstracer-log/1d/@[date]";
$gogol_table = "//logs/strm-gogol-log/1d/@[date]";
$output_table = "@[root]/@[date]/jstracer_map";

$getTimestamp = ($Data) -> {
    RETURN Yson::ConvertToInt64(Yson::YPath($Data, "/jstracer_info/server_time")) ?? Yson::ConvertToInt64(Yson::YPath($Data, "/timestamp")) / 1000
};

$getYsonData = Python::get_yson_data(
    Callable<(String, UInt64, String?)->Struct<'add_info':Yson?>>, @@
import json
from yt import yson

def get_yson_data(event, ts_client, data):
    try:
        data = json.loads(data)
    except ValueError:
        return {"add_info": None}
    if event in (b"player_event", b"error"):
        add_info = {"timestamp_client": ts_client}
        add_info["error_details"] = {}
        add_info["error_id_raw"] = event
        try:
            add_info["error_details"]["connection"] = data["data"]["connectionQuality"]
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            reason = data["labels"]["reason"]
            add_info["error_details"]["reason"] = reason
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
        try:
            add_info["error_details"][
                "stalledDuration"
            ] = int(data["labels"]["stalledDuration"])
        except (KeyError, ValueError, TypeError, AttributeError):
            pass
    else:
        add_info = None
    if add_info:
        add_info = yson.dumps(add_info)
    return {"add_info": add_info}
@@
);

$re_yandexuid = Re2::Capture("yandexuid=([0-9]+)");
$re_hash = Re2::Capture("hash=([0-9a-f]{32})[^0-9a-f]");

$getRefFrom = ($Data) -> {
    RETURN
        Yson::ConvertToString(Yson::YPath($Data, "/labels/from"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/additionalParams/from"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/source/additionalParams/from"))
        ?? Url::GetCGIParam(
            Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url")), "from"
        )
        ?? Url::GetCGIParam(Yson::ConvertToString(Yson::YPath($Data, "/location")), "from")
};

$getRefFromBlock = ($Data) -> {
    RETURN Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url")), "from_block"
    ) ?? Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($Data, "/referrer")), "from_block"
    ) ?? Url::GetCGIParam(
        Yson::ConvertToString(Yson::YPath($Data, "/topReferrer")), "from_block"
    )
};

$getUserId = ($YuHash, $VSID) -> {
    RETURN CASE
    WHEN $YuHash IS NOT NULL THEN $YuHash
    WHEN $VSID IS NOT NULL THEN "vsid_" || $VSID
    ELSE NULL
    END
};

$checkUUID = ($UUID) -> {
    RETURN IF(
        LENGTH($UUID) == 32 AND SUBSTRING($UUID, 0, 1) == "4",
        $UUID,
        NULL
    )
};

$extractKpVcid = ($url) -> {
    $split = String::SplitToList($url, "/");
    $section = $split[5];
    RETURN String::SplitToList($section, "-")[1]
};

$getVideoContentId = ($Data) -> {
    $stream_url = (
        Yson::ConvertToString(Yson::YPath($Data, "/data/playerState/controller/stream/url"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"))
        ?? Yson::ConvertToString((Yson::YPath($Data, "/data/source/streams/0/url"))
        )
    );
    $adConfig = (
        Yson::YPath($Data, "/data/playerState/ad/adConfig")
        ?? Yson::YPath($Data, "/data/params/adConfig")
        ?? Yson::YPath($Data, "/data/source/adConfig")
        ?? Yson::YPath($Data, "/data/playerState/controller/sourceParams/adConfig")
    );
    RETURN
        Yson::LookupString($Data, "videoContentId")
        ?? Yson::LookupString($adConfig, "videoContentId")
        ?? Url::GetCGIParam($stream_url, "video_content_id")
        ?? $checkUUID(Url::GetCGIParam($stream_url, "uuid"))
        ?? $checkUUID($extractKpVcid($stream_url))
};

$getStalledReason = ($Data) -> {
    $reason = Yson::ConvertToString(
        Yson::YPath($Data, "/labels/reason")
    );
    RETURN AsStruct(
        IF(
            $reason IS NULL, "Stalled", "Stalled_" || $reason
        ) as error_id,
        false as fatal
    )
};

$getFatalInfo = ($EventName, $Data) -> {
    $Fatal = Yson::ConvertToBool(Yson::YPath($Data, "/data/isFatal"));
    RETURN AsStruct(
        IF(
            $Fatal == true, $EventName || "_fatal", $EventName
        ) as error_id,
        $Fatal as fatal
    )
};

$getErrorInfo = ($EventName, $Data) -> {
    RETURN CASE
    WHEN $EventName == "Stalled" THEN $getStalledReason($Data)
    ELSE $getFatalInfo($EventName, $Data)
    END
};

$getVsid = ($VSID, $Data, $Service) -> {
    $vsid = CASE
    WHEN $Service != "ott-smart" OR $VSID IS NOT NULL THEN $VSID
    WHEN $VSID IS NULL THEN Url::GetCGIParam(Yson::ConvertToString(Yson::YPath(Yson::ParseJson($Data), "/data/currentStream/url")), "vsid")
    ELSE NULL
    END;
    RETURN IF($vsid == "", NULL, $vsid)
};

$getMute = ($Data) -> {
    RETURN Yson::ConvertToBool(Yson::YPath(Yson::ParseJson($Data), "/data/isMuted"))
};

$extractViewType = ($Data) -> {
    RETURN String::ToLower(
        Yson::ConvertToString(Yson::YPath($Data, "/data/videoType"))
    )
};

$badRefFrom = ($x) -> ($x is null or $x in (
    "zen_zen_lib_yabro_morda",
    "ottwidget_yavideo",
    "ottwidget_tv",
    "ottwidget_morda",
    "ott-smart-samsung",
    "ott-smart-webos",
    "ott-smart-tizen",
    "ottwidget_ya-video",
    "zen_desktop_browser_with_morda_yandex",
    "zen_desktop_browser_rezen_yandex"
));

define subquery $gogol_map($source) as
SELECT
    "js_tracer" as source,
    unwrap(DictLookup($JsTracerPlayerEvents, eventName)) as event,
    IF(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)) in ("error", "player_event"),
        eventName,
        NULL
    ) as error_id_raw,
    IF(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)) in ("error", "player_event", "heartbeat"),
        $getErrorInfo(eventName, Yson::ParseJson(`data`)).error_id,
        NULL
    ) as error_id,
    IF(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)) in ("error", "player_event"),
        $getErrorInfo(eventName, Yson::ParseJson(`data`)).fatal,
        NULL
    ) as fatal,
    xRealIp as ip,
    $getVsid(vsid, `data`, service) as vsid,
    clientTimestamp as timestamp_client,
    Geo::RegionByIp(xRealIp).id as region,
    Geo::RoundRegionByIp(xRealIp, "country").short_en_name as country,
    Geo::GetAsset(xRealIp) as a_station,
    Geo::GetIspNameByIp(xRealIp) as provider,
    userAgent as user_agent,
    IF(
        eventName in ("10SecWatched", "20SecWatched", "30SecHeartbeat") and $getMute(`data`) is not null,
        not $getMute(`data`),
        NULL
    ) as non_muted,
    $extractViewType(Yson::ParseJson(`data`)) as video_type,
    $parseUA(userAgent).browser_name as browser_name,
    $parseUA(userAgent).os_family as os_family,
    $parseUA(userAgent).browser_version as browser_version,
    $parseUA(userAgent).device_type as device_type,
    $getTimestamp(Yson::ParseJson(`data`)) as `timestamp`,
    IF(
        $getRefFrom(Yson::ParseJson(`data`)) == "ru.yandex.quasar.app",
        Yson::ConvertToString(Yson::YPath(Yson::ParseJson(`data`), "/device/id")),
        NULL
    ) as device_id,
    IF(
        $getRefFrom(Yson::ParseJson(`data`)) == "ru.yandex.quasar.app",
        Yson::ConvertToString(Yson::YPath(Yson::ParseJson(`data`), "/puid")),
        NULL
    ) as puid,
    $getYsonData(
        unwrap(DictLookup($JsTracerPlayerEvents, eventName)),
        unwrap(clientTimestamp),
        `data`
    ).add_info as add_info,
    $wrapYandexuid(yandexuid ?? $re_yandexuid(`data`)._1) as yandexuid,
    $re_hash(`data`)._1 ?? IF(yandexuid IS NULL or yandexuid == "", NULL, $getHash(yandexuid)) as yu_hash,
    $getRefFrom(Yson::ParseJson(`data`)) as ref_from,
    $getRefFromBlock(Yson::ParseJson(`data`)) as ref_from_block,
    $getUserId($re_hash(`data`)._1 ?? $getHash(yandexuid), vsid) as user_id,
    $getVideoContentId(Yson::ParseJson(`data`)) as video_content_id,
    `version` as player_version,
FROM $source()
WHERE service in ("StreamPlayer", "ott-smart", "AndroidPlayer")
AND DictContains($JsTracerPlayerEvents, eventName)
AND $getVsid(vsid, `data`, service) IS NOT NULL
AND clientTimestamp IS NOT NULL
AND $getTimestamp(Yson::ParseJson(`data`)) IS NOT NULL;
end define;


define subquery $gogol_preselect() as
select * from $gogol_table with columns Struct<yandexuid:String?,vsid:String?>
where not $badRefFrom($getRefFrom(Yson::ParseJson(data)));
end define;

define subquery $jstracer_preselect() as
select
EventName as eventName,
Data as data,
VSID as vsid,
Service as service,
ClientIP as xRealIp,
UserAgent as userAgent,
ClientTimestamp as clientTimestamp,
Yandexuid as yandexuid,
Version as version
from $js_tracer_table
where $badRefFrom($getRefFrom(Yson::ParseJson(Data)));
end define;

insert into $output_table
select * from $gogol_map($gogol_preselect)
union all
select * from $gogol_map($jstracer_preselect);
