use hahn;
pragma library("common.sql");
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.DefaultOperationWeight = "@[weight]";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma DqEngine = "disable";
IMPORT common SYMBOLS $parseUA, $getHash, $undefWrapper;

$output_table = "@[root]/@[date]/money_map";
$rtb_dsp_log_table = "//statbox/cooked_logs/bs-dsp-cooked-log/v1/1d/@[date]";
$awaps_log_table = "//logs/awaps-log/1d/@[date]";
$chtracking_log_table = "//logs/bs-chtracking-log/1d/@[date]";
$pageimps_table = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";
$pageimps_ = (select * from $pageimps_table where (category like "VH%" or name == "yandex.ru"));
$good_page_ids = select distinct pageid from $pageimps_;
$good_dsp_ids = select distinct dspid from $pageimps_;

$page_imp = (
    select
        page_id,
        imp_id,
        CAST(some(category_id) as String) as category_id,
        some(video_placement_name) as ad_type,
        some(category) like 'VH%' as is_vh,
        some(name) as partner_name,
    from $pageimps_
    group by CAST(pageid as String) as page_id,
    CAST(impid as String) as imp_id
);


$getVsid = ($queryargs, $uniqid, $clientip, $useragent) -> {
    RETURN IF(
        Url::GetCGIParam("?" || $queryargs, "769") IS NOT NULL
        AND Url::GetCGIParam("?" || $queryargs, "769") != "0"
        AND LENGTH(Url::GetCGIParam("?" || $queryargs, "769")) == 64,
        Url::GetCGIParam("?" || $queryargs, "769"),
        "rtbdsp_" || cast($uniqid as String) || "_" || cast($clientip as String) || "_" || $getHash($useragent ?? "")
    )
};

$rtb_dsp_map = (
    select
        "rtb-dsp" as event,
        "rtb-dsp" as source,
        useragent as user_agent,
        $parseUA(useragent).browser_name as browser_name,
        $parseUA(useragent).os_family as os_family,
        $parseUA(useragent).browser_version as browser_version,
        $parseUA(useragent).device_type as device_type,
        IF(icookie > 0, cast(icookie as String)) as icookie,
        clientip as ip,
        regionid as region,
        Geo::RoundRegionByIp(clientip, "country").short_en_name as country,
        Geo::GetAsset(clientip) as a_station,
        Geo::GetIspNameByIp(clientip) as provider,
        $getVsid(queryargs, uniqid, clientip, useragent) as vsid,
        $undefWrapper(Url::GetCGIParam("?" || queryargs, "354")) as video_content_id,
        cast(eventtime as Int64) as `timestamp`,
        cast(uniqid as String) as yandexuid,
        detaileddevicetype,
        devicetype ?? 0 as devicetype,
        producttype,
        dspid,
        dsplogid,
        adsessionid,
        bidreqid,
        eventid,
        case
        when impressionoptions_preroll then "preroll"
        when impressionoptions_midroll then "midroll"
        when impressionoptions_inpage then "inpage"
        when impressionoptions_inroll then "inroll"
        when impressionoptions_interstitial then "interstitial"
        when impressionoptions_pauseroll then "pauseroll"
        when impressionoptions_postroll then "postroll"
        when impressionoptions_overlay then "overlay"
        when impressionoptions_s2sroll then "s2sroll"
        else "other"
        end as video_type,
        CAST(pageid as String) as page_id,
        CAST(impid as String) as imp_id,
        maxadscount,
        win,
        price,
        partnerprice,
        countertype,
        position,
        queryargs,
        IF(win == 1 and countertype == 1, price, 0) as Price,
        IF(win == 1 and countertype == 1, partnerprice, 0) as PartnerPrice,
        IF(win == 1 and countertype == 0, 1, 0) as Hit,
        IF(win == 1 and countertype == 1, 1, 0) as ShownHit,
        bidid, --Uint64
        campaignid, --Int64,
        videoduration --Uint64
    from $rtb_dsp_log_table
    where
    bidreqid is not null and bidreqid != 0
    and dspfraudbits == 0
    and dspeventflags == 0
    and pageid in $good_page_ids
    and (
        dspid in $good_dsp_ids
        or (
            countertype == 0
            and win == 1
            and dspid in (5, 10)
        )
    )
);

$for_chtracking_join = (
    select
        bidid,
        campaignid,
        max(vsid) as vsid
    from $rtb_dsp_map
    where vsid not like "rtb%"
    group by
        cast(bidid as String) as bidid,
        cast(campaignid as String) as campaignid
);

$get_chtracking_add_info = Python::get_chtracking_add_info(
    Callable<(String?, String?, String?, String?)->Yson?>, @@
from yt import yson

def get_chtracking_add_info(action, trackingeventtime, hitlogid, orderid):
    try:
        trackingeventtime = int(trackingeventtime)
        hitlogid = int(hitlogid)
        orderid = int(orderid)
    except (ValueError, TypeError):
        return
    return yson.dumps({
        "source": "chtracking",
        "action": action,
        "timestamp": trackingeventtime,
        "bidid": hitlogid,
        "campaignid": orderid
    })
@@
);

$chtracking_map = (
    select
        "chtracking" as source,
        "chtracking" as event,
        vsid,
        $get_chtracking_add_info(
            `action`, `trackingeventtime`, `hitlogid`, `orderid`
        ) as add_info,
        cast(trackingeventtime as Int64) as `timestamp`
    from $chtracking_log_table as c
    inner join $for_chtracking_join as cj on (
        cj.bidid == c.hitlogid 
        and cj.campaignid == c.orderid 
    )
);

$for_awaps_join = (
    select
        bidreqid,
        max(vsid) as vsid
    from $rtb_dsp_map
    where vsid not like 'rtb%'
    group by cast(bidreqid as String) as bidreqid
);

$get_awaps_add_info = Python::get_awaps_add_info(
    Callable<(String?, String?, String?, String?)->Yson?>, @@
from yt import yson

def get_awaps_add_info(rtb_request_id, actionid, global_request_id, unixtime):
    try:
        actionid = int(actionid)
        unixtime = int(unixtime)
        global_request_id = int(global_request_id)
    except (ValueError, TypeError):
        return
    return yson.dumps({
        "source": "awaps",
        "actionid": actionid,
        "timestamp": unixtime,
        "bidreqid": rtb_request_id,
        "global_request_id": global_request_id
    })
@@
);

$isGoodActionid = ($aid) -> {
    RETURN ($aid in (0, 1))
    or ($aid >= 51 and $aid <= 90)
    or ($aid >= 170)
};

$awaps_map = (
    select
        "awaps" as source,
        "awaps" as event,
        vsid,
        cast(unixtime as Int64) as `timestamp`,
        $get_awaps_add_info(
            rtb_request_id,
            actionid,
            global_request_id,
            unixtime
        ) as add_info
    from $awaps_log_table as a
    inner join $for_awaps_join as aj on (
        a.rtb_request_id == aj.bidreqid
    )
    where $isGoodActionid(CAST(a.actionid as Int64))
);

$rtb_dsp_join = (
    select
        r.*,
        category_id,
        ad_type,
        is_vh,
        partner_name,
    from $rtb_dsp_map as r
    inner join $page_imp as p on (r.page_id == p.page_id and r.imp_id == p.imp_id)
);

$makeAddInfo = Python::make_add_info(
Callable<(
    String?, -- bidreqid,
    String?, -- browser,
    String?, -- detaileddevicetype,
    Int64, -- devicetype,
    Int64?, -- dsp_id????
    Int64, -- Hit,
    String?, -- page_id,
    Int64?, -- PartnerPrice,
    Int64?, -- Price,
    Int64?, -- region,
    String?, -- dsplogid,
    Int64, -- ShownHit,
    UInt64?, -- yandexuid,
    String?, -- ad_type,
    String?, -- adsessionid,
    Int64?, -- countertype,
    String?, -- imp_id,
    Int64?, -- maxadscount,
    Bool?, -- is_vh,
    Int64?, -- partnerprice,
    Int64?, -- position,
    Int64?, -- price,
    String?, -- producttype,
    Int64?, -- timestamp,
    String?, -- partner_name,
    String, -- video_type,
    Int64?, -- win, --
    Bool, --overlay
    UInt64?, -- bidid
    Int64?, -- campaignid,
    Int64?, -- videoduration,
)->Yson>, @@
from yt import yson

def process_value(value):
    if isinstance(value, bytes):
        return value.decode("utf8", errors="replace")
    return value

def make_add_info(
    bidreqid,
    browser,
    detaileddevicetype,
    devicetype,
    dsp_id,
    Hit,
    page_id,
    PartnerPrice,
    Price,
    region,
    dsplogid,
    ShownHit,
    yandexuid,
    ad_type,
    adsessionid,
    countertype,
    imp_id,
    maxadscount,
    is_vh,
    partnerprice,
    position,
    price,
    producttype,
    timestamp,
    partner_name,
    video_type,
    win,
    overlay,
    bidid,
    campaignid,
    videoduration,
):
    result = {
        "BidReqid": process_value(bidreqid),
        "BrowserName": process_value(browser),
        "DetailedDeviceType": process_value(detaileddevicetype),
        "DspID": process_value(dsp_id),
        "DeviceType": process_value(devicetype),
        "Hit": process_value(Hit),
        "PageID": process_value(page_id),
        "PartnerPrice": process_value(PartnerPrice),
        "Price": process_value(Price),
        "RegionId": process_value(region),
        "RequestId": process_value(dsplogid),
        "ShownHit": process_value(ShownHit),
        "UniqID": process_value(yandexuid),
        "ad_type": process_value(ad_type),
        "adsessionid": process_value(adsessionid),
        "countertype": process_value(countertype),
        "imp_id": process_value(imp_id),
        "maxadscount": process_value(maxadscount),
        "is_vh": process_value(is_vh),
        "partnerprice": process_value(partnerprice),
        "position": process_value(position),
        "price": process_value(price),
        "producttype": process_value(producttype),
        "timestamp": process_value(timestamp),
        "partner_name": process_value(partner_name),
        "video_type": process_value(video_type),
        "win": process_value(win),
        "overlay": overlay,
        "bidid": bidid,
        "campaignid": campaignid,
        "videoduration": videoduration,
    }
    return yson.dumps(result)
@@
);

$getOverlay = ($queryargs) -> {
    RETURN CASE
    WHEN Url::GetCGIParam("?" || $queryargs, "709") IS NOT NULL THEN TRUE
    WHEN (
        Url::GetCGIParam("?" || $queryargs, "708") IS NOT NULL
        AND Url::GetCGIParam("?" || $queryargs, "708") != "0"
    ) THEN TRUE
    ELSE FALSE
    END
};

INSERT INTO $output_table WITH TRUNCATE
SELECT $makeAddInfo(
    CAST(bidreqid as String), --:Uint64?,
    browser_name, --:String?,
    detaileddevicetype, --:String?,
    devicetype, --:Int64,
    dspid, 
    CAST(Hit as Int64), --:Int32,
    page_id, --:String,
    PartnerPrice, --:Int64?,
    Price, --:Int64,
    region, --:Int64?,
    CAST(dsplogid as String), --:Uint64,
    CAST(ShownHit as Int64), --:Int32,
    CAST(yandexuid as UInt64), --:String,
    ad_type, --:String?,
    CAST(adsessionid as String), --:Uint64?,
    CAST(countertype as Int64), --:Int64,
    imp_id, --:String,
    maxadscount, --:Int64?,
    is_vh, --:String?,
    partnerprice, --:Int64?,
    position, --:Int64?,
    price, --:Int64,
    producttype, --:String?,
    `timestamp`, --:Int64?,
    partner_name, --:String?,
    video_type, --:String,
    win, --:Int64?,
    $getOverlay(queryargs),
    bidid, --UInt64
    campaignid, --Int64,
    CAST(videoduration as Int64), --UInt64,
) as add_info,
vsid,
CAST(bidreqid as String) as bidreqid,
os_family,
page_id,
region,
imp_id,
category_id,
yandexuid,
icookie,
`timestamp`,
video_content_id,
ip,
user_agent,
event,
source,
browser_version,
browser_name,
device_type,
country,
a_station,
eventid,
provider,
bidid,
campaignid
from $rtb_dsp_join
union all
select * from $awaps_map
union all
select * from $chtracking_map;
