#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import yt.wrapper as yt
from yql.api.v1.client import YqlClient
from videolog_common import YqlRunner, date_range, apply_replacements

TITLE = "Sessions Compressor | YQL"

SESSIONS_FIX_STUB = """
use hahn;
pragma yt.Pool = "@[pool]";
PRAGMA yt.PublishedCompressionCodec = "zstd_8";
PRAGMA yt.MinPublishedAvgChunkSize = "8G";
PRAGMA yt.PublishedErasureCodec = "lrc_12_2_2";

$fixTestBuckets = ($tb_) -> {
    $tb = String::SplitToList($tb_, ";");
    $tb = ListFilter($tb, ($x)->(CAST(String::SplitToList($x, ",")[0] as Uint64) is not null));
    return IF($tb_ is null, null, String::JoinFromList($tb, ";"))
};

$fixAddInfo = ($add_info) -> {
    $dct = DictItems(Yson::ConvertToDict($add_info));
    $dct = ListFilter($dct, ($x)->($x.0 not like "%_counter"));
    return Yson::Serialize(Yson::From(ToDict($dct)))
};

$src_table = "@[src_table]";

insert into $src_table with truncate
select $fixTestBuckets(test_buckets) as test_buckets, $fixAddInfo(add_info) as add_info, s.* without test_buckets, add_info
from $src_table as s;
"""

# yt.transform(src, dst, erasure_codec="lrc_12_2_2", compression_codec="zstd_8")

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from", required=True)
    parser.add_argument("--to", required=True)
    parser.add_argument("--pool", default="pecheny")
    args = vars(parser.parse_args())

    proxy = os.environ["YT_PROXY"]
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)

    for date in date_range(args["from"], args["to"]):
        table = f"//cubes/video-strm/{date}/sessions"
        query = apply_replacements(SESSIONS_FIX_STUB, {"@[src_table]": table, "@[pool]": args["pool"]})
        yr.run(query)
        yt.set_attribute(table, "test_buckets_add_info_fixed", True)
        # yt.transform(table, table, erasure_codec="lrc_12_2_2", compression_codec="zstd_8")
        yt.set_attribute(table, "compressed_after_fix", True)


if __name__ == "__main__":
    main()
