use hahn;
pragma library("common.sql");
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.DefaultOperationWeight = "@[weight]";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma DqEngine = "disable";
IMPORT common SYMBOLS $getHash, $wrapYandexuid;

$redir_table = "//logs/redir-log/1d/@[date]";
$output_table = "@[root]/@[date]/redir_map";

$getEventName = ($path) -> {
    RETURN CASE
    WHEN $path == "player-events.heartbeat" THEN "heartbeat"
    WHEN $path == "player-events.start" THEN "start"
    WHEN $path == "player-events.init" THEN "create_player"
    ELSE NULL
    END
};

$getIp = ($ip) -> {
    RETURN IF(
        $ip IS NULL,
        NULL,
        unwrap(String::SplitToList($ip, ",")[0])
    )
};

$wrapContentId = ($content_id) -> {
    RETURN CASE
    WHEN LENGTH($content_id) == 12 THEN $content_id
    WHEN LENGTH($content_id) == 32 AND String::Substring($content_id, 0, 1) == "4" THEN $content_id
    ELSE NULL
    END
};

INSERT INTO $output_table WITH TRUNCATE
SELECT 
    unwrap($getEventName(`dict`["path"])) as event,
    "redir" as source,
    cast(unwrap(`dict`["timestamp"]) as Int64) as `timestamp`,
    $wrapYandexuid(`dict`["yandexuid"] ?? `dict`["yuid"]) as yandexuid,
    $getHash(`dict`["yandexuid"] ?? `dict`["yuid"]) as yu_hash,
    IF(`dict`["mute"] IS NOT NULL AND `dict`["mute"] == "0", true, false) as non_muted,
    `dict`["stream_block"] as stream_block,
    `dict`["from_block"] as ref_from_block,
    `dict`["source"] as ref_from,
    `dict`["licence"] as redir_licence,
    $getIp(`dict`["ip"]) as ip,
    Geo::RegionByIp($getIp(`dict`["ip"])).id as region,
    Geo::RoundRegionByIp($getIp(`dict`["ip"]), "country").short_en_name as country,
    Geo::GetAsset($getIp(`dict`["ip"])) as a_station,
    Geo::GetIspNameByIp($getIp(`dict`["ip"])) as provider,
    unwrap(`dict`["vsid"]) as vsid,
    $wrapContentId(`dict`["content_id"]) as video_content_id,
    `dict`["channel_id"] as channel_id,
    `dict`["reqid"] as reqid,
    $getHash(`dict`["yandexuid"] ?? `dict`["yuid"]) ?? ("vsid_" || unwrap(`dict`["vsid"])) as user_id
from $redir_table
where `dict`["path"] in (
    "player-events.heartbeat", "player-events.init", "player-events.start"
)
and LENGTH(`dict`["vsid"]) == 64