use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma DqEngine = "disable";
pragma yt.Pool = "robot-zen-abt-lesser";

$sessions_table = "//cubes/video-strm/" || $date || "/sessions";
$output_table = "//home/zen/sessions/vh/" || $date;

$QUALITIES = [144, 240, 360, 480, 576, 720, 1080, 1440, 2160, 2880, 4320];
$chooseQuality = ($x) -> {
    $n = cast($x as Uint32);
    $res = IF(
        Math::IsFinite($n) and $n > 0,
        cast(ListHead(ListSort($QUALITIES, ($y)->(ABS($y - cast($n as Double))))) as String),
        $x
    );
    return $res ?? "-"
};

$yson = ($x) -> (Yson::Serialize(Yson::From($x)));

$getTraffic = ($add_info) -> {
    $res = Yson::YPath($add_info, "/resolutions");
    $res = Yson::ConvertToDict($res);
    $keys = ListUniq(ListMap(DictKeys($res), ($x)->($chooseQuality($x))));
    $res = DictItems($res);
    return ToDict(ListMap(
        $keys, ($k) -> (AsTuple($k, <|
            `count`: ListSum(ListNotNull(ListMap($res, ($tup)->(IF(
                $chooseQuality($tup.0) = $k,
                Yson::LookupUint64($tup.1, "count")
            ))))),
            bytes_sent: ListSum(ListNotNull(ListMap($res, ($tup)->(IF(
                $chooseQuality($tup.0) = $k,
                Yson::LookupUint64($tup.1, "bytes_sent")
            )))))
        |>))
    ))
};

$getPA = ($pa_data) -> {
    $pa_data = Yson::ConvertToDict($pa_data);
    $keys = ListFilter(DictKeys($pa_data), ($x)->(cast($x as Uint64) is not null));
    $keys = ListUniq(ListMap($keys, ($x)->($chooseQuality($x))));
    $pa_data = DictItems($pa_data);
    return ToDict(ListMap(
        $keys, ($k)->(
            AsTuple($k, <|
                watched_time: ListSum(ListNotNull(ListMap($pa_data, ($tup)->(IF(
                    cast($tup.0 as Uint64) is not null and $chooseQuality($tup.0) = $k,
                    Yson::LookupDouble($tup.1, "watchedTime")
                ))))),
                stalled_time: ListSum(ListNotNull(ListMap($pa_data, ($tup)->(IF(
                    cast($tup.0 as Uint64) is not null and $chooseQuality($tup.0) = $k,
                    Yson::LookupDouble($tup.1, "stalledTime")
                ))))),
                stalled_count: ListSum(ListNotNull(ListMap($pa_data, ($tup)->(IF(
                    cast($tup.0 as Uint64) is not null and $chooseQuality($tup.0) = $k,
                    Yson::LookupUint64($tup.1, "stalledCount")
                )))))
            |>)
        )
    ))
};

$remapTB = ($test_buckets) -> {
    $sp = String::SplitToList($test_buckets, ";");
    $sp = ListMap($sp, ($x)->(ListMap(String::SplitToList($x, ","), ($x)->(cast($x as Int64)))));
    $keys = ListNotNull(ListUniq(ListMap($sp, ($x)->($x[0]))));
    $map = ToDict(ListMap(ListNotNull($keys), ($k)->(AsTuple(
        unwrap(cast($k as String)), ListUniq(ListNotNull(ListMap(ListFilter($sp, ($x)->($x[0] = $k)), ($x)->($x[2]))))
    ))));
    return $yson($map)
};

$w = ($x) -> (IF($x = "", null, $x));

$remap_features = (
    select
        ref_from,
        ref_from_block,
        stream_block,
        $w(Yson::LookupString(zen_data, "strongest_id")) ?? $w(puid) ?? $w(device_id) ?? $w(icookie) ?? $w(yandexuid) as strongestId,
        `UUID`,
        $remapTB(test_buckets) as buckets,
        Yson::LookupString(zen_data, "strongest_id") as strongest_id,
        Yson::LookupInt64(zen_data, "item_id") as item_id,
        Yson::LookupString(zen_data, "rid") as rid,
        Yson::LookupString(zen_data, "stream_block") as zen_stream_block,
        Yson::LookupString(zen_data, "ppi") as ppi,
        view_time,
        view_time_non_muted,
        bytes_sent,
        ListLength(ListFilter(Yson::ConvertToList(errors), ($x)->(Yson::LookupString($x, "id") like "%_fatal"))) ?? 0.0 as fatals,
        $getTraffic(add_info) as traffic,
        $getPA(player_alive_data) as pa_data,
        os_family,
        browser_name,
        browser_version
    from $sessions_table
    where ref_from like "zen%" and ($w(Yson::LookupString(zen_data, "strongest_id")) ?? $w(puid) ?? $w(device_id) ?? $w(icookie) ?? $w(yandexuid)) is not null
);


$_countUsefulBytesSent = ($traffic, $pa_data) -> {
    $pa_data = ToDict(ListMap(DictItems($pa_data), ($tup)->(AsTuple($tup.0, ($tup.1).watched_time))));
    $tvt = ListSum(ListNotNull(DictPayloads($pa_data))) ?? 0.0;
    $useful_bytes_sent = ListMap(DictItems($traffic), ($tup)->(
        AsTuple($tup.0,
        IF(
            $tup.0 = "audio",
            ($tup.1).bytes_sent * min_of(($tvt / (($tup.1).`count` * 4.0)) ?? 0.0, 1),
            ($tup.1).bytes_sent * min_of((($pa_data[$tup.0] ?? 0.0) / (($tup.1).`count` * 4.0)) ?? 0.0, 1.0)
        )))
    );
    return $useful_bytes_sent
};

$countUsefulBytesSent = ($traffic, $pa_data) -> (
    ListSum(ListNotNull(ListMap($_countUsefulBytesSent($traffic, $pa_data), ($x)->($x.1)))) ?? 0.0
);

$countTotal = ($dct, $val) -> {
    $keys = DictKeys($dct);
    $values = ListMap(
        $keys, ($k)->(cast(TryMember($dct[$k], $val, 0.0) as Double))
    );
    return ListSum(ListNotNull($values)) ?? 0.0
};

$add_features = (
    SELECT
        $yson($_countUsefulBytesSent(traffic, pa_data)) as useful_bytes_sent_debug,
        $countUsefulBytesSent(traffic, pa_data) as useful_bytes_sent,
        $countTotal(pa_data, "watchedTime") as pa_total_watched_time,
        $countTotal(pa_data, "stalledTime") as pa_total_stalled_time,
        $countTotal(pa_data, "stalledCount") as pa_total_stalled_count,
        $yson(pa_data) as pa_data,
        $yson(traffic) as traffic,
        s.* without pa_data, traffic
    from $remap_features as s
);

insert into $output_table with truncate
select * from $add_features
order by strongestId;