#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import datetime
import re
import yt.wrapper as yt

PREPROCESSED_NEW = """
$strm_map = (
    select
    IF(a.androidVsid is not null, a.vsid, s.vsid) as vsid,
    s.* without s.vsid
    from $strm_map_table as s
    left join any $androidvsids_table as a
    on (s.vsid == a.androidVsid)
);
$preprocessed = (
    select * from $strm_map
    union all
    select * from $jstracer_map_table
    union all
    select * from $rtbdsp_map_table
    union all
    select * from $redir_map_table
);
"""
PREPROCESSED_OUTPUT = (
    "INSERT INTO $output_table_preprocessed WITH TRUNCATE\nSELECT * FROM $preprocessed;"
)
PREPROCESSED_EXISTING = "$preprocessed = select * from $output_table_preprocessed;"


def replace_parameters(query, args):
    date = args.date
    date_ = datetime.datetime.strptime(date, "%Y-%m-%d").date()
    query = query.replace("@[date]", date)
    query = query.replace("@[date_from]", date)
    query = query.replace("@[date_to]", date)
    if args.pool:
        query = query.replace("@[pool]", args.pool)
    else:
        query = re.sub("pragma yt\.pool ?=.+?;", "", query, flags=re.I)
    query = query.replace("@[weight]", str(args.weight))
    query = query.replace("@[root]", args.root)
    folder = f"//cubes/video-strm/{date}"
    if args.type in ("pre", "sessions") and not yt.exists(folder):
        print(f"creating {folder}")
        yt.create("map_node", path=folder)
    if args.type == "sessions":
        query = query.replace("@[week_ago]", str(date_ - datetime.timedelta(days=7)))
        alice = yt.exists(f"//home/alice/dialog/prepared_logs_expboxes/{date}")
        if args.use_existing_preprocessed:
            query = query.replace("--@[preprocessed]", PREPROCESSED_EXISTING)
            query = query.replace("--@[preprocessed_output]", "")
        else:
            query = query.replace("--@[preprocessed]", PREPROCESSED_NEW)
            if not args.disable_preprocessed:
                query = query.replace("--@[preprocessed_output]", PREPROCESSED_OUTPUT)
        if alice:
            query = query.replace("/*alice", "")
            query = query.replace("alice*/", "")
    if args.check_type:
        query = query.replace("@[check_type]", args.check_type)
    return query


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--pool")
    parser.add_argument("--weight", type=int, default=1)
    parser.add_argument("--date")
    parser.add_argument("--root", default="//cubes/video-strm")
    parser.add_argument("--type", choices=["pre", "sessions", "other_report"], default="pre")
    parser.add_argument("--use_existing_preprocessed", action="store_true")
    parser.add_argument("--disable_preprocessed", action="store_true")
    parser.add_argument("--query_file", default="input.sql")
    parser.add_argument("--output_query_file", default="output.sql")
    parser.add_argument("--check_type")
    args = parser.parse_args()

    with open(args.query_file, "r", encoding="utf8") as f:
        query = f.read()
    query = replace_parameters(query, args)
    with open(args.output_query_file, "w", encoding="utf8") as f:
        f.write(query)


if __name__ == "__main__":
    main()
