use hahn;
pragma library("common.sql");
pragma yt.PoolTrees = "physical";
pragma yt.Pool = "@[pool]";
pragma yt.DefaultOperationWeight = "@[weight]";
pragma yt.UseDefaultTentativePoolTrees;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma DqEngine = "disable";
pragma yson.DisableStrict;
IMPORT common SYMBOLS $undefWrapper, $parseUA, $getHash, $wrapYandexuid,
$re_playerVersion, $strmNotBadRequest, $getStrmRequestType, $parseSignedUrl,
$getParamWrapper, $strmGetVsid, $getYuHash, $getQuality, $get_request_ts, $getExtension,
$get_view_type, $getCategory, $get_channel_old, $isKal, $isDhd;

$source_table = "//logs/strm-access-log/1d/@[date]";
$output_table = "@[root]/@[date]/strm_map";

insert into $output_table WITH TRUNCATE 
SELECT 
    "strm" as source,
    $getStrmRequestType(uri) as event,
    cast(unixtime as Int64) as `timestamp`,
    $strmGetVsid(request, referer) as vsid,
    $isKal(request) as is_kal,
    $isDhd(request) as is_dhd,
    user_agent,
    $parseUA(user_agent).browser_name as browser_name,
    $parseUA(user_agent).os_family as os_family,
    $parseUA(user_agent).browser_version as browser_version,
    $parseUA(user_agent).device_type as device_type,
    remote_addr,
    Geo::RegionByIp(remote_addr).id as region,
    Geo::RoundRegionByIp(remote_addr, "country").short_en_name as country,
    Geo::GetAsset(remote_addr) as a_station,
    Geo::GetIspNameByIp(remote_addr) as provider,
    $getParamWrapper(request, referer, "from") as ref_from,
    $getParamWrapper(request, referer, "from_block") as ref_from_block,
    Url::Decode($getParamWrapper(request, referer, "stream_block")) as stream_block,
    $getParamWrapper(request, referer, "partner_id") as page_id,
    $getParamWrapper(request, referer, "reqid") as reqid,
    $wrapYandexuid($getParamWrapper(request, referer, "yandexuid")) as yandexuid,
    $getYuHash(request, referer) as yu_hash,
    $getYuHash(request, referer) ?? ("vsid_" || $strmGetVsid(request, referer)) as user_id,
    $getParamWrapper(request, referer, "video_content_id") as video_content_id,
    $getQuality(request) as resolution,
    $getCategory(request, referer) as category_id,
    $re_playerVersion(referer)._1 as player_version,
    $get_channel_old(request) as channel_old,
    $get_request_ts(request) as request_ts,
    $get_view_type(request) as view_type,
    $getExtension(uri) as extension,
    cast(bytes_sent as UInt64) as bytes_sent
from $source_table
where
    status in ("200", "206")
    and $getStrmRequestType(uri) is not null
    and $strmNotBadRequest(request)
    and $strmNotBadRequest(args)
    and not is_subrequest
    and $strmGetVsid(request, referer) is not null