use hahn;
pragma yt.Pool = "@[pool]";
pragma library("get_ugc_meta.sql");
import get_ugc_meta symbols $get_ugc_meta;
pragma library("stability_common.sql");
import stability_common symbols $mskDateFromTs;
pragma yson.DisableStrict;

$date = "@[date]";
$date_from = cast(cast($date as Date) - DateTime::IntervalFromDays(90) as String);
$output_table_raw = "//home/videolog/MMA-5428-top-ugc-videos/top_raw";
$output_table = "//home/videolog/MMA-5428-top-ugc-videos/top";
$last_date_table = "//home/videolog/MMA-5428-top-ugc-videos/last_date";

insert into $last_date_table WITH TRUNCATE 
select $date as last_date;

$get_hd_vt = ($pa_data) -> {
    return (Yson::YPathDouble($pa_data, "/hd/watchedTime") ?? 0.0)
    + (Yson::YPathDouble($pa_data, "/fhd/watchedTime") ?? 0.0)
};

$map = (
    select
        `UUID`,
        view_time,
        price,
        $get_hd_vt(player_alive_data) ?? 0.0 as view_time_hd
    from range(
        `cubes/video-strm`, $date_from, $date, `sessions`
    )
    where view_time > 0 and `UUID` like "v%"
);

$grouped = (
    select
        `UUID`, count(*) as views, sum(view_time) as tvt, sum(view_time_hd) as tvt_hd,
        (sum(price) / 1000000.0) ?? 0.0 as price_rub
    from $map
    group by `UUID`
);

$join_channels_ = (
    select
        g.*, channel_id, video_title, channel_name,
        video_file_id, video_id as video_meta_id, service as ugc_service,
        $mskDateFromTs(video_create_time) as create_date, privacy, channel_privacy, moderation_status, deleted
    from $grouped as g
    inner join any $get_ugc_meta() as i on (g.`UUID` = i.video_content_id)
);

insert into $output_table_raw WITH TRUNCATE
select * from $join_channels_;

$join_channels = (select * from $join_channels_ where privacy = "public" and channel_privacy = "public" and not deleted);

insert into $output_table WITH TRUNCATE 
select * from $join_channels
order by tvt_hd desc;
