use hahn;
pragma yt.Pool = '@pool';
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";

$date_from = '@date_from';
$date_to = '@date_to';
$output_table = '@output_table';

$ornull = ($x, $y) -> {
    RETURN IF(
        $x is not null,
        String::Substring($x, 0, 100),
        $y
    )
};

$bad_vcids = AsList("novcid", "-", NULL, "");

$myshell_filter = ($add_info, $vsid, $vcid) -> {
    RETURN (
        Yson::LookupString($add_info, "sources_aggr") like '%js_tracer_start%' OR
        Yson::LookupString($add_info, "sources_aggr") like '%js_tracer_heartbeat%' OR
        (
            Yson::LookupString($add_info, "sources_aggr") like '%strm_chunk%' AND
            Yson::ConvertToInt64(Yson::YPath($add_info, "/chunks_types/ts")) > 0
        )
    ) AND (
        Length($vsid) > 24 AND NOT ListHas($bad_vcids, $vcid)
    )
};

$source = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        $ornull(ref_from, "–") as ref_from,
        $ornull(category_id, "-") as category_id,
        vsid,
        video_content_id,
        view_time,
        price,
        yu_hash,
        IF(view_time > 30, yu_hash, NULL) as yu_hash_30s,
        IF(
            NOT ListHas($bad_vcids, video_content_id),
            AsTuple(vsid, channel),
            NULL
        ) as vsid_channel,
        IF(
            $myshell_filter(add_info, vsid, video_content_id),
            AsTuple(vsid, channel),
            NULL
        ) as vsid_channel_myshell,
        IF(
            NOT ListHas($bad_vcids, video_content_id),
            AsTuple(vsid, video_content_id),
            NULL
        ) as vsid_vcid,
        IF(view_time > 0, 1, 0) as with_view,
        IF(price > 0, 1, 0) as with_money
    from RANGE(
        `cubes/video-strm`, $date_from, $date_to,
        `sessions`
    )
    where (
        view_time > 0 OR price > 0 OR shows_good > 0
    )
);


$totalize = ($row) -> {
    $result = AsList(
        $row,
        ExpandStruct(
            RemoveMember(
                RemoveMember($row, "category_id"),
                "ref_from"
            ),
            "_total_" as ref_from,
            "_total_" as category_id
        ),
        AddMember(
            RemoveMember($row, "category_id"),
            "category_id",
            "_total_"
        ),
        AddMember(
            RemoveMember($row, "ref_from"),
            "ref_from",
            "_total_"
        )
    );
    $extend = ListFlatMap(
        $result,
        ($x) -> {
            RETURN IF(
                $x.ref_from in ('morda', 'videohub', 'efir', 'streamhandler_other'),
                AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир")
            )
        }
    );
    $result = ListUnionAll($result, $extend);
    $extend = ListFlatMap(
        $result,
        ($x) -> {
            RETURN IF(
                $x.ref_from in ("morda_touch", "videohub_touch", "efir_touch", "streamhandler_appsearch"),
                AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир-тач")
            )
        }
    );
    $result = ListUnionAll($result, $extend);
    RETURN $result
};


$totalized = (
    process $source using $totalize(TableRow())
);


$grouped = (
    select
        fielddate,
        ref_from,
        category_id,
        COUNT(*) as microsessions_with_view_or_money,
        COUNT(DISTINCT vsid) as vsids,
        COUNT(DISTINCT yu_hash) as users,
        COUNT(DISTINCT yu_hash_30s) as users_30s,
        COUNT(DISTINCT vsid_vcid) as vsid_vcids,
        COUNT(DISTINCT vsid_channel) as vsid_channels,
        COUNT(DISTINCT vsid_channel_myshell) as vsid_channels_myshell,
        SUM(with_view) as microsessions_with_view,
        SUM(with_money) as microsessions_with_money,
        SUM(view_time) as tvt,
        SUM(price) as price
    from $totalized
    group by ref_from, category_id, fielddate
);

insert into $output_table with truncate
select * from $grouped
where not (
    ref_from != '_total_' and
    category_id != '_total_' and
    microsessions_with_view_or_money < 1000
);