use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;

$date = "@[date]";

$channel_table = "//home/video-hosting/ugc_replica/ugc_channel";
$sessions_table = "//cubes/video-strm/" || $date || "/sessions";

$ugc_channel_uids = (select distinct `channel.user_uid` from $channel_table where `channel.service` = "ugc");

$moved = (
    select `user.uid` as original_uid, `user.zen_moving_status` ?? "not_started" as zen_moving_status from `//home/video-hosting/ugc_replica/ugc_user`
    where `user.uid` in $ugc_channel_uids
);


$getResource = ($resources, $name) -> {
    $parsed = Yson::ConvertToList(Yson::ParseJson($resources));
    $filtered = ListFilter(
        $parsed,
        ($x)->(Yson::LookupString($x, "name") == $name)
    );
    return IF(
        ListLength($filtered) > 0,
        Yson::LookupString(unwrap($filtered[0]), "value"),
        null
    )
};

$both_uids = (
    select m.*, cast($getResource(`extra.resources`, "zen_uid") as Uint64) as new_uid
    from $moved as m
    left join any $channel_table as c on (m.original_uid = c.`channel.user_uid`)
);

$ib = "//home/videolog/strm_meta/iron_branch/concat";

$channel_to_uuids = (
    select
        computed_channel, CountDistinctEstimate(`UUID`) as total_uuids
    from (select [computed_channel, "_total_"] as computed_channel, `UUID` from $ib where ugc_owner_id is not null)
    flatten list by computed_channel
    group by computed_channel
);

$ugc_data_ = (
    select
        `UUID`, computed_channel, computed_program, bo.zen_moving_status ?? bn.zen_moving_status as zen_moving_status
    from $ib as i
    left join any $both_uids as bo on (i.ugc_owner_id = bo.original_uid)
    left join any $both_uids as bn on (i.ugc_owner_id = bn.new_uid)
);

$ugc_data = (select * from $ugc_data_ where zen_moving_status is not null);

$lvt = ($vt) -> (IF($vt > 30, Math::Log($vt), 0));

$sessions_map = (
    select
        fielddate,
        s.`UUID` as `UUID`,
        price,
        channel ?? "-" as channel,
        channel ?? "-" as channel_for_uniq,
        yandexuid ?? puid as user_id,
        view_time,
        view_time_non_muted,
        $lvt(view_time) as lvt,
        $lvt(view_time_non_muted) as lvt_non_muted,
        zen_moving_status
    from (select * from $sessions_table where `UUID` is not null) as s
    inner join any $ugc_data as u using (`UUID`)
);

$totalize = ($row) -> {
    $result = AsList($row);
    $add = ListCollect(ListMap($result, ($x)->(AddMember(RemoveMember($x, "zen_moving_status"), "zen_moving_status", "_total_"))));
    $result = ListCollect(ListUnionAll($result, $add));
    $add = ListCollect(ListMap($result, ($x)->(AddMember(RemoveMember($x, "channel"), "channel", "_total_"))));
    $result = ListCollect(ListUnionAll($result, $add));
    return $result
};

$totalized = process $sessions_map using $totalize(TableRow());

$grouped = (
    SELECT
        unwrap(fielddate) as fielddate,
        unwrap(zen_moving_status) as zen_moving_status,
        unwrap(channel) as channel,
        CountDistinctEstimate(channel_for_uniq) ?? 0 as channels,
        CountDistinctEstimate(`UUID`) ?? 0 as uuids,
        CountDistinctEstimate(IF(view_time > 0, `UUID`)) ?? 0 as viewed_content_ids,
        COUNT(*) as sessions,
        COUNT_IF(view_time >= 30) as sessions_30s,
        CountDistinctEstimate(user_id) ?? 0 as users,
        CountDistinctEstimate(IF(view_time >= 30, user_id)) ?? 0 as users_30s,
        (SUM(price) / 1000000.0) ?? 0 as price_rub
    from $totalized
    group by fielddate, zen_moving_status, channel
);

$join_total_uuids = (select g.*, total_uuids from $grouped as g left join any $channel_to_uuids as c on (g.channel = c.computed_channel));

insert into `home/videoquality/vh_analytics/MMA-5553/latest` WITH TRUNCATE 
select * from $join_total_uuids;

upsert into stat.`Video/Others/Strm/MMA-5553-zen-moving/daily` erase by (fielddate)
select * from $join_total_uuids;
