pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";

$date_from = "@date_from";
$date_to = "@date_to";
$output_table = "@output_table";

$getDeviceType = ($device_type, $ad_events) -> {
    $ad_events = Yson::ConvertToList($ad_events);
    $dt = Yson::LookupInt64($ad_events[0], "DeviceType");
    RETURN CASE
    WHEN $device_type is not null and $device_type != "-" THEN $device_type
    WHEN $dt == 5 THEN "desktop"
    WHEN $dt == 4 THEN "tablet"
    WHEN $dt == 3 THEN "phone"
    ELSE "other"
    END
};

$source = (
    select * from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
);

$channel_to_page_id = (
    select
        page_id,
        max(channel) as channel
    from $source
    group by page_id
);

-- @ref_from_preprocess

$tmp0 = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        price,
        partner_price,
        hits_good,
        winhits_good,
        hits_block_good,
        winhits_block_good,
        shows_good,
        page_id,
        channel,
        cast(category_id as Int64) as category_id,
        $getDeviceType(device_type, ad_events) as device_type,
        $ref_from_preprocess(ref_from) as ref_from,
        view_type
    from $source
    where price > 0
);

$tmp = (
    select * from $tmp0
    where channel is not null
);

$category_names = (
    select category_id, some(category) as category
    from `home/videolog/strm_meta/page_imp`
    group by category_id
);

$tmp_null = (
    select
        ctp.channel ?? "NO_CHANNEL" as channel,
        s.* without s.channel
    from $tmp0 as s
    left join $channel_to_page_id as ctp on (ctp.page_id == s.page_id)
    where s.channel is null and price > 0
);

$tmp_concat = (
    select * from $tmp
    union all
    select * from $tmp_null
);

$add_category_names = (
    select
        t.*, category ?? "unknown" as category
    from $tmp_concat as t
    left join $category_names as c using (category_id)
);

$grouped = (
    select
        fielddate,
        ref_from,
        category,
        channel,
        device_type,
        view_type,
        cast(sum(price) as double) / 1000000.0 as price,
        cast(sum(partner_price) as double) / 1000000.0 as partnerprice,
        sum(hits_good) as hits_good,
        sum(winhits_good) as winhits_good,
        sum(hits_block_good) as hits_block_good,
        sum(winhits_block_good) as winhits_block_good,
        sum(shows_good) as shows_good
    from $add_category_names
    group by
        fielddate,
        ref_from,
        category,
        channel,
        device_type,
        view_type
);

$totalizer = ($stru) -> {
    RETURN AsList(
        $stru,
        AsStruct(
            $stru.fielddate as fielddate,
            "_total_" as ref_from,
            "_total_" as category,
            "_total_" as channel,
            "_total_" as device_type,
            "_total_" as view_type,
            $stru.price as price,
            $stru.partnerprice as partnerprice,
            $stru.hits_good as hits_good,
            $stru.winhits_good as winhits_good,
            $stru.hits_block_good as hits_block_good,
            $stru.winhits_block_good as winhits_block_good,
            $stru.shows_good as shows_good
        ),
        AsStruct(
            $stru.fielddate as fielddate,
            $stru.ref_from as ref_from,
            "_total_" as category,
            "_total_" as channel,
            "_total_" as device_type,
            "_total_" as view_type,
            $stru.price as price,
            $stru.partnerprice as partnerprice,
            $stru.hits_good as hits_good,
            $stru.winhits_good as winhits_good,
            $stru.hits_block_good as hits_block_good,
            $stru.winhits_block_good as winhits_block_good,
            $stru.shows_good as shows_good
        ),
        AsStruct(
            $stru.fielddate as fielddate,
            "_total_" as ref_from,
            $stru.category as category,
            "_total_" as channel,
            "_total_" as device_type,
            "_total_" as view_type,
            $stru.price as price,
            $stru.partnerprice as partnerprice,
            $stru.hits_good as hits_good,
            $stru.winhits_good as winhits_good,
            $stru.hits_block_good as hits_block_good,
            $stru.winhits_block_good as winhits_block_good,
            $stru.shows_good as shows_good
        ),
        AsStruct(
            $stru.fielddate as fielddate,
            "_total_" as ref_from,
            "_total_" as category,
            $stru.channel as channel,
            "_total_" as device_type,
            "_total_" as view_type,
            $stru.price as price,
            $stru.partnerprice as partnerprice,
            $stru.hits_good as hits_good,
            $stru.winhits_good as winhits_good,
            $stru.hits_block_good as hits_block_good,
            $stru.winhits_block_good as winhits_block_good,
            $stru.shows_good as shows_good
        ),
        AsStruct(
            $stru.fielddate as fielddate,
            "_total_" as ref_from,
            "_total_" as category,
            "_total_" as channel,
            $stru.device_type as device_type,
            "_total_" as view_type,
            $stru.price as price,
            $stru.partnerprice as partnerprice,
            $stru.hits_good as hits_good,
            $stru.winhits_good as winhits_good,
            $stru.hits_block_good as hits_block_good,
            $stru.winhits_block_good as winhits_block_good,
            $stru.shows_good as shows_good
        ),
        AsStruct(
            $stru.fielddate as fielddate,
            "_total_" as ref_from,
            "_total_" as category,
            "_total_" as channel,
            "_total_" as device_type,
            $stru.view_type as view_type,
            $stru.price as price,
            $stru.partnerprice as partnerprice,
            $stru.hits_good as hits_good,
            $stru.winhits_good as winhits_good,
            $stru.hits_block_good as hits_block_good,
            $stru.winhits_block_good as winhits_block_good,
            $stru.shows_good as shows_good
        )
    )
};

$totalized = (process $grouped using $totalizer(TableRow()));

$grouped2 = (
    select
        fielddate,
        ref_from,
        category,
        channel,
        device_type,
        view_type,
        sum(price) as price,
        sum(partnerprice) as partnerprice,
        sum(hits_good) as hits_good,
        sum(winhits_good) as winhits_good,
        sum(hits_block_good) as hits_block_good,
        sum(winhits_block_good) as winhits_block_good,
        sum(shows_good) as shows_good
    from $totalized
    group by
        fielddate,
        ref_from,
        category,
        channel,
        device_type,
        view_type
);

insert into $output_table WITH TRUNCATE
select * from $grouped2;
