use hahn;
pragma yt.Pool = 'videolog';

$date_start = '@date_start';
$date_finish = '@date_finish';

$ref_froms = AsList(
    "ottwidget_yavideo",
    "morda",
    "yavideo",
    "videohub",
    "ottwidget_morda",
    "yanews",
    "morda_touch",
    "streamhandler_tv",
    "serp",
    "ottwidget_ya-serp",
    "streamhandler_serp",
    "morda_touch"
);

$bad_vcids = AsList(
    "", "-", "novcid"
);

$total = ($x) -> {RETURN IF($x IS NULL, "_total_", $x)};

$ornull = ($x, $y) -> {RETURN IF($x IS NULL, $y, $x)};

$addHyphensPy = @@
def add_hyphens(s):
    if not s:
        return b''
    return s[:4] + b'-' + s[4:6] + b'-' + s[6:8]
@@;

$addHyphens = Python::add_hyphens(ParseType("(String?)->String"), $addHyphensPy);

$tmp0 = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        category_id,
        view_time,
        add_info,
        price,
        partner_price,
        video_content_id
    from RANGE(
        `home/videoquality/vh_analytics/strm_cube_2`,
        $date_start, $date_finish, `sessions`
    )
    where channel_old != 'zen'
);

$tmp_money = (
    select
        fielddate,
        $total(category_id) as category_id,
        CAST(sum(price) As Double) / 1000000.0 as price_pecheny,
        CAST(sum(partner_price) As Double) / 1000000.0 as partner_price_pecheny
    from $tmp0
    where category_id is not null and category_id != '-'
    group by CUBE(category_id), fielddate
);

$tmp_money_myshell_0 = (
    SELECT
        `date` as fielddate,
        CAST(category_id as String) as category_id,
        sum(price) as price,
        sum(partner_price) as partner_price
    from `@money_table`
    where category_id IS NOT NULL and (
        category like '%vh%' or category like '%VH%'
    )
    group by `date`, category_id
);

$tmp_money_myshell = (
    select
        fielddate,
        $total(category_id) as category_id,
        CAST(sum(price) As Double) / 1000000.0 as price,
        CAST(sum(partner_price) As Double) / 1000000.0 as partner_price
    from $tmp_money_myshell_0
    group by CUBE(category_id), fielddate
);

$tmp_money_myshell_final = (
    SELECT
        $addHyphens(fielddate) as fielddate,
        category_id,
        price,
        partner_price
    from $tmp_money_myshell
);

insert into `home/videolog/tmp/tmp_money_myshell_final` with truncate
select * from $tmp_money_myshell_final;

$get_duration = ($x, $y) -> {
    RETURN Yson::ConvertToInt64(
        Yson::YPath($x, "/durations/" || $y)
    )
};

$check_good_duration = ($x) -> {
    $redir = $get_duration($x, "redir");
    $js_tracer = $get_duration($x, "js_tracer");
    $strm = $get_duration($x, "strm");
    RETURN $redir IS NOT NULL OR $js_tracer IS NOT NULL OR $strm IS NOT NULL
};

$tmp_view_time = (
    select
        fielddate,
        $total(category_id) as category_id,
        CAST(sum(view_time) As Double) / (60.0 * 60.0) as tvt
    from $tmp0
    where category_id != '-' and category_id is not null and video_content_id is not null and not ListHas($bad_vcids, video_content_id) and (fielddate < '2018-09-01' or $check_good_duration(add_info))
    group by CUBE(category_id), fielddate
);

$tmp1 = (
    SELECT
        $ornull(v.fielddate, m.fielddate) as fielddate,
        $ornull(v.category_id, m.category_id) as category_id,
        $ornull(m.price_pecheny, 0.0) as price_pecheny,
        $ornull(m.partner_price_pecheny, 0.0) as partner_price_pecheny,
        $ornull(mm.price, 0.0) as price,
        $ornull(mm.partner_price, 0.0) as partner_price,
        $ornull(v.tvt, 0.0) as tvt
    from $tmp_money as m
    left join $tmp_money_myshell_final as mm on (m.fielddate == mm.fielddate and m.category_id == mm.category_id)
    full join $tmp_view_time as v on (m.fielddate == v.fielddate and m.category_id == v.category_id)
);

$tmp2 = (
    select
        fielddate,
        category_id,
        tvt,
        $ornull(price, 0.0) as price,
        $ornull(partner_price, 0.0) as partner_price,
        $ornull(price_pecheny, 0.0) as price_pecheny,
        $ornull(partner_price_pecheny, 0.0) as partner_price_pecheny,
        IF(tvt == 0.0, 0.0, $ornull(price, 0.0) / tvt) as price_per_hour,
        IF(tvt == 0.0, 0.0, $ornull(partner_price, 0.0) / tvt) as partner_price_per_hour
    from $tmp1
);

$page_imp_prep = (
    SELECT
        CAST(category_id as String) as category_id,
        category
    from `//home/videolog/strm_meta/page_imp`
);

$page_imp_cat_names = (
    select distinct category_id, category from $page_imp_prep
);

$tmp3 = (
    select
        t.fielddate as fielddate,
        t.category_id as category_id,
        IF(t.category_id == "_total_", "_total_", t.category_id || "_" || $ornull(cn.category, "other")) as category_name,
        t.tvt as tvt,
        t.price as price,
        t.partner_price as partner_price,
        t.price_pecheny as price_pecheny,
        t.partner_price_pecheny as partner_price_pecheny,
        t.price_per_hour as price_per_hour,
        t.partner_price_per_hour as partner_price_per_hour
    from $tmp2 as t
    left join $page_imp_cat_names as cn
    using (category_id)
);

$tmp4 = (
    select
        fielddate,
        category_id,
        category_name,
        sum(tvt) as tvt,
        sum(price) as price,
        sum(partner_price) as partner_price,
        sum(price_pecheny) as price_pecheny,
        sum(partner_price_pecheny) as partner_price_pecheny,
        IF(sum(tvt) == 0.0, 0.0, $ornull(sum(price), 0.0) / sum(tvt)) as price_per_hour,
        IF(sum(tvt) == 0.0, 0.0, $ornull(sum(partner_price), 0.0) / sum(tvt)) as partner_price_per_hour
    from $tmp3
    group by fielddate, category_id, category_name
);

insert into `@output_table_tmp` with truncate
select * from $tmp4
order by fielddate, category_id;

insert into `@output_table` with truncate
select * from $tmp4
where (price > 0 or tvt > 0) and category_id != '0'
order by fielddate, category_id
