PRAGMA yt.InferSchema;
USE hahn;
PRAGMA yt.Pool="@pool";
Pragma SimpleColumns;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";
PRAGMA yt.DefaultOperationWeight = '10';
PRAGMA yson.DisableStrict;


$getString = ($json, $fieldPath) -> {
        return Yson::ConvertToString(Yson::YPath(Yson::ParseJson($json), $fieldPath));
        };

$getInt = ($json, $fieldPath) -> {
        return Yson::ConvertToInt64(Yson::YPath(Yson::ParseJson($json), $fieldPath));
        };

$date_start = "@date_start";
$date_finish = "@date_finish";


$dspid =
(
    select
        DSPID,
        if(Title like '%-12' or Title like '%IMHO%', 'imho', if(Title like '%Audio%','audio', if(Title like '%-10' or Title like '%Auction%', 'auction', if(Tag = 'awaps', 'price', 'direct')))) as dsp_name
    from
        `home/yabs/dict/DSPTemplate`
    where
        ((Tag == 'awaps' and DSPType in (2,6,7)) or DSPID == 1)
    union all
    select
        0 as DSPID,
        'dsp_for_hits' as dsp_name
);

-- достаем всю информациб про рекламные настройки, сюда не попадет interstitial в in-app (для него реализован следующий блок)
$BlockSettings_standart=
(   
    select
        BlockSettingsID,
        case
            when $getInt(Settings, '/video-placement')==1 then 'instream'
            when $getInt(Settings, '/video-placement')==5 then 'interstitial'
            when $getInt(Settings, '/video-placement')==3 then 'inpage'
            else 'other'
        end as type,

        $getInt(Settings, '/video-category-id') as category_id,
        if($getInt(Settings, '/video-category-id')<1000,'other',$getString(Settings, '/video-category-name')) as category,

        case
            when $getInt(Settings, '/video-placement')==1 and $getInt(Settings, '/video-startdelay')==0 and $getInt(Settings, '/video-linearity')==1 then 'preroll'
            when $getInt(Settings, '/video-placement')==1 and $getInt(Settings, '/video-startdelay')==-1 and $getInt(Settings, '/video-linearity')==1 then 'midroll'
            when $getInt(Settings, '/video-placement')==1 and $getInt(Settings, '/video-startdelay')==-2 and $getInt(Settings, '/video-linearity')==1 then 'postroll'
            when $getInt(Settings, '/video-placement')==1 and $getInt(Settings, '/video-startdelay')==-3 and $getInt(Settings, '/video-linearity')==1 then 'pauseroll'
            when $getInt(Settings, '/video-placement')==1 and $getInt(Settings, '/video-startdelay')==-1 and $getInt(Settings, '/video-linearity')==2 then 'overlay'
            when $getInt(Settings, '/video-placement')==3 and $getInt(Settings, '/video-startdelay')==0 and $getInt(Settings, '/video-linearity')==2 then 'inpage'
            when $getInt(Settings, '/video-placement')==5 and $getInt(Settings, '/video-startdelay')==0 and $getInt(Settings, '/video-linearity')==2 and $getInt(Settings, '/instl')==1 then 'interstitial'
            when $getInt(Settings, '/video-placement')==5 and $getInt(Settings, '/video-startdelay')==0 and $getInt(Settings, '/video-linearity')==2 and $getInt(Settings, '/instl')==0 then 'fullscreen'
            else 'other'
        end as video_type

    From
        `home/yabs/dict/BlockSettings`
    where
        $getInt(Settings, '/video-placement') is not null
);

-- достаем interstitial в in-app
$BlockSettings_inapp=
(
    select
        BlockSettingsID,
        Yson::ConvertToString(
            Yson::YPath(Yson::ParseJson('{'||Design||'}'), "/name")
        ) as type,
        0 as category_id,
        'other' as category,
        'in_app' as video_type
    from
        `home/yabs/dict/BlockSettings`
    where
        Yson::ConvertToString(
            Yson::YPath(Yson::ParseJson('{'||Design||'}'), "/name")
        ) = 'interstitial'
);

-- объединяем настройки видеоблоков
$BlockSettings_all=
(
    select * from $BlockSettings_standart
    union all
    select * from $BlockSettings_inapp
);

-- исключаем блоки, которые есть только на имхо и только на локальных дсп (для упрощения расчета)
$pddi =
(
    select
        PageID,
        ImpID,
        type,
        video_type,
        category_id,
        category
    from
        `home/yabs/dict/PageDSP` as pd
    inner join
        $dspid as di
    on
        pd.DSPID == di.DSPID
    inner join
        $BlockSettings_all as bs
    on
        pd.BlockSettingsID == bs.BlockSettingsID
    where
        pd.DSPID not in (5,10)
        and di.dsp_name != 'imho'
    group by
        pd.PageID as PageID,
        pd.ImpID as ImpID,
        bs.type as type,
        bs.video_type as video_type,
        bs.category as category,
        bs.category_id as category_id
);


--
$page_imp_video =
(
    select
        *
    from
        `home/yabs/dict/PageImp` as pi
    where
        AdTypeVideo OR AdTypeVideoMotion OR AdTypeVideoPerformance
);

$name=
(
SELECT 
    ContentGroupID,
    Name
from
    `home/video-hosting/base/ContentGroup`
WHERE 
    ContentTypeID=2
);

$page=
(
SELECT 
    ContentGroupID,
    Value
from
    `home/video-hosting/base/ContentResource`
WHERE 
    ResourceName='page_id'
);

$page_channel=
(
select
    min(A.Name) as channel,
    page
FROM
    $name as A
inner join
    $page as B
on
    A.ContentGroupID==B.ContentGroupID
group by
    B.Value as page
);

$page_imp =
(
    select
        if(pddi.category is null or pddi.category == 'other' or pddi.category == "Я.Видео Спецразмещение",page.Name,'vh') as not_vh_partner,
        
        if( pddi.category is not null and 
            pddi.category != 'other'
            and pddi.category != "Я.Видео Спецразмещение",
            if(
                channel.channel is null,
                page.Name,
                channel.channel
            ),
            'not_vh'
        ) as vh_partner,
        
        piv.PageID as PageID,
        piv.ImpID as ImpID,
        pddi.type as type,
        if(pddi.category=="VH: Кинопоиск",'vh_kinopoisk',
            if(pddi.category=="VH: Я.Видео",'vh_ya_video',
            if(pddi.category=='Я.Видео','ya_video',
            if(pddi.category=="Я.Видео Спецразмещение",'ya_video_premium',
            if(pddi.category=="VH: Сайт Правообладателя",'vh_owner_host',
            if(pddi.category=="VH: Поиск",'vh_search',
            if(pddi.category=="VH: Телепрограмма",'vh_tv_program',
            if(pddi.category=="VH: Главная",'vh_main',
            if(pddi.category=="VH: Другое",'vh_other',
            if(pddi.category=="VH: Я.Новости",'vh_news',
            pddi.category
        )))))))))) as category,
        pddi.category_id as category_id,
        pddi.video_type as video_type
    from
        $page_imp_video as piv
    inner join
        $pddi as pddi
    on
        piv.PageID = pddi.PageID
        and piv.ImpID = pddi.ImpID
    inner join
        `home/yabs/dict/Page` as page
    on
        piv.PageID = page.PageID
    left join
        $page_channel as channel
    on
        cast(channel.page as uint64)==piv.PageID
);


$dsp_blocks =
(
    select
        DateTime::Format("%Y%m%d")(
            AddTimezone(DateTime::FromSeconds(CAST(eventtime as Uint32)), "Europe/Moscow")
        ) as `date`,
        pageid,
        producttype,
        impid,
        dspid,
        devicetype,
        detaileddevicetype,
        if(Dsv::Parse(queryargs, "&")["709"] is null,0,1) as overlay,
        Dsv::Parse(queryargs, "&")["708"] as wrapper,
        
        --считаем все винхиты (на каждую позицию рюкзака)
        if((countertype == 0 and 
            win == 1 and 
            dspid not in (5,10)), cast(1 as Uint64), cast(0 as Uint64)) as winhits_all,
        
        --считаем все винхиты без фрода (на каждую позицию рюкзака)    
        if((countertype == 0 and 
            win == 1 and 
            dspid not in (5,10) and
            dspfraudbits==0 and
            dspeventflags==0), cast(1 as Uint64), cast(0 as Uint64)) as winhits_good,
            
        --считаем все винхиты за рюкзаком (на первую позицию рюкзака)
        if((countertype == 0 and 
            win == 1 and 
            dspid not in (5,10) and
            position==0), cast(1 as Uint64), cast(0 as Uint64)) as winhits_block_all,
            
        --считаем все винхиты за рюкзаком без фрода (на первую позицию рюкзака)
        if((countertype == 0 and 
            win == 1 and 
            dspid not in (5,10) and
            dspfraudbits==0 and
            dspeventflags==0 and
            position==0), cast(1 as Uint64), cast(0 as Uint64)) as winhits_block_good,
            
        --считаем все показы без фрода (на каждую позицию рюкзака)
        if((countertype == 1 and 
            win == 1 and 
            dspid not in (5,10) and
            dspfraudbits==0 and
            dspeventflags==0), cast(1 as Uint64), cast(0 as Uint64)) as shows_good,
        
        --считаем все показы за рюкзаком без фрода (на первую позицию рюкзака)
        if((countertype == 1 and 
            win == 1 and 
            dspid not in (5,10) and
            dspfraudbits==0 and
            dspeventflags==0 and
            position==0), cast(1 as Uint64), cast(0 as Uint64)) as shows_block_good,  
        
        --считаем партнерские деньги без фрода
        if(countertype == 1 and 
           dspid not in (5,10) and
           dspfraudbits==0 and
           dspeventflags==0, partnerprice, cast(0 as Uint64)) as partner_price,
           
        --считаем общие деньги без фрода
        if(countertype == 1 and 
           dspid not in (5,10) and
           dspfraudbits==0 and
           dspeventflags==0, price, cast(0 as Uint64)) as price,

        0 as hits_all,
        0 as hits_good,
        0 as hits_block_all,
        0 as hits_block_good
    from
        range(
            `//statbox/cooked_logs/bs-dsp-cooked-log/v1/1d`,
            $date_start, $date_finish
        )
);

$dsp_hits =
(
    select
        DateTime::Format("%Y%m%d")(
            AddTimezone(DateTime::FromSeconds(CAST(eventtime as Uint32)), "Europe/Moscow")
        ) as `date`,
        pageid,
        impid,
        devicetype,
        detaileddevicetype,
        if(Dsv::Parse(queryargs, "&")["709"] is null,0,1) as overlay,
        Dsv::Parse(queryargs, "&")["708"] as wrapper,
        0 as dspid,
        '0' as producttype,

        0 as winhits_all,
        0 as winhits_good,
        0 as winhits_block_all,
        0 as winhits_block_good,
        0 as shows_good,
        0 as shows_block_good,
        0 as partner_price,
        0 as price,
        
        --считаем все хиты (на каждую позицию рюкзака)
        if((countertype == 0 and 
            win == 1 and
            position=0), cast(1 as Uint64), cast(0 as Uint64))*maxadscount as hits_all,
        
        --считаем все хиты без фрода (на каждую позицию рюкзака)    
        if((countertype == 0 and 
            win == 1 and 
            dspfraudbits==0 and
            dspeventflags==0 and
            position=0), cast(1 as Uint64), cast(0 as Uint64))*maxadscount as hits_good,
        -- если первый хит зафрожен, то я считаю, что хиты за всеми позициями зафрожены    
        
            
        --считаем все хиты за рюкзаком (на первую позицию рюкзака)
        if((countertype == 0 and 
            win == 1 and 
            position==0), cast(1 as Uint64), cast(0 as Uint64)) as hits_block_all,
            
        --считаем все хиты за рюкзаком без фрода (на первую позицию рюкзака)
        if((countertype == 0 and 
            win == 1 and 
            dspfraudbits==0 and
            dspeventflags==0 and
            position==0), cast(1 as Uint64), cast(0 as Uint64)) as hits_block_good
    from
        range(
            `//statbox/cooked_logs/bs-dsp-cooked-log/v1/1d`,
            $date_start, $date_finish
        )
);

$dsp =
(
    select
        * 
    from
        $dsp_blocks
    UNION ALL
        select
        *
    from
        $dsp_hits
);

$dsp_reduce =
(
    select
        `date`,
        pageid,
        impid,
        dspid,
        devicetype,
        detaileddevicetype,
        overlay,
        wrapper,
        producttype,

        sum(winhits_all) as winhits_all,
        sum(winhits_good) as winhits_good,
        sum(winhits_block_all) as winhits_block_all,
        sum(winhits_block_good) as winhits_block_good,
        
        sum(hits_all) as hits_all,
        sum(hits_good) as hits_good,
        sum(hits_block_all) as hits_block_all,
        sum(hits_block_good) as hits_block_good,
        
        sum(shows_good) as shows_good,
        sum(shows_block_good) as shows_block_good,
        
        sum(partner_price) as partner_price,
        sum(price) as price
    from
        $dsp
    group by
        `date`,
        pageid,
        impid,
        devicetype,
        detaileddevicetype,
        dspid,
        overlay,
        wrapper,
        producttype
);

$dsp_imp_join =
(
    select
        A.`date` as `date`,
        A.pageid as pageid,
        A.impid as impid,
        A.devicetype as devicetype,
        A.detaileddevicetype as detaileddevicetype,
        A.overlay as overlay,
        A.wrapper as wrapper,

        B.type as type,
        B.video_type as video_type,
        B.category_id as category_id,
        B.category as category,
        B.vh_partner as vh_partner,
        B.not_vh_partner as not_vh_partner,
        if(C.dsp_name == 'direct',A.producttype,C.dsp_name) as dsp_name,

        A.hits_all as hits_all,
        A.hits_good as hits_good,
        A.hits_block_all as hits_block_all,
        A.hits_block_good as hits_block_good,

        A.winhits_all as winhits_all,
        A.winhits_good as winhits_good,
        A.winhits_block_all as winhits_block_all,
        A.winhits_block_good as winhits_block_good,
        
        A.shows_good as shows_good,
        A.shows_block_good as shows_block_good,
        
        A.partner_price as partner_price,
        A.price as price
    from
        $dsp_reduce as A
    inner join
        $page_imp as B
    on B.PageID == A.pageid and B.ImpID == A.impid
    inner join
        $dspid as C
    on A.dspid == C.DSPID
    where
        (B.video_type='in_app' and A.dspid=1 and A.producttype='auto-video-direct')
        or (B.video_type='in_app' and A.dspid!=1)
        or B.video_type!='in_app'
);

insert into `@output_table` with truncate
select * from $dsp_imp_join