pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";

$page_ids = (
    select aggregate_list(distinct PageID) as pageid from `//home/videolog/strm_meta/page_imp`
    where vh_partner != "not_vh"
);
$page_ids_i = ListMap($page_ids, ($x) -> {RETURN CAST($x as Int64)}) ?? AsList(CAST(-123 AS Int64));
$date_from = "@date_from";
$date_to = "@date_to";
$output_table = "@output_table";

$tmp = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[0] as fielddate,
        pageid,
        dspid,
        impid,
        Url::GetCGIParam("?" || queryargs, "354") as vcid,
        price,
        partnerprice
    from range(
        `cooked_logs/bs-dsp-cooked-log/1d`, $date_from, $date_to
    ) as cl
    where price > 0
    and ListHas($page_ids_i, pageid)
    and dspfraudbits == 0
    and dspeventflags == 0
    and countertype == 1
    and dspid not in (5, 10)
);

$grouped = (
    select
        fielddate,
        pageid,
        dspid,
        impid,
        vcid,
        sum(price) as price,
        sum(partnerprice) as partnerprice
    from $tmp
    group by
        fielddate,
        pageid,
        dspid,
        impid,
        vcid
);

$categories  = (
    select CAST(PageID as Int64) as pageid, CAST(ImpID as Int64) as impid, some(category) as category
    from `home/videolog/strm_meta/page_imp`
    group by PageID, ImpID
);

$view_types = (
    select
        JoinKey as vcid,
        heur_category as view_type
    from `//home/videolog/strm_meta/iron_branch/concat`
);

$money_by_cat_and_view_type = (
    select
        fielddate,
        m.pageid as pageid,
        m.impid as impid,
        category ?? "unknown" as category,
        view_type ?? "unknown" as view_type,
        price,
        partnerprice
    from $grouped as m
    left join $categories as c on (m.pageid == c.pageid and m.impid == c.impid)
    left join $view_types as v on (m.vcid == v.vcid)
);

$bad_pairs = (
    select 
        fielddate,
        pageid,
        impid,
        sum(price) as price,
        sum(partnerprice) as partnerprice
    from $money_by_cat_and_view_type
    where category == "unknown"
    group by fielddate, pageid, impid
);

$grouped2 = (
    select
        fielddate,
        category,
        view_type,
        sum(price) as price,
        sum(partnerprice) as partnerprice
    from $money_by_cat_and_view_type
    group by fielddate, category, view_type
);

$totalizer = ($stru) -> {
    RETURN AsList(
        $stru,
        AddMember(RemoveMember($stru, "category"), "category", "_total_"),
        AddMember(RemoveMember($stru, "view_type"), "view_type", "_total_"),
        ExpandStruct(
            RemoveMember(RemoveMember($stru, "category"), "view_type"),
            "_total_" as category, "_total_" as view_type
        )
    );
};

$totalized = (process $grouped2 using $totalizer(TableRow()));

$grouped3 = (
    select
        fielddate,
        category,
        view_type,
        sum(price) / 1000000.0 as price,
        sum(partnerprice) / 1000000.0 as partnerprice
    from $totalized
    group by fielddate, category, view_type
);

insert into $output_table WITH TRUNCATE 
select * from $grouped3;