pragma library('stability_common.sql');
import stability_common symbols $getPlatform, $getRefFrom, $refFromWrapper;

use hahn;
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

-- @[graph_info]


$from = "@[date_from]";
$to = "@[date]";

$data = select 
        vsid, 
        TableName() as fielddate,
        $getPlatform(service, userAgent) as platform,
        $refFromWrapper($getRefFrom(Yson::ParseJson(data))) as ref_from,
    from range("//logs/strm-gogol-log/1d", $from, $to)
    where 
        service == "StreamPlayer" and
        eventType == 'event' and
        eventName == "RecommendationSelect";


$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "platform"), "platform", "_total_"))
        )
    );
    RETURN $result
};

$totalized = process $data using $totalize(TableRow());

insert into `@[root]/@[date_from]-@[date]` WITH TRUNCATE 
select 
    fielddate,
    platform,
    ref_from,
    count(vsid) as hits
from $totalized
group by fielddate,
    platform,
    ref_from;
