use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma yt.Pool = "video_player_abt";
pragma DqEngine = "disable";


$re_kal = Re2::Capture("/(kal|stream)/([0-9A-Za-z-_]+?)/");
$re_vod = Re2::Capture("/([0-9A-Za-z-_]+?)-vod/");
$re_converted = Re2::Capture("/vh-([0-9A-Za-z-_]+?)-converted/");

$get_channel_old = ($request) -> {
    RETURN CASE
    WHEN String::Contains($request, "cdn1tvru") THEN "1tv"
    WHEN $re_converted($request)._1 is not null THEN $re_converted($request)._1
    WHEN $re_vod($request)._1 is not null THEN $re_vod($request)._1
    WHEN $re_kal($request)._2 is not null THEN "kal"
    WHEN $request like "%/fm/%" then "fm"
    WHEN $request like "/music/%" then "music"
    WHEN $request like "%.jpg%" THEN "jpg"
    ELSE NULL
    END
};

$toCheck = ($request) -> (
    (
        String::Contains($request, '.m3u8')
        and not String::Contains($request, '?chunks=1')
    )
    or String::Contains($request, '.mpd')
    or String::Contains($request, '.ismc')
    or (
        (  -- ad queries
            String::Contains($request, '.webm')
            or String::Contains($request, '.mp4')
        ) and $get_channel_old($request) in ("adfox", "bsvideo", "canvas")
    )
);


$format = DateTime::Format('%Y-%m-%d');
$date = NVL($format(CurrentUtcDate() - 1 * Interval('P1D')),'');
$table = "//logs/strm-access-log/1d/" || $date;

$tmp = (
    select 
        --Url::Decode(Url::GetCGIParam(referer, "stream_url")) as stream_url, 
        Url::GetCGIParam(request, "from") as labels_from, 
        CAST(abc_id as String) as abc_id,
        $get_channel_old(request) as stream_bucket,
        request  like "%ysign1=%" as is_signed
    from $table
    where $toCheck(request) and traffic_type = 'users'
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "labels_from"), "labels_from", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "stream_bucket"), "stream_bucket", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "abc_id"), "abc_id", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $tmp using $totalize(TableRow());

$grouped = (
    select
        $date as fielddate,
        stream_bucket,
        labels_from,
        abc_id,
        count(*) as playlists,
        count_if(is_signed) as signed_playlists
    from $totalized
    WHERE labels_from!='' and stream_bucket!='jpg'
    group by 
        CASE WHEN stream_bucket ?? "-" = '' THEN '-' ELSE stream_bucket ?? "-"  END as stream_bucket,
        labels_from ?? "-" as labels_from,
        abc_id ?? "-" as abc_id
);


upsert into stat.`Video/Others/Strm/KOAN-3509-signed-playlists/daily` erase by (fielddate)
select * from $grouped;
