use hahn;
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

-- @[graph_info]

insert into `@[root]/@[date]` WITH TRUNCATE 
select fielddate, event_name, count(distinct(vsid)) as vsids from (
select 
    TableName() as fielddate,
    eventName as event_name,
    vsid
from range("//logs/strm-gogol-log/1d", "@[date]", "@[date]")
where 
    eventName in (
        "CreatePlayer", "AdStart", "AdEnd", "Start",
        "10SecWatched", "20SecWatched", "30SecHeartbeat",
        "End", "RecommendationSelect"
    )
    and service = "StreamPlayer"
    and (
        find(location, "fromBlock=partner_pretty_player") is not null
        or find(location, "from_block=partner_pretty_player") is not null
        or find(location, "fromBlock%3Dpartner_pretty_player") is not null
        or find(location, "from_block%3Dpartner_pretty_player") is not null
    )
) group by fielddate, event_name;