use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common symbols $refFromWrapper, $getVideoContentId, $getPlatformExt, $getFielddate, $mockService, $stationMaxCrutch, $wrapZen, $processRefFromDetailed;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$VsidFatals = ToSet([
    "NO_CODECS",
    "NO_MSE",
    "UNABLE_TO_LOAD_PLAYER_IFRAME",
    "ON_PLAYER_INIT_ERROR",
    "UNABLE_TO_LOAD_PLAYER_INTERNAL_SCRIPT",
    "PLAYER_CONTAINER_NOT_FOUND",
    "InvalidConfigElementInCreatePlayer",
    "InvalidConfigInCreatePlayer"
]);

$getErrors = ($errors, $threshold) -> {
    $errors = ListFilter(
        Yson::ConvertToList($errors), ($x)->(Yson::LookupString($x, "id") like "%_fatal")
    );
    -- $result = AsList(AsStruct(
    --     "Start" as eventName
    -- ));
    $errors = ListMap(
        $errors, ($x)->(
            AsStruct(
                Yson::LookupString($x, "id_raw") as eventName,
                Yson::LookupInt64($x, "rel_time") > $threshold as after_last_hb,
                Yson::ConvertToString(Yson::YPath($x, "/details/error_category")) ?? "_total_" as error_category
            )
        )
    );
    $vf = ListLength(ListFilter($errors, ($x)->($x.eventName in $VsidFatals))) ?? 0;
    $nonvf = ListLength(ListFilter($errors, ($x)->($x.eventName not in $VsidFatals))) ?? 0;
    $errors = ListFilter($errors, ($x)->(length($x.eventName) <= 200));
    RETURN AsTuple(
        $errors, $vf, $nonvf
    )
};

$getSS = ($pe) -> (
    ListLength(ListFilter(Yson::ConvertToList($pe), ($x)->(Yson::LookupString($x, "id_raw") == "SetSource"))) ?? 0
);

$source = (
    select
        fielddate,
        vsid,
        $processRefFromDetailed(ref_from, user_agent, ref_from_block, stream_block) as ref_from,
        $getPlatformExt(gogol_service ?? $mockService(ref_from), user_agent, vsid) as platform,
        IF(sources_aggr like "%create_player%", 1, 0) + $getSS(player_events) as cp_ss,
        view_time,
        view_type ?? "unknown" as view_type,
        player_version ?? "unknown" as player_version,
        $getErrors(errors, view_time).0 as errors,
        $getErrors(errors, view_time).1 as vsid_fatals,
        $getErrors(errors, view_time).2 as non_vsid_fatals,
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    ) with columns Struct<gogol_service:String?>
    where vsid not like 'rtbdsp%' and $refFromWrapper(ref_from) != ""
);

$totalize = ($row) -> {
    $rf = ListExtend($row.ref_from, ["_total_"]);
    $result = ListMap($rf, ($x)->(AddMember(RemoveMember($row, "ref_from"), "ref_from", $x)));
    $add = ListFlatMap(
        $result, ($x)->(ListNotNull([
            AddMember(RemoveMember($x, "platform"), "platform", "_total_"),
            IF($x.platform like "StreamPlayer%", AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer_total")),
            IF($x.platform like "AndroidPlayer%", AddMember(RemoveMember($x, "platform"), "platform", "AndroidPlayer_total")),
        ]))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "player_version"), "player_version", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "view_type"), "view_type", "_total_")));
    $result = ListUnionAll($result, $add);
    RETURN $result
};

$totalize_ec = ($row) -> {
    $result = AsList($row);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "error_category"), "error_category", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListNotNull(ListMap(
        $result, ($x)->(IF(
            $x.error_name != "Start",
            AddMember(RemoveMember($x, "error_name"), "error_name", "_total_"),
            NULL
        ))
    ));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $source using $totalize(TableRow());

$flattened = (
    select
        errors.eventName as error_name,
        errors.after_last_hb as after_last_hb,
        errors.error_category as error_category,
        t.* without t.errors
    from $totalized as t
    flatten list by errors
);

$totalized2 = process $flattened using $totalize_ec(TableRow());

$for_kpi_grouped = (
    select
        fielddate,
        platform,
        ref_from,
        player_version,
        view_type,
        sum(view_time) as tvt,
        CountDistinctEstimate(vsid) ?? 0 as total_vsids,
        (CountDistinctEstimate(IF(vsid_fatals > 0, vsid)) ?? 0) / CAST(CountDistinctEstimate(vsid) ?? 0 as Double) as kpi1,
        (SUM_IF(non_vsid_fatals, vsid_fatals == 0) ?? 0) / (CAST(SUM_IF(cp_ss, vsid_fatals == 0) as Double) ?? 0) as kpi2
    from $totalized
    group by fielddate,
        platform,
        ref_from,
        player_version,
        view_type
);

$errors_grouped = (
    select
        fielddate,
        platform,
        ref_from,
        player_version,
        view_type,
        error_name,
        error_category,
        count(*) as total_errors,
        count_if(view_time == 0) as total_errors_zero_tvt,
        count_if(after_last_hb) as errors_after_last_hb,
        CountDistinctEstimate(vsid) ?? 0 as vsids_with_error,
        CountDistinctEstimate(IF(after_last_hb, vsid, null)) ?? 0 as vsids_with_error_after_last_hb,
    from $totalized2
    group by fielddate,
        platform,
        ref_from,
        player_version,
        view_type,
        error_name,
        error_category
);

$nwrap = ($k) -> (IF(cast($k as String) in ("-inf", "inf", "nan"), null, $k));

$joined = (
    select
        s.*,
        tvt,
        total_vsids,
        $nwrap(kpi1) as kpi1,
        $nwrap(kpi2) as kpi2
    from $errors_grouped as s
    left join any $for_kpi_grouped as fk on (
        s.fielddate == fk.fielddate and
        s.platform == fk.platform and
        s.ref_from == fk.ref_from and
        s.player_version == fk.player_version and
        s.view_type == fk.view_type
    )
);

insert into $output_table WITH TRUNCATE
select * from $joined
where (total_errors >= 100 or ref_from == "ru.yandex.quasar.app_Yandexstation_2");
