use hahn;
pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma yt.MaxRowWeight = "32M";

$date_from = "@date_from";
$date_to = "@date_to";
$tmp_table = "@tmp_table";
$output_table = "@output_table";
$output_table_browser = "@[output_table_browser]";

$re_RefFrom = Re2::Capture("from(=|%3D|%253D)([a-z_\-]+)");

-- @ref_from_preprocess

$getRefFrom = ($x) -> {
    RETURN $re_RefFrom($x)._2
};

$getRefFromStrict = ($loc, $toploc, $ref, $topref) -> {
    RETURN $ref_from_preprocess($getRefFrom($loc) ?? $getRefFrom($toploc) ?? $getRefFrom($ref) ?? $getRefFrom($topref))
};

$countDelta = ($canplay, $se) -> {
    $filtered = ListFilter(
        $se,
        ($x) -> {RETURN $x.EventName in ("CreatePlayer", "SetSource") and $x.ClientTimestamp < $canplay.ClientTimestamp}
    );
    RETURN IF(
        ListLength($filtered) > 0,
        AsStruct(
            $canplay.ClientTimestamp - $filtered[0].ClientTimestamp as value,
            $canplay.quality as quality,
            $filtered[0].EventName || "_CanPlay" as delta
        ),
        NULL
    )
};

$getMetrics = ($row) -> {
    $se = ListReverse($row.sorted_events);
    $canplays = ListFilter($se, ($x) -> {RETURN $x.EventName == "CanPlay"});
    $deltas = ListFlatMap(
        $canplays,
        ($x) -> {RETURN $countDelta($x, $se)}
    );
    RETURN ListMap(
        $deltas,
        ($x) -> {RETURN ExpandStruct(
            $x,
            $row.vsid as vsid,
            $row.x64 as x64,
            ListFilter($se, ($x) -> {RETURN $x.videoType is not null})[0].videoType ?? "UNKNOWN" as videoType,
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.browser_name as browser_name,
            $row.player_version as player_version,
            $row.fielddate as fielddate
        )}
    )
};

$getVideoType = ($Data) -> {
    RETURN Yson::ConvertToString(Yson::YPath(Yson::ParseJson($Data), "/labels/videoType"))
};

$getQuality = ($Data) -> {
    RETURN CAST(
        Yson::ConvertToInt64(Yson::YPath(Yson::ParseJson($Data), "/data/playerState/controller/videoHeight"))
        as String
    )
};

$getBrowserName = ($user_agent) -> {
    RETURN CASE
    WHEN FIND($user_agent, "YandexStation") IS NOT NULL OR FIND($user_agent, "Yandex Station") IS NOT NULL THEN "YandexStation"
    ELSE UserAgent::Parse($user_agent).BrowserName ?? "Unknown"
    END
};

$tmp = (
    select
        fielddate,
        VSID as vsid,
        UserAgent::Parse(MAX(UserAgent)).OSFamily ?? "Unknown" as os_family,
        $getBrowserName(MAX(UserAgent)) as browser_name,
        UserAgent::Parse(MAX(UserAgent)).x64 as x64,
        ListSort(AGGREGATE_LIST(AsStruct(
            EventName as EventName,
            ClientTimestamp as ClientTimestamp,
            $getVideoType(Data) as videoType,
            $getQuality(Data) as quality
        )), ($x) -> {RETURN $x.ClientTimestamp}) as sorted_events,
        MAX(Version) as player_version,
        MAX(UserAgent) as UserAgent,
        MAX($getRefFromStrict(Location, TopLocation, Referrer, TopReferrer)) as ref_from_strict
    from range(
        `logs/jstracer-log/1d`, $date_from, $date_to
    )
    where Service in ("StreamPlayer", "AndroidPlayer", "ott-smart")
    and EventName in ("CreatePlayer", "LoadStartHavingCurrentData", "CanPlay", "SetSource")
    group by VSID, ListReverse(String::SplitToList(TablePath(), "/"))[0] as fielddate
);

$getRefFrom = ($rflist) -> {
    $rflist = ListFilter($rflist, ($x) -> {RETURN $x.ref_from != "-"});
    $goodvcids = ListFilter($rflist, ($x) -> {RETURN $x.video_content_id != "novcid"});
    RETURN CASE
    WHEN ListLength($goodvcids) > 0 THEN $goodvcids[listlength($goodvcids) - 1].ref_from
    WHEN ListLength($rflist) > 0 THEN $rflist[listlength($rflist) - 1].ref_from
    ELSE "-"
    END
};

$ref_froms = (
    select
        vsid,
        fielddate,
        $getRefFrom(listsort(aggregate_list_distinct(asstruct(
            ref_from as ref_from,
            video_content_id as video_content_id,
            `timestamp` as ts
        )), ($x) -> {RETURN $x.ts})) as ref_from
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    group by
        vsid,
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate
);

$tmp_plus_ref_froms = (
    select t.*, ref_from ?? "unknown" as ref_from
    from $tmp as t
    left join $ref_froms as r using (vsid, fielddate)
);


$deltaized = (process $tmp_plus_ref_froms using $getMetrics(TableRow()));

$deltas = (
    SELECT
        vsid,
        AGGREGATE_LIST(
            asstruct(delta as delta, value as value)
        ) as deltas_list
    from $deltaized
    group by vsid
);

$joined = (
    select 
        t.*,
        deltas_list
    from $tmp_plus_ref_froms as t
    left join $deltas as d using (vsid)
);

insert into $tmp_table WITH TRUNCATE 
select * from $joined;

$totalize = ($row) -> {
    $row = RemoveMember($row, "vsid");
    $row = RemoveMember($row, "x64");
    $row = RemoveMember($row, "quality");
    $totaled = ExpandStruct(
        RemoveMember(
            RemoveMember(
                RemoveMember(
                    RemoveMember(
                        RemoveMember($row, "player_version"), "videoType"
                    ),
                    "ref_from",
                ),
                "os_family",
            ), "browser_name"
        ),
        "_total_" as player_version,
        "_total_" as videoType,
        "_total_" as ref_from,
        "_total_" as os_family,
        "_total_" as browser_name
    );
    $result = AsList(
        $row,
        $totaled,
        AddMember(
            RemoveMember($totaled, "player_version"),
            "player_version", $row.player_version
        ),
        AddMember(
            RemoveMember($totaled, "videoType"),
            "videoType", $row.videoType
        ),
        AddMember(
            RemoveMember($totaled, "ref_from"),
            "ref_from", $row.ref_from
        ),
        AddMember(
            RemoveMember($totaled, "os_family"),
            "os_family", $row.os_family
        ),
        AddMember(
            RemoveMember($totaled, "browser_name"),
            "browser_name", $row.browser_name
        ),
        ExpandStruct(
            RemoveMember(
                RemoveMember(
                    RemoveMember($totaled, "ref_from"),
                    "player_version"
                ),
                "os_family"
            ),
            $row.ref_from as ref_from,
            $row.player_version as player_version,
            $row.os_family as os_family
        ),
        ExpandStruct(
            RemoveMember(
                RemoveMember($totaled, "ref_from"),
                "os_family"
            ),
            $row.ref_from as ref_from,
            $row.os_family as os_family
        ),
        ExpandStruct(
            RemoveMember(
                RemoveMember(
                    RemoveMember($totaled, "ref_from"),
                    "browser_name"
                ),
                "os_family"
            ),
            $row.ref_from as ref_from,
            $row.browser_name as browser_name,
            $row.os_family as os_family
        )
    );
    $expand = ListMap(
        ListFilter($result, ($x) -> {RETURN $x.ref_from in ("morda", "videohub", "efir", "streamhandler_other")}),
        ($x) -> {RETURN AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир")}
    );
    $result = ListUnionAll($result, $expand);
    $expand = ListMap(
        ListFilter($result, ($x) -> {RETURN $x.ref_from in ("morda_touch", "videohub_touch", "efir_touch", "streamhandler_appsearch")}),
        ($x) -> {RETURN AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир-тач")}
    );
    $result = ListUnionAll($result, $expand);
    RETURN $result
};

$totalized = (process $deltaized using $totalize(TableRow()));

$reduced = (
    select
        fielddate,
        os_family,
        browser_name,
        player_version as player_version,
        ref_from as ref_from,
        videoType as video_type,
        delta,
        percentile(value, 0.50) as p50,
        percentile(value, 0.60) as p60,
        percentile(value, 0.70) as p70,
        percentile(value, 0.80) as p80,
        percentile(value, 0.90) as p90,
        percentile(value, 0.95) as p95,
        percentile(value, 0.97) as p97,
        percentile(value, 0.99) as p99,
        count(*) as `count`
    from $totalized
    where player_version is not null
    and ref_from is not null
    and videoType is not null
    group by fielddate, delta, player_version, ref_from, videoType, os_family, browser_name
);

$addPercentiles = ($row) -> {
    $new = AsStruct(
        $row.fielddate as fielddate,
        $row.player_version as player_version,
        $row.ref_from as ref_from,
        $row.os_family as os_family,
        $row.browser_name as browser_name,
        $row.video_type as video_type,
        $row.delta as delta,
        $row.`count` as `count`
    );
    RETURN AsList(
        ExpandStruct(
            $new,
            "0.50" as quantile,
            $row.p50 as value
        ),
        ExpandStruct(
            $new,
            "0.60" as quantile,
            $row.p60 as value
        ),
        ExpandStruct(
            $new,
            "0.70" as quantile,
            $row.p70 as value
        ),
        ExpandStruct(
            $new,
            "0.80" as quantile,
            $row.p80 as value
        ),
        ExpandStruct(
            $new,
            "0.90" as quantile,
            $row.p90 as value
        ),
        ExpandStruct(
            $new,
            "0.95" as quantile,
            $row.p95 as value
        ),
        ExpandStruct(
            $new,
            "0.97" as quantile,
            $row.p97 as value
        ),
        ExpandStruct(
            $new,
            "0.99" as quantile,
            $row.p99 as value
        )
    )
};

insert into $output_table WITH TRUNCATE
select * from (process $reduced using $addPercentiles(TableRow()));

$getVersion = ($user_agent) -> {
    $version = Re2::Capture("Chrome/([0-9\.]+)")($user_agent)._1;
    $split = String::SplitToList($version, ".");
    RETURN String::JoinFromList(ListTake($split, 3), ".")
};

$tmp_browser = (
    select
        fielddate,
        deltas_list.value as value,
        browser_name,
        $getVersion(UserAgent) as browser_version,
        UserAgent::Parse(UserAgent).OSVersion as os_version,
        CAST(UserAgent::Parse(UserAgent).x64 as String) as x64
    from $joined
    flatten list by deltas_list
    where os_family == "Windows"
    and browser_name in ("Chrome", "YandexBrowser")
    and deltas_list.delta == "SetSource_CanPlay"
    and $getVersion(UserAgent) is not null
);

$totalize_browser = ($row) -> {
    $result = AsList($row);
    $extend = ListFlatMap($result, ($x) -> {RETURN IF(
        $x.x64 != "_total_", AddMember(RemoveMember($x, "x64"), "x64", "_total_"), NULL
    )});
    $result = ListUnionAll($result, $extend);
    $extend = ListFlatMap($result, ($x) -> {RETURN IF(
        $x.browser_version != "_total_", AddMember(RemoveMember($x, "browser_version"), "browser_version", "_total_"), NULL
    )});
    $result = ListUnionAll($result, $extend);
    $extend = ListFlatMap($result, ($x) -> {RETURN IF(
        $x.os_version != "_total_", AddMember(RemoveMember($x, "os_version"), "os_version", "_total_"), NULL
    )});
    $result = ListUnionAll($result, $extend);
    RETURN $result
};

$totalized_browser = (process $tmp_browser using $totalize_browser(TableRow()));

$grouped_browser = (
    select
        fielddate, browser_name, browser_version, os_version, x64,
        count(*) as `count`,
        percentile(value, 0.01) as p01,
        percentile(value, 0.1) as p10,
        percentile(value, 0.25) as p25,
        percentile(value, 0.5) as p50,
        percentile(value, 0.75) as p75,
        percentile(value, 0.9) as p90,
        percentile(value, 0.99) as p99,
    from $totalized_browser
    group by fielddate, browser_name, browser_version, os_version, x64
);

insert into $output_table_browser WITH TRUNCATE
select * from $grouped_browser where `count` >= 1000;