use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common symbols $refFromWrapper, $getPlatform, $mockService;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$tmp_table = "@[tmp_table]";
$output_table = "@[output_table]";


$re_kal = Re2::Capture("/(kal|stream)/([0-9A-Za-z-_]+?)/");
$re_fm = Re2::Capture("/fm/([0-9A-Za-z-_]+?)/");
$re_vod = Re2::Capture("/([0-9A-Za-z-_]+?)-vod/");
$re_converted = Re2::Capture("/vh-([0-9A-Za-z-_]+?)-converted/");
$ad_buckets = ["bsvideo", "canvas", "adfox"];

$get_channel_old = ($request) -> {
    $channel_old = CASE
    WHEN String::Contains($request, "cdn1tvru") THEN "1tv"
    WHEN $re_converted($request)._1 is not null THEN $re_converted($request)._1
    WHEN $re_vod($request)._1 is not null THEN $re_vod($request)._1
    WHEN $re_kal($request)._2 is not null and $re_kal($request)._2 like 'fm_%' THEN "fm"
    WHEN $re_kal($request)._2 is not null and $re_kal($request)._2 like '%weather%' then "kal_weather"
    WHEN $re_kal($request)._2 is not null THEN "kal_" || $re_kal($request)._2
    WHEN $re_fm($request)._1 is not null THEN "fm"
    ELSE NULL
    END;
    $channel_old = String::ToLower($channel_old);
    $channel_old = String::ReplaceAll($channel_old, "_supres", "");
    RETURN $channel_old
};

$invalid_ref_from = Pire::Grep("[^a-zA-Z0-9\-_\.]");

$refFromWrapper = ($ref_from) -> {
    RETURN CASE
    WHEN FIND($ref_from, "zen") IS NOT NULL THEN "Zen"
    WHEN $ref_from in ("efir", "efir_touch", "videohub", "videohub_touch") THEN "Эфир"
    WHEN $ref_from in ("yavideo", "ottwidget_ya-video", "ottwidget_yavideo") THEN "ЯВидео"
    WHEN $ref_from in ("serp", "ottwidget_ya-serp") THEN "Поиск"
    WHEN $ref_from in ("ya-weather", "weather_desktop", "weather_turbo") THEN "Погода"
    WHEN $ref_from in ("yanews", "yanewstragic") THEN "Новости"
    WHEN $ref_from in ("ottwidget_kp", "ottwidget_ott-kp", "ru.kinopoisk") THEN "Кинопоиск"
    WHEN Length($ref_from) > 64 THEN "weird"
    WHEN $invalid_ref_from($ref_from) THEN "weird"
    WHEN $ref_from is null or LENGTH($ref_from) == 0 then "weird"
    ELSE $ref_from
    END
};

$fielddateFormat = DateTime::Format("%Y-%m-%d %H:%M:%S");
$roundTs = ($timestamp) -> {
    $timestamp = CAST($timestamp as Uint64);
    $rounded = CAST($timestamp - ($timestamp % 300) as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($rounded), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

$getVsid = ($request) -> {
    $vsid = Url::GetCGIParam("http://example.com" || $request, "vsid");
    RETURN IF(
        length($vsid) in (64, 62) and $vsid != "0000000000000000000000000000000000000000000000000000000000000000",
        $vsid,
        null
    )
};

$countTVT = ($t30, $t20, $t10)->(
    case
    when $t30 is not null then $t30 * 30.0
    when $t20 is not null then 20.0
    when $t10 is not null then 10.0
    else 0.0
    end
);

$yandex_as = AsList();

$vhost_type = ($vhost, $source_uri, $remote_addr) -> {
    RETURN CASE
    WHEN $vhost like 'ext-strm-cogent%' or $vhost like 'ext-strm-level3%' or $vhost like 'ext-strm-telia%' or $vhost like 'strm-kiv%' or $vhost like 'strm-rad%' THEN "kiv-rad paid"
    WHEN $vhost like 'ext-strm-marrt%' or $vhost like 'ext-strm-mskrt%' THEN "rt paid"
    WHEN $vhost like 'ext-strm-%' THEN "isp IP"
    WHEN $vhost like 'strm.yandex.ru%' or $vhost like 'strm.yandex.net%' or $vhost like 'media.strm.yandex.net%' THEN "anycast" -- иногда добавляется порт :443
    WHEN $source_uri like '%@strm-%' THEN "yandex IP"
    WHEN $vhost in ('src_common_9090', 'vod_src_common', 'src_common') AND Geo::IsYandex($remote_addr)  THEN "swap-internal"
    WHEN $vhost in ('src_common_9090', 'vod_src_common', 'src_common') THEN "swap-external"
    ELSE "other"
    END
};


$tmp = (
    select
        $roundTs(`timestamp`) as fielddate,
        $get_channel_old(request) ?? "bucket" as bucket,
        $getVsid(request) as vsid,
        -- $vhost_type(vhost, source_uri, remote_addr) as vhost_type,
        remote_addr,
        bytes_sent,
    from range(
        `logs/strm-access-log/1d`, $date_from, $date_to
    )
    where status in ("200", "206")
    and remote_addr not in ('127.0.0.1', '::1')
    and not (
        Geo::IsYandex(remote_addr) and vhost like '[2a02:6b8:%'
    )
    and vhost != 'xaccelredirect.strm.yandex.net'
    and vhost != 'xaccelredirect'
    and vhost not like 'production-xaccelredirect%'
    and vhost != 'trns-manager.strm.yandex.net'
    and vhost not like 'trns%.strm.yandex.net%'
    and vhost not like 'trns-strm%'
    and vhost not like 'tumbler%.strm.yandex.net'
    and vhost not like '%.tst.strm.yandex.net'
    and vhost not like 'mgr%.strm.yandex.net'
    and vhost not like 'playlist-cache%'
    and $vhost_type(vhost, source_uri, remote_addr) not like '%swap%'
);

$tmp_gogol = (
    select
        fielddate,
        vsid,
        MAX(ref_from) as ref_from,
        bucket,
        $countTVT(
            count_if(eventName == "30SecHeartbeat"),
            count_if(eventName == "20SecWatched"),
            count_if(eventName == "20SecWatched")
        ) as tvt,
    from (
        select
            $roundTs(`timestamp`) as fielddate,
            vsid,
            Url::GetCGIParam(streamUrl, "from") as ref_from,
            $get_channel_old(streamUrl) ?? "bucket" as bucket,
            eventName
        from range(
            `logs/strm-gogol-log/1d`, $date_from, $date_to
        )
        where eventName in ("10SecWatched", "20SecWatched", "30SecHeartbeat")
        and vsid is not null and length(vsid) != 0
    )
    group by fielddate, vsid, bucket
        
);

$vsid_to_ref_from = (
    select
        fielddate,
        vsid,
        MAX(ref_from) as ref_from
    from $tmp_gogol
    group by fielddate, vsid
);

$grouped = (
    select
        fielddate,
        vsid,
        bucket,
        sum(bytes_sent) as bytes_sent
    from $tmp
    group by
        fielddate,
        vsid,
        bucket
);

$joined = (
    select g.*, tvt ?? 0.0 as tvt, v.ref_from as ref_from
    from $grouped as g
    left join $tmp_gogol as gog on (
        g.fielddate == gog.fielddate
        and g.vsid == gog.vsid
        and g.bucket == gog.bucket
    )
    left join $vsid_to_ref_from as v on (
        g.vsid == v.vsid and g.fielddate == v.fielddate
    )
);

insert into $tmp_table with truncate
select * from $joined;

$grouped2 = (
    select
        fielddate,
        IF(ref_from is null, "no_vsid", $refFromWrapper(ref_from)) as ref_from,
        bucket ?? "bucket" as bucket,
        sum(bytes_sent) / Math::Pow(1024, 3) as gbytes_sent,
        sum(tvt) as tvt
        -- (sum(svod_bytes_sent) / Math::Pow(1000, 3)) * 8.0 as svod_gbit,
        -- ((sum(bytes_sent) - sum(svod_bytes_sent)) / Math::Pow(1000, 3)) * 8.0 as avod_gbit,
    from $joined
    group by fielddate,
        ref_from,
        bucket
);

$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll($result, ListMap(
        $result, ($x) -> {
            RETURN AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")
        }
    ));
    $result = ListUnionAll($result, ListFlatMap(
        $result, ($x) -> {
            RETURN CASE
            WHEN $x.bucket like 'kal%' THEN AsList(
                AddMember(RemoveMember($x, "bucket"), "bucket", "_kal_"),
                AddMember(RemoveMember($x, "bucket"), "bucket", "_total_")
            )
            ELSE AsList(AddMember(RemoveMember($x, "bucket"), "bucket", "_total_"))
            END
        }
    ));
    RETURN $result
};

$totalized = process $grouped2 using $totalize(TableRow());

$grouped2a = (
    select
        fielddate,
        ref_from,
        bucket,
        sum(gbytes_sent) as gbytes_sent,
        sum(tvt) as tvt
    from $totalized
    group by fielddate,
        ref_from,
        bucket
);

insert into $output_table WITH TRUNCATE 
select * from $grouped2a;
