use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common symbols $refFromWrapper, $getPlatform, $mockService;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";


$wrapProgram = ($x)->(IF($x == "" or $x is null, "-", $x));


$source = (
    select
        fielddate,
        $wrapProgram(program) as program,
        $refFromWrapper(ref_from ?? "-") as ref_from,
        license ?? "-" as content_license,
        device_type ?? "other" as platform,
        view_time,
        yandexuid ?? puid as user_id,
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where (
        ref_from in ("ru.kinopoisk", "ottwidget_ott-kp")
        or ref_from like "ott-smart-%"
    )
);

$top20_programs = (
    select fielddate, top_by(program, `count`, 20) as top_programs
    from (
        select program, fielddate, count(*) as `count`
        from $source
        group by program, fielddate
    )
    group by fielddate
);

$filter_programs = (
    select
        IF(s.program in t.top_programs, s.program, "other") as program,
        s.* without s.program
    from $source as s
    inner join $top20_programs as t using (fielddate)
);


$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll(
        $result, ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "content_license"), "content_license", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result, ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "platform"), "platform", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result, ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "program"), "program", "_total_"))
        )
    );
    return $result
};

$totalized = process $filter_programs using $totalize(TableRow());

$grouped = (
    select
        fielddate,
        content_license,
        platform,
        program,
        sum(view_time) as tvt,
        CountDistinctEstimate(user_id) as users
    from $totalized
    group by fielddate,
        content_license,
        platform,
        program
);

insert into $output_table WITH TRUNCATE
select * from $grouped;
