use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common symbols $refFromWrapper, $getVideoContentId, $getPlatform, $getFielddate, $mockService;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$dedup_stalleds = ($list) -> {
    RETURN ListFlatMap(
        ListEnumerate($list), ($pair) -> {
            $index = $pair.0;
            $object = $pair.1;
            RETURN CASE
            WHEN $object.duration == 0 and $list[$index + 1].duration == 1 THEN NULL
            WHEN $object.duration == 1 and $list[$index + 1].duration == 5 THEN NULL
            WHEN $object.duration == 5 and $list[$index + 1].duration == 10 THEN NULL
            ELSE $object
            END
        }
    )
};

$getStalleds = ($errors) -> {
    $stalleds = ListFilter(
        Yson::ConvertToList($errors), ($x)->(Yson::LookupString($x, "id_raw") == "Stalled")
    );
    $result = AsList(AsStruct(
        "Start" as reason,
        0 as duration
    ));
    $stalleds = ListMap(
        $stalleds, ($x)->(
            AsStruct(
                Yson::ConvertToString(Yson::YPath($x, "/details/reason")) as reason,
                Yson::ConvertToDouble(Yson::YPath($x, "/details/stalledDuration")) ?? Yson::ConvertToInt64(Yson::YPath($x, "/details/stalledDuration")) as duration,
            )
        )
    );
    $stalleds = $dedup_stalleds($stalleds);
    RETURN ListUnionAll($result, $stalleds)
};

$wrap = ($x)->(IF($x == "" or $x is null, "unknown", $x));

$source = (
    select
        fielddate,
        vsid,
        $getPlatform($mockService(ref_from), user_agent) as platform,
        $wrap(provider) as provider,
        Geo::RoundRegionById(CAST(region as Int32), "region").name as region,
        view_time,
        $getStalleds(errors) as stalleds
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where vsid not like 'rtbdsp%' and (
        ref_from in ("ru.kinopoisk", "ottwidget_ott-kp")
        or ref_from like "ott-smart-%"
    ) and country == "RU"
);

$flattened = (
    select
        stalleds.duration as stalled_duration,
        stalleds.reason as stalled_reason,
        t.* without t.stalleds
    from $source as t
    flatten list by stalleds
    where platform != ""
);

$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll(
        $result, ListMap(
            $result,
            ($x)->(AddMember(RemoveMember($x, "platform"), "platform", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result, ListMap(
            $result,
            ($x)->(AddMember(RemoveMember($x, "provider"), "provider", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result, ListMap(
            $result,
            ($x)->(AddMember(RemoveMember($x, "region"), "region", "_total_"))
        )
    );
    $add = ListFlatMap(
        $result, ($x)->(IF(
            $x.stalled_reason != "Start",
            AddMember(RemoveMember($x, "stalled_reason"), "stalled_reason", "_total_"),
            NULL
        ))
    );
    $result = ListUnionAll($result, $add);
    RETURN $result
};

$totalized = process $flattened using $totalize(TableRow());

$starts = (select * from $totalized where stalled_reason == "Start");
$stalleds = (select * from $totalized where stalled_reason != "Start");

$starts_grouped = (
    select
        fielddate,
        platform,
        provider,
        region,
        sum(view_time) as tvt,
        CountDistinctEstimate(vsid) as total_vsids
    from $starts
    group by fielddate,
        platform,
        provider,
        region
);

$stalleds_grouped = (
    select
        fielddate,
        platform,
        provider,
        region,
        stalled_reason,
        count(*) as total_stalleds,
        CountDistinctEstimate(vsid) as stalled_vsids,
        sum(stalled_duration) as total_stalled_duration,
        avg(stalled_duration) as avg_stalled_duration,
        percentile(stalled_duration, 0.5) as stalled_duration_p50,
        percentile(stalled_duration, 0.75) as stalled_duration_p75,
        percentile(stalled_duration, 0.90) as stalled_duration_p90,
        percentile(stalled_duration, 0.95) as stalled_duration_p95
    from $stalleds
    group by fielddate,
        platform,
        provider,
        region,
        stalled_reason
);

$joined = (
    select
        s.*,
        tvt,
        total_vsids
    from $stalleds_grouped as s
    left join any $starts_grouped as st using(
        fielddate,
        platform,
        provider,
        region
    )
);

insert into $output_table WITH TRUNCATE
select * from $joined;
