#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import requests
import yt.wrapper as yt

OUTPUT_TABLE_SCHEMA = [
    {"name": "abc_id", "type": "uint64"},
    {"name": "name", "type": "string"},
]

def main():

    rows = []
    session = requests.session()
    session.cookies.set("Session_id", os.environ["SESSION_ID"], domain="yandex-team.ru")
    req = session.get(
        "https://abc-back.yandex-team.ru/api/v4/services/?fields=id,slug,name"
    ).json()
    for res in req["results"]:
        rows.append(dict(name=res["name"]["ru"], abc_id=res["id"]))
    while req.get("next"):
        req = session.get(req["next"]).json()
        for res in req["results"]:
            rows.append(dict(name=res["name"]["ru"], abc_id=res["id"]))
    import pdb; pdb.set_trace()
    yt.write_table(yt.TablePath("//home/videoquality/strm_meta/abc_services", schema=OUTPUT_TABLE_SCHEMA), rows)


if __name__ == "__main__":
    main()
