use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma DqEngine = "disable";
pragma library("common.sql");
IMPORT common SYMBOLS $strmGetVsid;

$access_table = "//logs/strm-access-log/1d/" || $date;
$gogol_table = "//logs/strm-gogol-log/1d/" || $date;

$access_map = (
    SELECT 
        abc_id,
        $strmGetVsid(request, referer) as vsid,
        UserAgent::Parse(user_agent).OSFamily as os_family,
        cast(bytes_sent as UInt64) as bytes_sent,
    from $access_table
    where
        traffic_type='users'
        and abc_id is not null
);



$access_reduce_vsid = (
    select
        abc_id,
        vsid,
        max(os_family) as os_family,
        sum(bytes_sent) as bytes_sent
    from $access_map
    where vsid is not null
    group by abc_id, vsid
);

$access_reduce_no_vsid = (
    select
        abc_id,
        os_family,
        sum(bytes_sent) as bytes_sent
    from $access_map
    where vsid is null
    group by abc_id, os_family
);

$gogol_reduce = (
    select
        vsid,
        some(service) as service,
        some(labels_from) as labels_from,
        some(additionalParameters_stream_block) as stream_block,
        some(additionalParameters_from_block) as from_block,
    from $gogol_table
    where vsid is not null
    group by vsid
);

$join_all = (
    select
        v.*, labels_from, stream_block, from_block
    from $access_reduce_vsid as v
    left join any $gogol_reduce as g using (vsid)
);

$after_join = (
    select s.*, services.name ?? ("Unknown_Service_" || (cast(s.abc_id as String) ?? "-")) as abc_service
    from (
        select * from $join_all
        union all
        select * from $access_reduce_no_vsid
    ) as s
    left join any `//home/videoquality/strm_meta/abc_services` as services on (s.abc_id = services.abc_id)
);

$map = (
    select
        $date as fielddate,
        abc_service,
        os_family ?? "-" as os_family,
        unwrap(case
        when labels_from is not null then labels_from
        when vsid is not null then "with_vsid_" || (os_family ?? "-")
        when vsid is null then "no_vsid_" || (os_family ?? "-")
        else "-"
        end) as labels_from,
        from_block ?? "-" as from_block,
        stream_block ?? "-" as stream_block,
        bytes_sent
    from $after_join
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "abc_service"), "abc_service", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "os_family"), "os_family", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "labels_from"), "labels_from", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "from_block"), "from_block", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "stream_block"), "stream_block", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $map using $totalize(TableRow());

$to_tb = ($b) -> (Math::Round(cast($b as Double) / Math::Pow(1024, 4), -2));
$w = ($x) -> (IF($x = "", null, $x));

$grouped = (
    select
        fielddate,
        abc_service,
        os_family,
        labels_from,
        from_block,
        stream_block,
        $to_tb(sum(bytes_sent)) as tib
    from $totalized
    group by
        $w(fielddate) ?? "-" as fielddate,
        $w(abc_service) ?? "-" as abc_service,
        $w(os_family) ?? "-" as os_family,
        $w(labels_from) ?? "-" as labels_from,
        $w(from_block) ?? "-" as from_block,
        $w(stream_block) ?? "-" as stream_block
);

upsert into stat.`Video/Others/Strm/Stability/BilledTrafficReport/daily` erase by (fielddate)
select * from $grouped;
