use hahn;
pragma library("stability_common.sql");
pragma yt.Pool = "@[pool]";
import stability_common symbols $remappedWrapRefFrom, $getStalleds, $mskDateFromTs;

$iron_branch = "//home/videolog/strm_meta/iron_branch/concat";

$date_from = "@[date_from]";
$date_to = "@[date_to]";

$tmp = (
    select
        fielddate,
        `UUID`,
        program,
        view_type,
        price,
        view_time,
        puid ?? device_id ?? yandexuid as user_id,
        ListSum(ListMap($getStalleds(errors), ($x)->($x.duration))) as stalled_duration,
        $remappedWrapRefFrom(ref_from) as service,
    from range(`cubes/video-strm`, $date_from, $date_to, `sessions`)
    where view_time > 0 and (puid ?? device_id ?? yandexuid) is not null
);

$wrapChannel = ($channel) -> (IF($channel in ("UGC.", "Zen.", ""), NULL, $channel));

$inferred_channels = (
    select
        ugc_owner_id,
        MAX($wrapChannel(computed_channel)) ?? ("UGC.User " || CAST(ugc_owner_id as String)) as inferred_channel
    from $iron_branch
    where ugc_owner_id is not null
    group by ugc_owner_id
);

$uuid_to_channel = (
    select
        i.`UUID` as `UUID`,
        i.ugc_owner_id as ugc_owner_id,
        $wrapChannel(i.computed_channel) ?? ic.inferred_channel as channel,
        live_start_time,
        live_finish_time
    from (select * from $iron_branch where live_start_time is not null) as i
    left join $inferred_channels as ic on (i.ugc_owner_id = ic.ugc_owner_id)
);

$tmp_add_channels = (
    select
        t.*, channel, channel as channel_for_uniq, live_start_time, live_finish_time
    from $tmp as t
    inner join any $uuid_to_channel as u using (`UUID`)
);

$tmp_filter = (
    select * from $tmp_add_channels where (
        $mskDateFromTs(live_start_time) = fielddate
        or $mskDateFromTs(live_finish_time) = fielddate
    )
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "channel"), "channel", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "program"), "program", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "view_type"), "view_type", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "service"), "service", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

--юзеры, юзеры 30+, сессии, сессии 30+, твт, деньги, время столдов, для сессий со столдами

$grouped = (
    SELECT
        fielddate ?? "-" as fielddate,
        channel ?? "-" as channel,
        program ?? "-" as program,
        view_type ?? "-" as view_type,
        service ?? "-" as service,
        sum(price) / 1000000.0 as price,
        sum(stalled_duration) as stalled_duration,
        sum(view_time) as tvt,
        IF(channel != "_total_", null, CountDistinctEstimate(channel_for_uniq)) as unique_channels,
        IF(program != "_total_", null, CountDistinctEstimate(`UUID`)) as unique_programs,
        CountDistinctEstimate(user_id) as users,
        CountDistinctEstimate(IF(view_time >= 30, user_id)) as users_030s,
        CountDistinctEstimate(IF(view_time >= 4, user_id)) as users_004s,
        CountDistinctEstimate(IF(view_time >= 24, user_id)) as users_024s,
        CountDistinctEstimate(IF(view_time >= 60, user_id)) as users_060s,
        CountDistinctEstimate(IF(view_time >= 120, user_id)) as users_120s,
        CountDistinctEstimate(IF(view_time >= 180, user_id)) as users_180s,
        CountDistinctEstimate(IF(view_time >= 300, user_id)) as users_300s,
        CountDistinctEstimate(IF(view_time >= 600, user_id)) as users_600s,
        count(*) as sessions,
        count_if(view_time >= 30) as sessions_30s,
        
    from (process $tmp_filter using $totalize(TableRow()))
    group by fielddate,
        channel,
        program,
        view_type,
        service
);

upsert into stat.`Video/Others/Strm/live_cube/daily` ERASE BY (fielddate)
select * from $grouped;
