pragma library('stability_common.sql');
import stability_common symbols $getPlatform, $refFromWrapperSafe, $mockService;

use hahn;
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
pragma SimpleColumns;

-- @[graph_info]

$path = '//logs/strm-gogol-log/1d';
$from = "@[date_from]";
$to = "@[date]";

$getDouble = ($json, $fieldPath) -> {
    return Yson::ConvertToDouble(Yson::YPath(Yson::ParseJson($json), $fieldPath));
};

$totalizePlatform = ($x) -> {
    return IF(
        $x.platform like "StreamPlayer_%",
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_"),AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer_total") ],
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_")],
    )
};
$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "stream_type"), "stream_type", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "channel"), "channel", "_total_"))
        )
    );
    $add = ListFlatMap($result, $totalizePlatform);
    $result = ListUnionAll($result, $add);
    RETURN $result
};

$getStreamType = ($streamPath) -> {
    return case
    when $streamPath like '/kal/%' THEN "kal"
    when $streamPath like '/live/%' THEN "live"
    else "other"
    end;
};

$playerAlives = select 
   $getDouble(data, '/liveLatency') as live_latency,
   $getDouble(data, '/watchedTime') as watchedTime,
   $getStreamType(streamPath) as stream_type,
   TableName() as fielddate,
   $getPlatform(service ?? $mockService(labels_from), userAgent) ?? 'unknown' as platform,
   $refFromWrapperSafe(labels_from) as ref_from,
   streamBucket ?? 'unknown' as channel,
   vsid,
   videoContentId,
from range($path, $from, $to)
where
    eventType == 'event' and
    eventName == 'PlayerAlive' and
    $getDouble(data, '/liveLatency') is not null and
    $getDouble(data, '/watchedTime') is not null and
    streamBucket is not null and
    (service != 'AndroidPlayer' or (service == 'AndroidPlayer' and userAgent like '%zen%' and CAST(version AS Int32?) >= 284)) and
    videoContentId is not null;

$tvt = select 
    fielddate,
    platform,
    ref_from,
    channel,
    stream_type,
    max(watchedTime) as tvt,
    vsid,
    videoContentId,
from $playerAlives
group by fielddate,
    platform,
    ref_from,
    channel,
    stream_type,
    vsid,
    videoContentId;

$tvt = select 
    fielddate,
    platform,
    ref_from,
    channel,
    stream_type,
    sum(tvt) as tvt,
from (process $tvt using $totalize(TableRow()))
group by fielddate,
    platform,
    ref_from,
    channel,
    stream_type;


$ll = select 
    fielddate,
    platform,
    ref_from,
    channel,
    stream_type,
    PERCENTILE(live_latency, 0.1) as live_latency_p10,
    PERCENTILE(live_latency, 0.25) as live_latency_p25, 
    PERCENTILE(live_latency, 0.5) as live_latency_p50,
    PERCENTILE(live_latency, 0.75) as live_latency_p75,
    PERCENTILE(live_latency, 0.95) as live_latency_p95,
    PERCENTILE(live_latency, 0.99) as live_latency_p99,
from (process $playerAlives using $totalize(TableRow()))
group by fielddate,
    platform,
    ref_from,
    channel,
    stream_type;

$result = select 
    a.fielddate as fielddate,
    a.platform as platform,
    a.ref_from as ref_from,
    a.stream_type as stream_type,
    a.channel as channel,
    live_latency_p10,
    live_latency_p25, 
    live_latency_p50,
    live_latency_p75,
    live_latency_p95,
    live_latency_p99,
    tvt,
from $ll as a
join $tvt as b
using (channel, fielddate, platform, ref_from, stream_type);

upsert into stat.`@[report]/daily`
select 
    fielddate,
    platform,
    ref_from,
    channel,
    stream_type,
    live_latency_p10,
    live_latency_p25, 
    live_latency_p50,
    live_latency_p75,
    live_latency_p95,
    live_latency_p99,
    tvt,
from $result;
