USE hahn;
PRAGMA yson.Strict = "false";

$parseEventName = ($request)->{
    $argOffset = if($request like "%event=%", Find($request, "event="), Find($request, "error="));
    $startOffset = if($argOffset is not null, cast($argOffset + 6 as Uint32), null);
    $endOffset = if($startOffset is not null, Find($request, "&", $startOffset), null);
    return if($startOffset is not null, substring($request, $startOffset, $endOffset-$startOffset), "");
};

$parsePlatform = ($request)->{
    return case
        when $request like "%StreamPlayer%" then "StreamPlayer"
        when $request like "%AndroidPlayer%" then "AndroidPlayer"
        else "Unknown"
    end;
};

$parseVersion = ($request)->{
    $platform = $parsePlatform($request);
    $argOffset = Find($request, $platform);
    $startOffset = if($argOffset is not null, cast($argOffset + length($platform) + 1 as Uint32), null);
    $endOffset = if($startOffset is not null, Find($request, "&", $startOffset), null);
    return if($startOffset is not null, substring($request, $startOffset, $endOffset-$startOffset), "")
};

$countPerVcid = ($value, $vcid)->{
    return if($vcid > 0, $value * 1.0 / $vcid, null);
};

$from = "@[date_from]";
$to = "@[date]";

$data = (
    select proxy_req_size, process_time, $parseEventName(request) as eventName, 
    $parsePlatform(request) as platform,
    $parseVersion(request) as version,
    TableName() as fielddate
    from range("//logs/strm-balancer-access-log/1d", $from, $to)
    where domain == 'log.strm.yandex.ru' and proxy_reason == 'succ'
    and request like '/log%'
);

$totalSize = (
    select fielddate, platform, version, sum(proxy_req_size) as totalSize from $data
    group by fielddate, platform, version
);
$totalTime = (
    select fielddate, platform, version, sum(process_time) as totalTime from $data
    group by fielddate, platform, version
);

$vcidNumber = (
    select fielddate, platform, version, count_if(eventName == 'CreatePlayer' or eventName == 'SetSource') as vcids from $data
    group by fielddate, platform, version
);

$aggrData = (
    SELECT fielddate, eventName, platform, version, count(*) as logTimes, sum(proxy_req_size) as proxy_req_size, sum(process_time) as process_time
    from $data
    group by fielddate, eventName, platform, version
);

upsert into stat.`Video/Others/Strm/Stability/Logs_Balancer/daily`
SELECT data.fielddate,
    eventName as event_name, 
    data.platform as platform,
    data.version as version, 
    logTimes as log_times, 
    $countPerVcid(logTimes, vcids) as avg_vcid_log_times, 
    proxy_req_size, 
    $countPerVcid(proxy_req_size, vcids) as avg_vcid_req_size, 
    process_time, 
    $countPerVcid(process_time, vcids) as avg_vcid_process_time,
    vcids.vcids,
    data.proxy_req_size * 100.0 / size.totalSize as req_size_share,
    data.process_time * 100.0 / time.totalTime as process_time_share
    from $aggrData as data
    join any $totalTime as time on data.platform == time.platform and data.version == time.version and data.fielddate == time.fielddate
    join any $totalSize as size on data.platform == size.platform and data.version == size.version and data.fielddate == size.fielddate
    join any $vcidNumber as vcids on data.platform == vcids.platform and data.version == vcids.version and data.fielddate == vcids.fielddate
    where (data.proxy_req_size * 100 > size.totalSize or data.process_time * 100 > time.totalTime) and vcids > 10000;
