# Downlink, score, resolution
score_points = (
    (0.0, 0.0, "no video"),
    (0.9, 2.5, "360p"),
    (2.5, 4.5, "480p"),
    (5.0, 6.5, "720p"),
    (7.5, 8.0, "1080p"),
    (10.0, 10.0, "1440p"),
)

point_count = len(score_points)

max_dwl = 10.0
max_rtt = 3000.0


def calc_score(dwl, rtt=0):
    if dwl is None or rtt is None:
        return

    dwl_score = None

    dwl = min(dwl, max_dwl)
    rtt = min(rtt, max_rtt)

    for i in range(point_count - 1):
        min_val, min_score = score_points[i][0:2]
        max_val, max_score = score_points[i + 1][0:2]

        if dwl_score is None and dwl <= min_val:
            dwl_score = 0.0
            break

        if min_val < dwl <= max_val:
            dwl_position = float(dwl - min_val) / (max_val - min_val)
            dwl_score = min_score + dwl_position * (max_score - min_score)
            break

    if dwl_score is None:
        dwl_score = 10.0

    rtt_penalty = 3.0 * float(rtt) / max_rtt

    return max(0.0, dwl_score - rtt_penalty)
