
$dwScore = ($x, $maxDownlink, $downlinkBase, $dwQ) -> {
    $dw = MAX_OF(MIN_OF($x, $maxDownlink), 0.0);
    $y = MIN_OF(1 + $dw / $maxDownlink * $downlinkBase, $downlinkBase);
    RETURN $dwQ * Math::Log10($y) / Math::Log10($downlinkBase);
};

$rttPenalty = ($x, $maxRtt, $rttQ) -> {
    $rtt = MAX_OF(MIN_OF($x, $maxRtt), 0.0);
    RETURN $rttQ * $x / $maxRtt;
};

---

$formulaAccessBase5 = ($downlink, $rtt) -> {
    $maxDownlink = 10.0;
    $maxRtt = 3000.0;
    $downlinkBase = $maxDownlink * 50;
    $dwQ = 5.0;
    $rttQ = 1.2;

    return MAX_OF(
        0.0,
        $dwScore($downlink, $maxDownlink, $downlinkBase, $dwQ)
        - $rttPenalty($rtt, $maxRtt, $rttQ)
    )
};

$formulaAccessBase10 = ($downlink, $rtt) -> {
    $maxDownlink = 10.0;
    $maxRtt = 3000.0;
    $downlinkBase = $maxDownlink * 30;
    $dwQ = 10.0;
    $rttQ = 2.5;

    return MAX_OF(
        0.0,
        $dwScore($downlink, $maxDownlink, $downlinkBase, $dwQ)
        - $rttPenalty($rtt, $maxRtt, $rttQ)
    )
};

$formulaAccessBase10_3 = ($downlink, $rtt) -> {
    $maxDownlink = 10.0;
    $maxRtt = 3000.0;
    $downlinkBase = $maxDownlink * 30;
    $dwQ = 10.0;
    $rttQ = 3;

    return MAX_OF(
        0.0,
        $dwScore($downlink, $maxDownlink, $downlinkBase, $dwQ)
        - $rttPenalty($rtt, $maxRtt, $rttQ)
    )
};

$formulaAccessBase10_3_long = ($downlink, $rtt) -> {
    $maxDownlink = 10.0;
    $maxRtt = 3000.0;
    $downlinkBase = $maxDownlink * 2;
    $dwQ = 10.0;
    $rttQ = 3;

    return MAX_OF(
        0.0,
        $dwScore($downlink, $maxDownlink, $downlinkBase, $dwQ)
        - $rttPenalty($rtt, $maxRtt, $rttQ)
    )
};

$formulaChunksBase5 = ($downlink, $rtt) -> {
    $maxDownlink = 25.0;
    $maxRtt = 1000.0;
    $downlinkBase = $maxDownlink * 1000;
    $dwQ = 5.0;
    $rttQ = 1.2;

    return MAX_OF(
        0.0,
        $dwScore($downlink, $maxDownlink, $downlinkBase, $dwQ)
        - $rttPenalty($rtt, $maxRtt, $rttQ)
    )
};

$formulaChunksBase10 = ($downlink, $rtt) -> {
    $maxDownlink = 25.0;
    $maxRtt = 1000.0;
    $downlinkBase = $maxDownlink * 400;
    $dwQ = 10.0;
    $rttQ = 2.5;

    return MAX_OF(
        0.0,
        $dwScore($downlink, $maxDownlink, $downlinkBase, $dwQ)
        - $rttPenalty($rtt, $maxRtt, $rttQ)
    )
};

EXPORT $formulaAccessBase5, $formulaChunksBase5, $formulaAccessBase10, $formulaChunksBase10, $formulaAccessBase10_3, $formulaAccessBase10_3_long;