use hahn;

$input = "@[input_table]";
$table_dist = $input || "_distribution";
$table_map_desktop = "@[output_root]/map_desktop";
$table_map_mobile = "@[output_root]/map_mobile";
$table_prov_desktop = "@[output_root]/prov_desktop";
$table_prov_mobile = "@[output_root]/prov_mobile";

select * from $table_dist
limit 50;

$cities = (
    select
        reg_id,
        ru_nominative,
        latitude,
        longitude
    from `//home/geotargeting/public/geobase/regions`
    where type == 6 and country_id == 225
);
$cities_ids = select distinct reg_id from $cities;

define subquery $processed_input() as
select * from $input where region_id in $cities_ids or region_id == 225;
end define;

define subquery $data_desktop() as
select * from $processed_input() where not is_mobile;
end define;

define subquery $data_mobile() as
select * from $processed_input() where is_mobile;
end define;

define subquery $map_query($input_subquery) as

$tmp = (
    select
        region_id,
        AsTuple(score_30_median_median, users, isp) as isp_tup,
        users
    from $input_subquery() where region_id != 225
);

$getTotal = ($tups) -> {
    $total = ListFilter($tups, ($x)->($x.2 == "_total_"));
    return unwrap($total[0]).0
};

$strFromTup = ($tup) -> ($tup.2 || ";" || cast(Math::Round($tup.0, -1) as String));

$sortIsp = ($list) -> {
    RETURN ListSort(
        $list,
        ($x)->(AsTuple(-$x.0, -$x.1, $x.2))
    )
};

$getTop = ($tups) -> {
    $top = ListFilter($tups, ($x)->($x.2 != "_total_"));
    $p1 = IF(
        ListLength($top) >= 1,
        $strFromTup(unwrap($top[0])),
        null
    );
    $p2 = IF(
        ListLength($top) >= 2,
        $strFromTup(unwrap($top[1])),
        null
    );
    $p3 = IF(
        ListLength($top) >= 3,
        $strFromTup(unwrap($top[2])),
        null
    );
    return AsTuple($p1, $p2, $p3)
};

$get_top = (
    select
        region_id,
        sum(users) as sort,
        $getTotal($sortIsp(aggregate_list(isp_tup))) as score_30,
        $getTop($sortIsp(aggregate_list(isp_tup))).0 as provider_1,
        $getTop($sortIsp(aggregate_list(isp_tup))).1 as provider_2,
        $getTop($sortIsp(aggregate_list(isp_tup))).2 as provider_3,
    from $tmp
    group by region_id
);

$joined = (
    select t.*, ru_nominative as name_clean, longitude, latitude
    from $get_top as t
    inner join $cities as c on (t.region_id == c.reg_id)
);

select * from $joined;
end define;

DEFINE SUBQUERY $provider_query($input_subquery) as
select
    ru_nominative ?? "Россия" as name_clean,
    Math::Round(score_30_median_median, -1) as score_30,
    isp,
    users as sort,
from $input_subquery() as i
left join $cities as c on (i.region_id == c.reg_id)
end define;

insert into $table_map_desktop with truncate
select * from $map_query($data_desktop)
order by sort;

insert into $table_map_mobile with truncate
select * from $map_query($data_mobile)
order by sort;

insert into $table_prov_desktop with truncate
select * from $provider_query($data_desktop)
order by name_clean, sort;

insert into $table_prov_mobile with truncate
select * from $provider_query($data_mobile)
order by name_clean, sort;
