USE hahn;
pragma yt.Pool = '@[pool]';
-- pragma yt.DefaultOperationWeight = "100";
-- pragma yt.MaxJobCount = "99999";
-- pragma yt.DataSizePerJob = "256M";
PRAGMA Library('providers.sql');
IMPORT providers SYMBOLS $providers;
PRAGMA Library('mma_4376_prepare_data_chunks.sql');
IMPORT mma_4376_prepare_data_chunks SYMBOLS $prepare_data;
PRAGMA Library('formulae.sql');
IMPORT formulae SYMBOLS @[formula];

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$map_table = "@[map_table]";
$json_table = "@[json_table]";
$report_table = "@[report_table]";

$formula = @[formula];

$rft = select ToDict(AGGREGATE_LIST(AsTuple(region_id, regions_for_total))) from `//home/videoquality/vh_analytics/mma-4376/2020-03-01_2020-04-02/regions_for_total_fix2`;

$regionsForTotal = ($x) -> {
    RETURN IF(DictContains($rft, $x), unwrap($rft[$x]), ListCreate(Int32))
};

$totalize = ($row)->{
    $rft = $regionsForTotal(CAST($row.region_id as Int32));
    $result = ListMap(
        $rft, ($x)->(AddMember(RemoveMember($row, "region_id"), "region_id", $x))
    );
    $add = ListMap(
        $result,
        ($x)->(AddMember(RemoveMember($x, "isp"), "isp", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    return $result
};

$userAgentCheck = ($ua)->{
    $parsed = UserAgent::Parse($ua);
    RETURN (
        not $parsed.isTablet and not $parsed.isTV
    )
};

/*[NotReady]
$map_data = select * from $prepare_data($date_from, $date_to);

insert into $map_table with TRUNCATE
select * from $map_data;
[NotReady]*/
/*[Ready]
$map_data = select * from $map_table;
[Ready]*/

$tmp = (
    select
        region_id,
        connection_type,
        substring(fielddate, 0, 10) as fielddate,
        UserAgent::Parse(user_agent).isMobile as is_mobile,
        ip,
        operator as isp,
        downlink,
        rtt,
        -- ect,
        $formula(downlink, rtt) AS req_score_2,
    from $map_data
    WHERE
        $userAgentCheck(user_agent)
        AND operator IS NOT NULL
        AND operator != ''
);

$desktop = select * from $tmp where is_mobile == false and $providers[isp] ?? "none" not in ["Теле2", "Йота"];

$mobile_whitelist = [
    "МТС",
    "_total_",
    "Мегафон",
    "Билайн",
    "Теле2",
    "Йота",
    "Мотив Телеком",
    "Таттелеком"
];

$mobile = (
    select * from $tmp as t
    where is_mobile == true and connection_type == 'CONN_CELL' and $providers[isp] in $mobile_whitelist
);

$tmp_unified = (
    select * from $desktop
    union all
    select * from $mobile
);

$totalized = process $tmp_unified using $totalize(TableRow());

$top_by_day = (
    select
        region_id,
        fielddate,
        top_by(oper_tup, `count`, 10) as top_operators_raw,
        ToSet(ListMap(
            ListFilter(top_by(oper_tup, `count`, 10), ($x)->($x.1 >= 1000)),
            ($x)->($x.0)
        )) as top_operators
    from (
        select region_id, fielddate,
        AsTuple(isp, count(*)) as oper_tup, count(*) as `count`
        from $totalized
        group by region_id, fielddate, IF(
            DictContains($providers, isp),
            unwrap($providers[isp]),
            "Другие"
        ) as isp
    )
    group by region_id, fielddate
);


$for_json = (
    SELECT
        region_id,
        fielddate,
        isp,
        is_mobile,
        requests,
        score_30,
        -- p2g,
        -- p3g,
        -- p4g
    FROM (
        SELECT
            region_id,
            fielddate,
            isp,
            is_mobile,
            MAX_OF(0.0, MEDIAN(req_score_2)) AS score_30,
            -- sum(IF(ect == '2g', 100.0, 0.0)) / sum(1.0) AS p2g,
            -- sum(IF(ect == '3g', 100.0, 0.0)) / sum(1.0) AS p3g,
            -- sum(IF(ect == '4g', 100.0, 0.0)) / sum(1.0) AS p4g,
            COUNT(*) AS requests
        FROM $totalized as t
        left join $top_by_day as tbd using (region_id, fielddate)
        GROUP BY
            t.region_id as region_id,
            t.fielddate as fielddate,
            CASE
            WHEN DictContains($providers, isp) and (unwrap($providers[isp]) in tbd.top_operators or t.is_mobile) THEN unwrap($providers[isp])
            WHEN isp == "_total_" THEN "_total_"
            ELSE "Другие"
            END as isp,
            t.is_mobile as is_mobile
    )
    WHERE
        requests > 1000
);

INSERT INTO
    $json_table WITH TRUNCATE
select * from $for_json
ORDER BY
    region_id,
    fielddate,
    isp,
    is_mobile
;


$unique_region_ids = (
    select distinct region_id from $for_json
);

$region_names = (
    SELECT
        region_id,
        IF(
            Geo::RoundRegionById(region_id, "region").id == region_id,
            CAST(region_id as String) || " (РЕГИОН) " || Geo::RegionById(region_id).name,
            CAST(region_id as String) || " " || Geo::RoundRegionById(region_id, "region").name || ", " || Geo::RegionById(region_id).name
        ) as name
    from $unique_region_ids
);

$for_report = (
    select
        fielddate,
        isp,
        name as region_name,
        CAST(is_mobile as String) as is_mobile,
        score_30 as score,
        requests
    from $for_json as s
    inner join $region_names as r using (region_id)
    where isp is not null and isp != ""
);

insert into $report_table WITH TRUNCATE
select * from $for_report
order by fielddate, region_name, isp, is_mobile;
