use hahn;
PRAGMA yt.Pool = "@[pool]";
PRAGMA LIBRARY("mma_4376_prepare_data.sql");
IMPORT mma_4376_prepare_data SYMBOLS $prepare_data;
PRAGMA LIBRARY("stability_common.sql");
IMPORT stability_common SYMBOLS $dateRange;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$map_root = "@[map_root]";

$input_dates = $dateRange($date_from, $date_to);

$prepared = select * from $prepare_data($date_from, $date_to);

define action $map_date($date) as
$output_table = $map_root || "/" || $date;
insert into $output_table with truncate
select * from $prepared where substring(fielddate, 0, 10) == $date;
end define;

evaluate for $date in $input_dates
    do $map_date($date);
