use hahn;
pragma yt.Pool = "@[pool]";

$date_from = "@[date_from]";
$date_to = "@[date_to]";

$getChannel = ($chain) -> {
    $chain = Yson::ConvertToList($chain);
    $ch = ListReverse(ListFilter($chain, ($x)->(Yson::LookupInt64($x, "ContentTypeID") == 2)));
    return IF(
        ListLength($ch) > 0,
        unwrap(Yson::LookupString(unwrap($ch[0]), "Name")),
        null
    )
};

$channel_from_ib = (
    select
        JoinKey,
        $getChannel(chain) as channel
    from `//home/videolog/strm_meta/iron_branch/concat`
);

$tmp = (
    select
        fielddate,
        puid ?? yandexuid as user_id,
        video_content_id,
        price,
        shows_good,
        view_time
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where ref_from like 'yanews%'
);

$joined = (
    select
        t.*, channel ?? "-" as channel
    from $tmp as t
    inner join $channel_from_ib as ch on (t.video_content_id == ch.JoinKey)
);

$grouped = (
    select
        fielddate,
        channel,
        CountDistinctEstimate(video_content_id) as content_ids,
        CountDistinctEstimate(user_id) as users,
        count_if(view_time > 30) as microsessions_30,
        sum(view_time) as tvt,
        sum(price) / 1000000.0 as price_rub,
        sum(shows_good) as ad_shows
    from $joined
    group by unwrap(fielddate) as fielddate, unwrap(channel) as channel
);

upsert into stat.`@[report]/daily`
select * from $grouped;