use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common SYMBOLS $dateRange, $remappedWrapRefFrom;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[root]/report/" || $date_from || "_" || $date_to;

$range = $dateRange($date_from, $date_to);

$partner_remapped_wrap_ref_froms = ("other", "partner", "UNMAPPED");
$our_hosts = ("yandex.ru", "kinopoisk.ru");
$bad_vcids = AsList("novcid", "-", NULL, "");
$sourcesAggrTest = ($sources_aggr) -> {
    RETURN $sources_aggr LIKE "%heartbeat%" OR $sources_aggr LIKE "%start%"
};
$basicTest = ($video_content_id, $sa, $vtpl) -> {
    RETURN ($sourcesAggrTest($sa) or $vtpl > 0) AND ((NOT ListHas($bad_vcids, $video_content_id ?? "")))
};

$getChannel = ($chain) -> {
    $chain = ListReverse(Yson::ConvertToList($chain));
    $channels = ListFilter($chain, ($x)->(Yson::LookupInt64($x, "ContentTypeID") == 2));
    return AsTuple(
        Yson::LookupUint64($channels[0], "ContentGroupID"),
        Yson::LookupString($channels[0], "Name"),
        Yson::LookupString($chain[0], "Name"),
        Yson::LookupString($chain[0], "content_type_id_name"),
    )
};

$ib = "//home/videolog/strm_meta/iron_branch/concat";

$map = (
    select
        ContentGroupID,
        `UUID`,
        JoinKey,
        $getChannel(chain).0 as channel_id,
        $getChannel(chain).1 as channel_name,
        $getChannel(chain).2 as content_name,
        $getChannel(chain).3 as content_type,
        TMP_OvsServiceFlags like "%ya-video%" as published,
        green_url,
        Url::GetHost(green_url) as green_url_host
    from $ib
);

$unique_channel_ids = select aggregate_list_distinct(channel_id) from $map where green_url is not null;

$content_from_channels = (
    select m.*, channel_name as partner_name
    from $map as m
    where channel_id is not null and unwrap(channel_id) in unwrap($unique_channel_ids)
    and content_type in ("vod-broadcast-episode", "episode") and channel_name is not null
);

$videos_by_partner = (
    select
        partner_name,
        CountDistinctEstimate(ContentGroupID) ?? 0 as videos_partner,
        1 as partner_count,
        CountDistinctEstimate(IF(
            green_url is null
            or green_url == ""
            or green_url_host in $our_hosts,
            ContentGroupID
        )) ?? 0 as videos_bad,
        CountDistinctEstimate(IF(
            published, ContentGroupID
        )) as videos_published,
    from $content_from_channels
    group by partner_name
);

$videos_total = (
    select
        "_total_" as partner_name,
        CountDistinctEstimate(ContentGroupID) ?? 0 as videos_partner,
        CountDistinctEstimate(IF(
            green_url is null
            or green_url == ""
            or green_url_host in $our_hosts,
            ContentGroupID
        )) ?? 0 as videos_bad,
        CountDistinctEstimate(IF(
            published, ContentGroupID
        )) as videos_published,
        CountDistinctEstimate(partner_name) as partner_count
    from $content_from_channels
);

$videos_by_partner_merged = (
    select * from $videos_by_partner
    union all
    select * from $videos_total
);

$lvt = ($vt) -> (IF($vt >= 30, Math::Log(CAST($vt as Double)), 0));

$views = (
    select
        fielddate,
        partner_name,
        s.`UUID` as `UUID`,
        view_time,
        price,
        $lvt(view_time) as lvt,
        IF(
            $remappedWrapRefFrom(ref_from) in $partner_remapped_wrap_ref_froms,
            "external",
            "internal"
        ) as view_source
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    ) as s
    inner join $content_from_channels as e using (`UUID`)
    where $basicTest(
        video_content_id, sources_aggr, view_time_player_alive
    ) or price > 0
);

$clicks_map = (
    select
        TableName() as fielddate,
        ListReverse(String::SplitToList(`dict`["url"], "%2F"))[0] as video_content_id,
    from range(
        `logs/redir-log/1d`, $date_from, $date_to
    )
    where `dict`["path"] == "to-hosting..frontendvhyandexru.link"
);

$clicks_reduce1 = (
    select
        fielddate,
        video_content_id,
        count(*) as clicks
    from $clicks_map
    group by fielddate, video_content_id
);

$clicks_join = (
    select
        c.*,
        green_url_host,
        green_url,
        partner_name
    from $clicks_reduce1 as c
    inner join any $content_from_channels as m on (c.video_content_id == m.JoinKey)
);

$totalize = ($row) -> {
    RETURN AsList(
        $row,
        AddMember(RemoveMember($row, "partner_name"), "partner_name", "_total_")
    )
};

$views_totalized = (
    process $views using $totalize(TableRow())
);

$clicks_totalized = (
    process $clicks_join using $totalize(TableRow())
);

$views_grouped = (
    select
        fielddate,
        partner_name,
        CountDistinctEstimate(`UUID`) as videos_with_views,
        COUNT(*) as views,
        COUNT_IF(view_source == "external") as views_external,
        SUM(view_time) as tvt,
        SUM(price) as price,
        SUM(lvt) as lvt
    from $views_totalized
    group by fielddate, partner_name
);

$clicks_grouped = (
    select
        fielddate,
        partner_name,
        sum_if(clicks, green_url_host in $our_hosts) as clicks_ya,
        sum_if(clicks, green_url_host not in $our_hosts and green_url is not null and green_url != "") as clicks_external,
    from $clicks_totalized
    group by fielddate, partner_name
);

$for_report_main = (
    select *
    from (
        select
            s.*,
            $range as fielddate
        from $videos_by_partner_merged as s
    )
    flatten list by fielddate
);

$add_video_info = (
    select
        s.*,
        videos_with_views ?? 0 as videos_with_views,
        views ?? 0 as views,
        views_external ?? 0 as views_external,
        tvt ?? 0 as tvt,
        lvt ?? 0 as lvt,
        (price ?? 0) / 1000000.0 as price,
        clicks_ya ?? 0 as clicks_ya,
        clicks_external ?? 0 as clicks_external
    from $for_report_main as s
    left join any $views_grouped as v on (s.fielddate == v.fielddate and s.partner_name == v.partner_name)
    left join any $clicks_grouped as c on (s.fielddate == c.fielddate and s.partner_name == c.partner_name)
);

insert into $output_table with truncate
select * from $add_video_info;
